/*
 * Decompiled with CFR 0.152.
 */
package org.acmestudio.ui.analysis.performance.action;

import org.acmestudio.acme.ModelHelper;
import org.acmestudio.acme.core.IAcmeType;
import org.acmestudio.acme.core.type.IAcmeBooleanValue;
import org.acmestudio.acme.element.IAcmeElement;
import org.acmestudio.acme.element.IAcmeFamily;
import org.acmestudio.acme.element.IAcmeSystem;
import org.acmestudio.acme.element.property.IAcmeProperty;
import org.acmestudio.acme.type.AcmeTypeHelper;
import org.acmestudio.ui.analysis.performance.model.PerformanceModelManager;
import org.acmestudio.ui.analysis.performance.model.QNSystem;
import org.acmestudio.ui.analysis.performance.util.PerformanceException;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PerformanceAnalysisAction
implements IWorkbenchWindowActionDelegate {
    protected IAcmeSystem _system;
    protected IAcmeFamily _perfFam;

    public void run(IAction action) {
        if (!AcmeTypeHelper.satisfiesType((Object)this._system, (IAcmeType)this._perfFam)) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Performance error", (String)"The system does not satisfy the type PerformanceFam. Performance analysis not done.");
            return;
        }
        QNSystem sys = PerformanceModelManager.getQNSystem(this._system);
        if (sys != null) {
            sys.clearQnData();
        }
        try {
            sys = new QNSystem(this._system);
            sys.checkProps();
            sys.calculatePerformance();
            boolean overloaded = true;
            IAcmeProperty overloadedProp = this._system.getProperty("perf-overloaded");
            if (overloadedProp != null) {
                if (overloadedProp.getValue() != null) {
                    overloaded = ((IAcmeBooleanValue)overloadedProp.getValue()).getValue();
                } else {
                    overloaded = false;
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Performance result", (String)"The performance could not be calculated.");
                }
            }
            if (overloaded) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Performance result", (String)"The system is overloaded.");
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Performance result", (String)"The system is not overloaded.");
            }
        }
        catch (PerformanceException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Performance calculation could not complete. An exception was raised");
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iSel = (IStructuredSelection)selection;
            Object model = null;
            if (iSel.getFirstElement() instanceof EditPart) {
                model = ((EditPart)iSel.getFirstElement()).getModel();
            } else if (iSel.getFirstElement() instanceof IAcmeElement) {
                model = iSel.getFirstElement();
            }
            if (model != null && model instanceof IAcmeElement) {
                this._system = ModelHelper.getAcmeSystem((IAcmeElement)((IAcmeElement)model));
                if (this._system == null) {
                    action.setEnabled(false);
                    return;
                }
                Object fam = this._system.lookupName("PerformanceFam", true);
                if (fam != null && fam instanceof IAcmeFamily) {
                    action.setEnabled(this._system.declaresType((IAcmeFamily)fam));
                    this._perfFam = (IAcmeFamily)fam;
                } else {
                    action.setEnabled(false);
                }
            }
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

