function [boxes points] = testmodel_hier(name,model,test)

  boxes = cell(1,length(test));
  points = cell(1,length(test));
  for i = 1:length(test)
    fprintf([name ': testing: %d/%d\n'],i,length(test));
    im = imread(test(i).im);
    box = detect_hier(im,model,model.thresh);
    if ~isempty(box)
      boxes{i} = nms(box,0.5);
      for p = 1:floor(size(boxes{i},2)/4),
        cx1 = boxes{i}(:,1+(p-1)*4);
        cy1 = boxes{i}(:,2+(p-1)*4);
        cx2 = boxes{i}(:,3+(p-1)*4);
        cy2 = boxes{i}(:,4+(p-1)*4);
        
        points{i}(:,1+(p-1)*2) = (cx1+cx2)/2;
        points{i}(:,2+(p-1)*2) = (cy1+cy2)/2;
      end
    else
      boxes{i} = [];
      points{i} = [];
    end
  end
