function show_skele26(pts, thecolor, labeloff)
if ~exist('thecolor', 'var') || isempty(thecolor)
    thecolor = 'r';
end;
if ~exist('labeloff', 'var') || isempty(labeloff)
    labeloff = false;
end;

edges = [1, 2; 
         2, 3; 
         3, 4; 
         4, 5; 
         5, 6;
         6, 7;
         2, 15; 
         15, 16;
         16, 17;
         17, 18;
         18, 19;
         3, 8;
         8, 9;
         9, 10;
         10, 22;
         22, 21;
         21, 20;
         20, 15;
         10, 11;
         11, 12;
         12, 13;
         13, 14;
         22, 23;
         23, 24;
         24, 25;
         25, 26;];
      

hold on;

for i = 1:size(edges, 1)
    i1 = edges(i, 1);
    i2 = edges(i, 2);
    
    plot([pts(i1, 1), pts(i2, 1)], [pts(i1, 2), pts(i2, 2)], thecolor, 'LineWidth', 2);
end;
plot(pts(:, 1), pts(:, 2), [thecolor(1) 'o'], 'LineWidth', 1);

% head..
plot(pts(1, 1), pts(1, 2), [thecolor 'o'], 'LineWidth', 10);

if strcmp(labeloff, 'selected')
    for i = [1, 2, 7, 19, 14, 26]
        text(pts(i, 1), pts(i, 2), num2str(i), 'BackgroundColor', 'w');
    end;
elseif ~labeloff
    for i = 1:26
        text(pts(i, 1), pts(i, 2), num2str(i), 'BackgroundColor', 'w');
    end;
end;
hold off;