function [detRate_multi, PCP_multi, detRate, PCP, scores, scores_MAP] = save_detection(model, suffix, name, boxes, points, test, pcp_thres)
if ~exist('pcp_thres', 'var')
    pcp_thres = 0.5;
end;

[detRate_multi PCP_multi R_multi] = PARSE_eval_pcp_tydsh(name,points,test, pcp_thres);
[scores, strs] = compute_part_score(detRate_multi * R_multi);
fprintf('detRate=%.3f, PCP=%.3f, detRate*PCP=%.3f\n',detRate_multi,PCP_multi,detRate_multi*PCP_multi);
%save([cachedir name '_pcp_' suffix],'detRate_multi','PCP_multi','R');
print_part_score(strs, scores);

% if there is only one MAP solution, what is the MAP score?
points_map = get_MAP_detection(boxes);
[detRate PCP R] = PARSE_eval_pcp_tydsh(name,points_map,test, pcp_thres);
[scores_MAP, strs] = compute_part_score(detRate * R);
fprintf('MAP rate: detRate=%.3f, PCP=%.3f, detRate*PCP=%.3f\n',detRate,PCP,detRate*PCP);
print_part_score(strs, scores_MAP);

eval(sprintf('save model-%s-%s.mat model detRate_multi PCP_multi detRate PCP boxes points points_map;', name, suffix));
