function [score,Ix,Iy,Ik] = passmsg(child,parent)
% Given a 2D array of filter scores 'child',
% (1) Apply distance transform
% (2) Shift by anchor position of part wrt parent
% (3) Downsample if necessary
  INF    = 1e10;
    
  [resp_m_p, resp_n_p, ~] = size(parent.score);
  [resp_m_c, resp_n_c, ~] = size(child.score);
  
  child_resp_sizes = [resp_m_p, resp_n_p, child.K];
  parent_resp_sizes = [resp_m_c, resp_n_c, parent.K];
  
  score0 = repmat(-INF, child_resp_sizes);
  Ix0 = zeros(child_resp_sizes);
  Iy0 = zeros(child_resp_sizes);
  
  [score_tmp, Ix_tmp, Iy_tmp] = deal(zeros(child_resp_sizes));

  % do a distance transform, since w only depends on k..
  for k = 1:child.K
    [score_tmp(:, :, k),Ix_tmp(:, :, k),Iy_tmp(:, :, k)] = dt(child.score(:,:,k), child.w(1,k), child.w(2,k), child.w(3,k), child.w(4,k));
  end;
  
  % then 
  % At each parent location, for each parent mixture 1:L, compute best child mixture 1:K
  N = resp_m_p * resp_n_p;
  
  [score, Ix, Iy, Ik] = deal(zeros(parent_resp_sizes));
  i0 = reshape(1:N, resp_m_p, resp_n_p);
 
   % tydsh: the variables startx/starty/step already encodes the displacement of parents relative to its child.
  for l = 1:parent.K
    b = child.b(1,l,:);
    
    % starting points (shifts..)
    startx = child.startx(l);
    starty = child.starty(l);
    step   = child.step;
    % ending points
    endy = starty+step*(resp_m_p-1);
    endx = startx+step*(resp_n_p-1);
    endy = min(resp_m_c,endy);
    endx = min(resp_n_c,endx);
    % y sample points on the child resps..
    iy = starty:step:endy;
    % count how many is removed..add padding on the parent side.
    oy = sum(iy < 1);
    % remove those out of boundary...
    iy = iy(iy >= 1);
    
    % x sample points
    ix = startx:step:endx;
    ox = sum(ix < 1);
    ix = ix(ix >= 1);
    
    score0(:) = -INF;
    
    for k = 1:child.K
        % sample scores
        sp = score_tmp(iy,ix,k);
        sx = Ix_tmp(iy,ix,k);
        sy = Iy_tmp(iy,ix,k);
        sz = size(sp);
        % define msgs, add padding on the parent side..so basically for the prediction with out of boundary children, score0 should be -INF...
        iy_p  = oy+1:oy+sz(1);
        ix_p  = ox+1:ox+sz(2);

        score0(iy_p,ix_p,k) = sp;
        Ix0(iy_p,ix_p,k)    = sx;
        Iy0(iy_p,ix_p,k)    = sy;
    end;
    
    [score(:,:,l),I] = max(bsxfun(@plus,score0,b),[],3);
    i = i0 + N*(I-1);
    Ix(:,:,l)    = Ix0(i);
    Iy(:,:,l)    = Iy0(i);
    Ik(:,:,l)    = I;
    
  end    
