function [detRate PCP R] = parse_my_eval_pcp(est_ptsAll26, gt_ptsAll26)

% -------------------
% generate testing stick
I = [1   1   2   2   3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20];
J = [3   15  10  22  10 12 22 24 12 14 24 26 3  5  15 17 5  7  17 19 1  2];
S = [1/2 1/2 1/2 1/2 1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1  1];
A = full(sparse(I,J,S,20,26));

nTest = size(est_ptsAll26, 3);

for n = 1:nTest
    predstick(n).stickmen.coor = reshape( (A*est_ptsAll26(:, :, n))', 4, 10 );
    gtstick(n).stickmen.coor = reshape( (A*gt_ptsAll26(:, :, n))', 4, 10 );
end

% the PCP evaluation function originally comes from BUFFY dataset, we keep using that for performance evaluation
[detRate PCP R] = eval_pcp('PARSE', predstick,gtstick);
