function [components,filters,resp] = modelcomponents(model,pyra)
% Cache various statistics from the model data structure for later use  
  components = cell(length(model.components),1);
  for c = 1:length(model.components),
      % in reverse order...
    for k = length(model.components{c}):-1:1
      p = model.components{c}(k);
      [p.sizy,p.sizx,p.w,p.defI,p.filterI,p.starty,p.startx,p.step,p.level,p.Ix,p.Iy ] = deal([]);
      [p.scale,p.level,p.Ix,p.Iy] = deal(0);
 
      % store the scale of each part relative to the component root
      par = p.parent;      
      % for hierarchical, the order is reversed..
      assert(par == 0 || par > k);
      p.b = [model.bias(p.biasid).w];
      p.b = reshape(p.b,[1 size(p.biasid)]);
      p.biasI = [model.bias(p.biasid).i];
      p.biasI = reshape(p.biasI,size(p.biasid));
      
      for f = 1:length(p.filterid)
        x = model.filters(p.filterid(f));
        [p.sizy(f) p.sizx(f) foo] = size(x.w);
        p.filterI(f) = x.i;
      end
      
      for f = 1:length(p.defid)	 % of size children
        x = model.defs(p.defid(f));
        p.w(:,f)  = x.w';
        p.defI(f) = x.i;
      end;
      
      if par > 0
          parent_n_mixture = model.components{c}(par).K;
        
          for l = 1:parent_n_mixture
              ax  = p.anchors(1,l);
              ay  = p.anchors(2,l);    
              ds  = p.anchors(3,l);
              p.scale = ds + components{c}(par).scale;
              % amount of (virtual) padding to hallucinate (should be constant over all l, f)
              step     = 2^ds;
              virtpady = (step-1)*pyra.pady;
              virtpadx = (step-1)*pyra.padx;
              % starting points (simulates additional padding at finer scales)
              % tydsh:  ax and ay are anchers (relative displacement between parent and child), 
              %         virtpad x/y are additional displacement caused by building pyramid. (The margin lost in building pyramid)
              p.starty(l) = ay-virtpady;
              p.startx(l) = ax-virtpadx;
              p.step   = step;
          end;
      end;
      components{c}(k) = p;
    end
  end
  
  resp    = cell(length(pyra.feat),1);
  filters = cell(length(model.filters),1);
  for i = 1:length(filters),
    filters{i} = model.filters(i).w;
  end
  