function locs_interp = interp_skeleton(locs, N)
% put N interpolated points between consecutive points
[nPart, ndim, nSample] = size(locs);

ts = linspace(0, 1, N+1);
ts = ts(2:N+1);

locs_interp = zeros(nPart, ndim, (nSample-1)*N);

for i = 1:nSample-1
    p1 = locs(:, :, i);
    p2 = locs(:, :, i+1);
    
    for j = 1:N
        locs_interp(:, :, (i-1) * N + j) = p1 * (1 - ts(j)) + p2 * ts(j);
    end;    
end;
