function [res, dx, dy] = defvector(px,py,pmix,x,y,mix,part)
% Compute the deformation feature given parent locations, 
% child locations, the child part and the parent part..
% 
% startx/starty is the displacement between the parent and the child.
% dx and dy are the difference between the estimated location of a child, and the actual location of a child.
  probex = ( (px-1)*part.step + part.startx(pmix) );
  probey = ( (py-1)*part.step + part.starty(pmix) );
  dx  = probex - x;
  dy  = probey - y;
  res = -[dx^2 dx dy^2 dy]';
