function parts = boxes2parts(boxes)
if isempty(boxes)
    parts = [];
    return;
end;

nparts = floor(size(boxes, 2) / 4);

parts = zeros(nparts, 2);

for i = 1:nparts
    parts(i, 1) = (boxes(1 + (i-1)*4) + boxes(3 + (i-1)*4)) / 2;
    parts(i, 2) = (boxes(2 + (i-1)*4) + boxes(4 + (i-1)*4)) / 2;
end;