function [box,ex,ptr] = backtrack(x,y,mix,parts,pyra,ex,write)
% Backtrack through dynamic programming messages to estimate part locations
% and the associated feature vector 
  numparts = length(parts);
  nLeaves = 0;
  
  ptr = zeros(numparts,3);
  k   = numparts;
  p   = parts(k);
  ptr(k,:) = [x y mix];
  
  if ~isempty(p.filterI)
      nLeaves = nLeaves + 1;
  end;
  
  if write,
    %ex.id(3:5) = [p.level round(x+p.sizx(mix)/2) round(y+p.sizy(mix)/2)];
    % this may have problems...
    ex.id(3:5) = [p.level x y];
    ex.blocks = [];
    ex.blocks(end+1).i = p.biasI;
    ex.blocks(end).x   = 1;
    % in the hierarchical model, the root node has no feature...
    if ~isempty(p.filterI)
        f  = pyra.feat{p.level}(y:y+p.sizy(mix)-1,x:x+p.sizx(mix)-1,:);
        ex.blocks(end+1).i = p.filterI(mix);
        ex.blocks(end).x   = f;
    end;
  end
  % for hier strcture, the order is reversed..
  for k = numparts-1:-1:1,
      %fprintf(1, 'deal with part = %d\n', k);
    p   = parts(k);
    par = p.parent;
    x   = ptr(par,1);
    y   = ptr(par,2);
    mix = ptr(par,3);
    ptr(k,1) = p.Ix(y,x,mix);
    ptr(k,2) = p.Iy(y,x,mix);
    ptr(k,3) = p.Ik(y,x,mix);

    if ~isempty(p.filterI)
        nLeaves = nLeaves + 1;
    end;

    if write
      ex.blocks(end+1).i = p.biasI(mix,ptr(k,3));
      ex.blocks(end).x   = 1;
      ex.blocks(end+1).i = p.defI(ptr(k,3));
      ex.blocks(end).x   = defvector(x,y,mix,ptr(k,1),ptr(k,2),ptr(k,3),p);
      x   = ptr(k,1);
      y   = ptr(k,2);
      mix = ptr(k,3);
      if ~isempty(p.filterI)
          % only for leaf node~
        f   = pyra.feat{p.level}(y:y+p.sizy(mix)-1,x:x+p.sizx(mix)-1,:);
        ex.blocks(end+1).i = p.filterI(mix);
        ex.blocks(end).x = f;
      end;
    end
  end
  
% compute the bbox from ptr...
% leaves always go from the front..
box = zeros(4, nLeaves);

for i = 1:nLeaves
    p = parts(i);
    scale = pyra.scale(p.level);
    x   = ptr(i, 1);
    y   = ptr(i, 2);
    mix = ptr(i, 3);
    
    x1  = (x - 1 - pyra.padx)*scale+1;
    y1  = (y - 1 - pyra.pady)*scale+1;
    x2  = x1 + p.sizx(mix)*scale - 1;
    y2  = y1 + p.sizy(mix)*scale - 1;
    box(:, i) = [x1 y1 x2 y2]';
end;
box = reshape(box, 1, 4*nLeaves);
