#####################################################################
# Before implementing CFR, it will be helpful to take a look
# at the helper methods in game.py. These are the methods you
# need to interact with when you traverse the game tree in
# CFR.
#####################################################################
import sys
from game import Game


######################################################
# Add any classes or helper functions you want here
######################################################


# game will be an instance of Game, which is defined in game.py
# num_iterations is the number of PureCFR/MCCFR iterations you should perform.
# An iteration of PureCFR/MCCFR is one traversal of the entire game tree for each player
def solve_game(game, num_iterations):
#############################
    # The goal of your algorithm is to fill
    # strategy_profile with equilibrium strategies.
    # strategy_profile[p][i][a] should return
    # the probability of player p choosing the particular
    # action a at information set i in the equilibrium
    # you compute.
    #
    # An example set of values for a small game with 2
    # information sets for each player would be:
    #    strategy_profile[0][0] = [0.375, 0.625]
    #    strategy_profile[0][1] = [1,0]
    #
    #    strategy_profile[1][0] = [0.508929, 0.491071]
    #    strategy_profile[1][1] = [0.666667, 0.333333]
    strategy_profile = {0:{}, 1:{}}

    #######################
    # Implement PureCFR or MCCFR in here
    #######################

    return strategy_profile




if __name__ == "__main__":
    # feel free to add any test code you want in here. It will not interfere with our testing of your code.
    # currently, this file can be invoked with:
    # python cfr.py <path/to/gamefile> <num PureCFR/MCCFR iterations>

    filename = sys.argv[1]
    iterations = int(sys.argv[2])

    game = Game()
    game.read_game_file(filename)

    strategy_profile = solve_game(game, iterations)
    #print "Expected Value: " + str(game.compute_strategy_profile_ev(strategy_profile))
    print "Exploitability: " + str(game.compute_strategy_profile_exp(strategy_profile))
