{***********************************************************************
*                                                                      *
*       dvdCSS_Auth.pas                                                *
*                                                                      *
*         Thanks to Derek Fawcus for the orginal C++ code.             *
*                                                                      *
*         Delphi 7 translation by Bruce Christensen.                   *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}
//
// Copyright (C) 1999 Derek Fawcus <derek@spider.com>
//
// This code may be used under the terms of Version 2 of the GPL,
// read the file COPYING for details.
//

unit dvdCSS_Auth ;

Interface
  Type
    TCSS_Key = Array[0..4] of Byte ; // 40-bit value, MSB is first elem.

    TChallenge = Array[0..9] of Byte ;

    TChallengeKey = Array[0..11] of Byte ;

    TDiskKey = Array[0..2047] of Char ;

    TBits = Array[0..29] of Byte ;
    
  Procedure CryptKey1(    Varient   : Integer    ;
                          Challenge : TChallenge ;
                      Var Key       : TCSS_Key    ) ;

  Procedure CryptKey2(    Varient   : Integer    ;
                          Challenge : TChallenge ;
                      Var Key       : TCSS_Key    ) ;

  Procedure Engine(    Varient : Integer    ;
                       input   : TChallenge ;
                   Var output  : TCSS_Key    ) ;

  Procedure Generate_Bits(Var Output : TBits    ;
                              Len    : Integer  ;
                              s      : TCSS_Key  ) ;

Implementation
  Uses Dialogs , SysUtils;
  
Const
  Varients : Array[0..31] of Byte = ($B7, $74, $85, $D0, $CC, $DB, $CA, $73,
                                     $03, $FE, $31, $03, $52, $E0, $B7, $42,
                                     $63, $16, $F2, $2A, $79, $52, $FF, $1B,
                                     $7A, $11, $CA, $1A, $9B, $40, $AD, $01 ) ;

  Secret : Array[0..4] of Byte = ($55 , $D6, $C4, $C5, $28) ;

  Table0 : Array[0..255] of Byte =
             ($B7, $F4, $82, $57, $DA, $4D, $DB, $E2,
              $2F, $52, $1A, $A8, $68, $5A, $8A, $FF,
              $FB, $0E, $6D, $35, $F7, $5C, $76, $12,
              $CE, $25, $79, $29, $39, $62, $08, $24,
              $A5, $85, $7B, $56, $01, $23, $68, $CF,
              $0A, $E2, $5A, $ED, $3D, $59, $B0, $A9,
              $B0, $2C, $F2, $B8, $EF, $32, $A9, $40,
              $80, $71, $AF, $1E, $DE, $8F, $58, $88,
              $B8, $3A, $D0, $FC, $C4, $1E, $B5, $A0,
              $BB, $3B, $0F, $01, $7E, $1F, $9F, $D9,
              $AA, $B8, $3D, $9D, $74, $1E, $25, $DB,
              $37, $56, $8F, $16, $BA, $49, $2B, $AC,
              $D0, $BD, $95, $20, $BE, $7A, $28, $D0,
              $51, $64, $63, $1C, $7F, $66, $10, $BB,
              $C4, $56, $1A, $04, $6E, $0A, $EC, $9C,
              $D6, $E8, $9A, $7A, $CF, $8C, $DB, $B1,
              $EF, $71, $DE, $31, $FF, $54, $3E, $5E,
              $07, $69, $96, $B0, $CF, $DD, $9E, $47,
              $C7, $96, $8F, $E4, $2B, $59, $C6, $EE,
              $B9, $86, $9A, $64, $84, $72, $E2, $5B,
              $A2, $96, $58, $99, $50, $03, $F5, $38,
              $4D, $02, $7D, $E7, $7D, $75, $A7, $B8,
              $67, $87, $84, $3F, $1D, $11, $E5, $FC,
              $1E, $D3, $83, $16, $A5, $29, $F6, $C7,
              $15, $61, $29, $1A, $43, $4F, $9B, $AF,
              $C5, $87, $34, $6C, $0F, $3B, $A8, $1D,
              $45, $58, $25, $DC, $A8, $A3, $3B, $D1,
              $79, $1B, $48, $F2, $E9, $93, $1F, $FC,
              $DB, $2A, $90, $A9, $8A, $3D, $39, $18,
              $A3, $8E, $58, $6C, $E0, $12, $BB, $25,
              $CD, $71, $22, $A2, $64, $C6, $E7, $FB,
              $AD, $94, $77, $04, $9A, $39, $CF, $7C ) ;

  Table1 : Array[0..255] of Byte =
             ($8C, $47, $B0, $E1, $EB, $FC, $EB, $56,
              $10, $E5, $2C, $1A, $5D, $EF, $BE, $4F,
              $08, $75, $97, $4B, $0E, $25, $8E, $6E,
              $39, $5A, $87, $53, $C4, $1F, $F4, $5C,
              $4E, $E6, $99, $30, $E0, $42, $88, $AB,
              $E5, $85, $BC, $8F, $D8, $3C, $54, $C9,
              $53, $47, $18, $D6, $06, $5B, $41, $2C,
              $67, $1E, $41, $74, $33, $E2, $B4, $E0,
              $23, $29, $42, $EA, $55, $0F, $25, $B4,
              $24, $2C, $99, $13, $EB, $0A, $0B, $C9,
              $F9, $63, $67, $43, $2D, $C7, $7D, $07,
              $60, $89, $D1, $CC, $E7, $94, $77, $74,
              $9B, $7E, $D7, $E6, $FF, $BB, $68, $14,
              $1E, $A3, $25, $DE, $3A, $A3, $54, $7B,
              $87, $9D, $50, $CA, $27, $C3, $A4, $50,
              $91, $27, $D4, $B0, $82, $41, $97, $79,
              $94, $82, $AC, $C7, $8E, $A5, $4E, $AA,
              $78, $9E, $E0, $42, $BA, $28, $EA, $B7,
              $74, $AD, $35, $DA, $92, $60, $7E, $D2,
              $0E, $B9, $24, $5E, $39, $4F, $5E, $63,
              $09, $B5, $FA, $BF, $F1, $22, $55, $1C,
              $E2, $25, $DB, $C5, $D8, $50, $03, $98,
              $C4, $AC, $2E, $11, $B4, $38, $4D, $D0,
              $B9, $FC, $2D, $3C, $08, $04, $5A, $EF,
              $CE, $32, $FB, $4C, $92, $1E, $4B, $FB,
              $1A, $D0, $E2, $3E, $DA, $6E, $7C, $4D,
              $56, $C3, $3F, $42, $B1, $3A, $23, $4D,
              $6E, $84, $56, $68, $F4, $0E, $03, $64,
              $D0, $A9, $92, $2F, $8B, $BC, $39, $9C,
              $AC, $09, $5E, $EE, $E5, $97, $BF, $A5,
              $CE, $FA, $28, $2C, $6D, $4F, $EF, $77,
              $AA, $1B, $79, $8E, $97, $B4, $C3, $F4 ) ;

  Table2 : Array[0..255] of Byte =
             ($B7, $75, $81, $D5, $DC, $CA, $DE, $66,
              $23, $DF, $15, $26, $62, $D1, $83, $77,
              $E3, $97, $76, $AF, $E9, $C3, $6B, $8E,
              $DA, $B0, $6E, $BF, $2B, $F1, $19, $B4,
              $95, $34, $48, $E4, $37, $94, $5D, $7B,
              $36, $5F, $65, $53, $07, $E2, $89, $11,
              $98, $85, $D9, $12, $C1, $9D, $84, $EC,
              $A4, $D4, $88, $B8, $FC, $2C, $79, $28,
              $D8, $DB, $B3, $1E, $A2, $F9, $D0, $44,
              $D7, $D6, $60, $EF, $14, $F4, $F6, $31,
              $D2, $41, $46, $67, $0A, $E1, $58, $27,
              $43, $A3, $F8, $E0, $C8, $BA, $5A, $5C,
              $80, $6C, $C6, $F2, $E8, $AD, $7D, $04,
              $0D, $B9, $3C, $C2, $25, $BD, $49, $63,
              $8C, $9F, $51, $CE, $20, $C5, $A1, $50,
              $92, $2D, $DD, $BC, $8D, $4F, $9A, $71,
              $2F, $30, $1D, $73, $39, $13, $FB, $1A,
              $CB, $24, $59, $FE, $05, $96, $57, $0F,
              $1F, $CF, $54, $BE, $F5, $06, $1B, $B2,
              $6D, $D3, $4D, $32, $56, $21, $33, $0B,
              $52, $E7, $AB, $EB, $A6, $74, $00, $4C,
              $B1, $7F, $82, $99, $87, $0E, $5E, $C0,
              $8F, $EE, $6F, $55, $F3, $7E, $08, $90,
              $FA, $B6, $64, $70, $47, $4A, $17, $A7,
              $B5, $40, $8A, $38, $E5, $68, $3E, $8B,
              $69, $AA, $9B, $42, $A5, $10, $01, $35,
              $FD, $61, $9E, $E6, $16, $9C, $86, $ED,
              $CD, $2E, $FF, $C4, $5B, $A0, $AE, $CC,
              $4B, $3B, $03, $BB, $1C, $2A, $AC, $0C,
              $3F, $93, $C7, $72, $7A, $09, $22, $3D,
              $45, $78, $A9, $A8, $EA, $C9, $6A, $F7,
              $29, $91, $F0, $02, $18, $3A, $4E, $7C ) ;

  Table3 : Array[0..287] of Byte =
             ($73, $51, $95, $E1, $12, $E4, $C0, $58,
              $EE, $F2, $08, $1B, $A9, $FA, $98, $4C,
              $A7, $33, $E2, $1B, $A7, $6D, $F5, $30,
              $97, $1D, $F3, $02, $60, $5A, $82, $0F,
              $91, $D0, $9C, $10, $39, $7A, $83, $85,
              $3B, $B2, $B8, $AE, $0C, $09, $52, $EA,
              $1C, $E1, $8D, $66, $4F, $F3, $DA, $92,
              $29, $B9, $D5, $C5, $77, $47, $22, $53,
              $14, $F7, $AF, $22, $64, $DF, $C6, $72,
              $12, $F3, $75, $DA, $D7, $D7, $E5, $02,
              $9E, $ED, $DA, $DB, $4C, $47, $CE, $91,
              $06, $06, $6D, $55, $8B, $19, $C9, $EF,
              $8C, $80, $1A, $0E, $EE, $4B, $AB, $F2,
              $08, $5C, $E9, $37, $26, $5E, $9A, $90,
              $00, $F3, $0D, $B2, $A6, $A3, $F7, $26,
              $17, $48, $88, $C9, $0E, $2C, $C9, $02,
              $E7, $18, $05, $4B, $F3, $39, $E1, $20,
              $02, $0D, $40, $C7, $CA, $B9, $48, $30,
              $57, $67, $CC, $06, $BF, $AC, $81, $08,
              $24, $7A, $D4, $8B, $19, $8E, $AC, $B4,
              $5A, $0F, $73, $13, $AC, $9E, $DA, $B6,
              $B8, $96, $5B, $60, $88, $E1, $81, $3F,
              $07, $86, $37, $2D, $79, $14, $52, $EA,
              $73, $DF, $3D, $09, $C8, $25, $48, $D8,
              $75, $60, $9A, $08, $27, $4A, $2C, $B9,
              $A8, $8B, $8A, $73, $62, $37, $16, $02,
              $BD, $C1, $0E, $56, $54, $3E, $14, $5F,
              $8C, $8F, $6E, $75, $1C, $07, $39, $7B,
              $4B, $DB, $D3, $4B, $1E, $C8, $7E, $FE,
              $3E, $72, $16, $83, $7D, $EE, $F5, $CA,
              $C5, $18, $F9, $D8, $68, $AB, $38, $85,
              $A8, $F0, $A1, $73, $9F, $5D, $19, $0B,
              $00, $00, $00, $00, $00, $00, $00, $00,
              $33, $72, $39, $25, $67, $26, $6D, $71,
              $36, $77, $3C, $20, $62, $23, $68, $74,
              $C3, $82, $C9, $15, $57, $16, $5D, $81 ) ;

{***********************************************************************
*                                                                      *
*       CryptKey1                                                      *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}

Procedure CryptKey1(    Varient   : Integer    ;
                        Challenge : TChallenge ;
                    Var Key       : TCSS_Key    ) ;
  Const
    Perm_Challenge : TChallenge = (1,3,0,7,5, 2,9,6,4,8) ;

  Var
    nI : Integer ;
    Scratch : TChallenge ;

  Begin  { CryptKey1 }
    For nI := 9 downto 0 do
      Scratch[nI] := Challenge[Perm_Challenge[nI]] ;

    Engine(Varient , Scratch , Key) ;
  End ;  { CryptKey1 }


{***********************************************************************
*                                                                      *
*       CryptKey2                                                      *
*                                                                      *
*         This shuffles the bits in varient to make perm_varient       *
*       such that:                                                     *
*                          4 -> !3                                     *
*                          3 ->  4                                     *
*           varient bits:  2 ->  0  perm_varient bits                  *
*                          1 ->  2                                     *
*                          0 -> !1                                     *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}

Procedure CryptKey2(    Varient   : Integer    ;
                        Challenge : TChallenge ;
                    Var Key       : TCSS_Key    ) ;
  Const
    Perm_Challenge : TChallenge = (6,1,9,3,8, 5,7,4,0,2) ;

    Perm_Varient : Array[0..31] of Byte =
                     ($0a, $08, $0e, $0c, $0b, $09, $0f, $0d,
                      $1a, $18, $1e, $1c, $1b, $19, $1f, $1d,
                      $02, $00, $06, $04, $03, $01, $07, $05,
                      $12, $10, $16, $14, $13, $11, $17, $15 ) ;

  Var
    nI : Integer ;

    Scratch : TChallenge ;

  Begin  { CryptKey2 }
    For nI := 9 downto 0 do
      Scratch[nI] := Challenge[Perm_Challenge[nI]] ;

    Engine(Perm_Varient[Varient] , Scratch , Key) ;
  End ;  { CryptKey2 }


{***********************************************************************
*                                                                      *
*       CryptBusKey                                                    *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}

Procedure CryptBusKey(    Varient   : Integer    ;
                          Challenge : TChallenge ;
                      Var Key       : TCSS_Key    ) ;
  Const
    Perm_Challenge : TChallenge = (4,0,3,5,7, 2,8,6,1,9) ;

    Perm_Varient : Array[0..31] of Byte =
                     ($12, $1a, $16, $1e, $02, $0a, $06, $0e,
                      $10, $18, $14, $1c, $00, $08, $04, $0c,
                      $13, $1b, $17, $1f, $03, $0b, $07, $0f,
                      $11, $19, $15, $1d, $01, $09, $05, $0d ) ;
  Var
    nI : Integer ;
    Scratch : TChallenge ;

  Begin  { CryptBusKey }
    For nI := 9 downto 0 do
      Scratch[nI] := Challenge[Perm_challenge[nI]] ;

    Engine(Perm_varient[Varient] , Scratch , Key) ;
  End ;  { CryptBusKey }


{***********************************************************************
*                                                                      *
*       NotByte                                                        *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}

Function NotByte(nByte : Byte) : Byte ;
  Begin  { NotByte }
    If nByte = 0 then
      Result := 1
    Else
      Result := 0 ;
  End ;  { NotByte }

{***********************************************************************
*                                                                      *
*       Generate_Bits                                                  *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}

Procedure Generate_Bits(Var Output : TBits    ;
                            Len    : Integer  ;
                            s      : TCSS_Key  ) ;
  Var
    nI : Integer ;
    
    lfsr0 ,
    lfsr1   : Cardinal ;

    Carry : Byte ;

    bit : Integer ;
    val : Byte    ;

    o_lfsr0 , o_lfsr1 : Byte ;	// Actually only 1 bit each

    combined : Byte ;

  Begin  { Generate_Bits }
    //  In order to ensure that the LFSR works we need to ensure that the
    //  initial values are non-zero.  Thus when we initialise them from
    //  the seed,  we ensure that a bit is set.

    lfsr0 := (s[0] shl 17) or (s[1] shl 9) or ((s[2] and ($F8)) shl 1) or 8 or (s[2] and 7) ;
    lfsr1 := (s[3] shl 9) or $100 or s[4] ;

    Carry := 0 ;

    For nI := 29 downto 0 do
      Begin
        Val   := 0 ;

        For  bit := 0 to 7 do  // (bit = 0, val = 0; bit < 8; ++bit) {
          Begin
            o_lfsr0 := ((lfsr0 shr 24) xor
                        (lfsr0 shr 21) xor
                        (lfsr0 shr 20) xor
                        (lfsr0 shr 12)    ) and 1 ;
            lfsr0 := (lfsr0 shl 1) or o_lfsr0 ;

            o_lfsr1 := ((lfsr1 shr 16) xor (lfsr1 shr 2)) and 1 ;
            lfsr1 := (lfsr1 shl 1) or o_lfsr1 ;

            Combined := NotByte(o_lfsr1) + carry + NotByte(o_lfsr0) ;
            Carry    := ((Combined shr 1) and 1) ;
            Val      := Val or ((Combined and 1) shl bit) ;
          End ;

        Output[nI] := Val ;
      End ;
  End ;


{***********************************************************************
*                                                                      *
*       Engine                                                         *
*                                                                      *
*       Modifications                                                  *
*       ===============                                                *
*                                                                      *
***********************************************************************}

Procedure Engine(    Varient : Integer    ;
                     input   : TChallenge ;
                 Var output  : TCSS_Key    ) ;
  Var
    cse, term, index : Byte ;

    temp1 : TCSS_Key ;
    temp2 : TCSS_Key ;

    bits : TBits ;

    nI : Integer ;

  Begin  { Engine }
    // Feed the secret into the input values such that
    // we alter the seed to the LFSR's used above,  then
    // generate the bits to play with.
    For nI := 4 downto 0 do
      temp1[nI] := input[5 + nI] xor Secret[nI] xor Table2[nI] ;

    Generate_bits(bits , SizeOf(Bits) , Temp1) ;

    // This term is used throughout the following to
    // select one of 32 different variations on the
    // algorithm.

    cse := Varients[varient] xor Table2[varient] ;

    // Now the actual blocks doing the encryption.  Each
    // of these works on 40 bits at a time and are quite
    // similar.

    term := 0 ;
    For nI := 4 downto 0 do // (i = 5, term = 0; --i >= 0; term = input[i])
      Begin
        index     := bits[25 + nI] xor input[nI] ;
        index     := Table1[index] xor (not Table2[index]) xor cse ;  // ???????
        temp1[nI] := Table2[index] xor Table3[index] xor term ;

        term := Input[nI] ;
      End ;

    temp1[4] := temp1[4] xor temp1[0] ;

    term := 0 ;
    For nI := 4 downto 0 do  // (i = 5, term = 0; --i >= 0; term = temp1.b[i])
      Begin
        index := bits[20 + nI] xor temp1[nI] ;
        index := Table1[index] xor (not Table2[index]) xor cse ;

        temp2[nI] := Table2[index] xor Table3[index] xor term ;

        term := temp1[nI] ;
      End ;

    temp2[4] := temp2[4] xor temp2[0] ;

    term := 0 ;
    For nI := 4 downto 0 do  // (i = 5, term = 0; --i >= 0; term = temp2.b[i])
      Begin
        index := bits[15 + nI] xor temp2[nI] ;
        index := Table1[index] xor (not Table2[index]) xor cse ;
        index := Table2[index] xor Table3[index] xor term ;

        temp1[nI] := Table0[index] xor Table2[index] ;

        term := temp2[nI] ;
      End ;

    temp1[4] := temp1[4] xor temp1[0] ;

    term := 0 ;
    For nI := 4 downto 0 do  // (i = 5, term = 0; --i >= 0; term = temp1.b[i])
      Begin
        index := bits[10 + nI] xor temp1[nI] ;
        index := Table1[index] xor (not Table2[index]) xor cse;

        index := Table2[index] xor Table3[index] xor term ;

        temp2[nI] := Table0[index] xor Table2[index] ;

        term := temp1[nI] ;
      End ;

    temp2[4] := temp2[4] xor temp2[0] ;

    term := 0 ;
    For nI := 4 downto 0 do  // (i = 5, term = 0; --i >= 0; term = temp2.b[i])
      Begin
        index := bits[5 + nI] xor temp2[nI] ;
        index := Table1[index] xor (not Table2[index]) xor cse ;

        temp1[nI] := Table2[index] xor Table3[index] xor term ;

        term := temp2[nI] ;
      End ;

    temp1[4] := temp1[4] xor temp1[0] ;

    term := 0 ;
    For nI := 4 downto 0 do  // (i = 5, term = 0; --i >= 0; term = temp1.b[i])
      Begin
        index := bits[nI] xor temp1[nI] ;
        index := Table1[index] xor (not Table2[index]) xor cse ;

        output[nI] := Table2[index] xor Table3[index] xor term ;

        term := temp1[nI] ;
      End ;
  End ;  { Engine }

End.
