;;  This file contains the mechanisms   for matching people up

;; Four aspects are considered when matching people up
;; 1) Compatibility  of the gender and sexual orientation of the people
;; 2) "love-object-tests" are tests for the desired person's height, etc.
;;    - see file person.lisp
;; 3) "wants-traits" - the traits wanted in the desired  person - see traits.lisp
;; 4) which "does-activities" the people have in common.

;;  This is a first pass  at  measuring  compatibility,  it is
;; still quite primitive

;; we  do the matching with  one  person as the subject - the person 
;; seeking a match, and the other person as the object - the person being
;; sought.

;; the package "dating" is loaded
(in-package :dating)

;; stuff  for matching up activities

;;  activities will match  with  the same activity,  or a subset
;;  we will change  things to account for near generalizations
;; currently if person a does  skiing, and person b does  down hill,  we
;; generate a match only from the point of view of person a

(deffcn subset-or-equal (c1 c2)
  (or (query c1 'subsets c2) (equal c1 c2)))

;; the function match-activities compares   two activities.  Since  each
;;   can be a  function or a  collection, we must handle  4 cases.

;; note collections pass testp, but tests do not pass collectionp
;; this code works because we test for collections before functions
;; in general could distinguish tests by using
;;  (and (not collectionp c-object) (testp c-object)) etc.

(deffcn match-activities (c-subject c-object)
  (if (and (collectionp c-subject) (collectionp c-object))
  ;; 2  collections,  compare  by containment
    (subset-or-equal c-subject c-object)
    (if (and (collectionp c-subject) (testp c-object))
  ;;   collection and  function, turn  collection into a function
      (query (get-value c-subject 'subset-test) 'specializations c-object)
      (if (and (testp c-subject) (collectionp c-object))
   ;; function and collection, apply function to  collection
        ( funcall c-subject c-object)
        (if (and (testp  c-subject) (testp c-object))
   ;; 2  functions, look at  specializations (should make handle  equal case)
          (query c-subject 'specializations c-object)
          )
        )
      )
    )           
  )

;; now match two people for activities
;; returns a list of matches between subject and object's activities 
(deffcn match-person-activities (subject-person object-person)
  (let (matches non-matches)
    (dolist (x (get-value subject-person 'does-activities))
      (dolist (y (get-value object-person 'does-activities))
        (if (match-activities x y)
          (push (list x y) matches)
          (push (list x y) non-matches))))
    ;;(format t "~% acts:non-matches: ~a" non-matches)
    ;;(format t "~% matches: ~a" matches)
    matches))

;; just an alias for easier typing
(deffcn match-acts (s o)
  (match-person-activities s o))


;; match people by  traits

(deffcn match-traits (t-wanted t-had)
  (equal t-wanted t-had))


;; returns a list of matches between subject and object's traits 
(deffcn match-person-traits (subject-person object-person)
  (let (matches non-matches)
    (dolist (x (get-value subject-person 'wants-traits))
      (dolist (y (get-value object-person 'has-traits))
        (if (match-traits x y)
          (push (list x y) matches)
          (push (list x y) non-matches))))
    ;;(format t "~% traits:non-matches: ~a" non-matches)
    ;;(format t "~% matches: ~a" matches)
    matches))


;; match people  by wants

;; returns a list of wants matched by the object-person
(deffcn match-person-wants (subject-person object-person)
  (let (matches non-matches)
    (dolist (x (get-value subject-person 'love-object-tests))
      (if (funcall x object-person)
        ;;(push (list x) matches)
        ;;(push (list x) non-matches)
;; any reason to have list of lists?
;; only if we can  include  something about how the  wants are being met
        (push x matches)
        (push x non-matches)))
    ;;(format t "~%wants:non-matches:~A" non-matches)
    ;;(format t "~% matches: ~a" matches)
    matches))


;; allow  for a  query of  the matches between  a  subject s and object o
;; return a list of the matches  of traits,  wants, and activities
(deffcn return-person-matches (s  o)
   (list (funcall 'match-person-wants s o)
         (funcall 'match-person-traits s o)
         (funcall 'match-person-activities s o)
         )
)


; minimal hack to check compatibility
;; add  up totall  matches in   the  three aspects
(deffcn score-match (s o)
  (+ (length (match-person-wants s o))
     (length (match-person-activities s o))
     (length (match-person-traits  s o))
     ))

;; match a pair of people
;; allow  only appropriate gender
(deffcn match-pair  (s o)
;; don't match a person with  themselves 
 (if  (equal s o) 0
       (if (not (funcall (get-value s 'want-gender)  o)) 0
           (score-match s o))))

;; match a person with everyone in the dating  world

(deffcn match-person  (dw s)
 (let ((potential-dates (get-value dw 'potential-dates))
        score-list )
    (dolist (p potential-dates)
      (push   (list p (match-pair s p)) score-list))
    (setq score-list (reverse score-list))
    ;;(format t "~%score-list ~a" score-list)
    (sort (remove-if #'cadrzerop  score-list) #'cadr>)
    ;;(reduce #'maxcadr score-list)
))

(defun cadrzerop (l)
  (zerop (cadr l)))

(defun cadr> (l1 l2)
  (> (cadr l1) (cadr l2)))

(defun maxcadr (l1 l2)
  (if (>= (cadr l1) (cadr l2))
    l1
l2))

;; We   want  this to  find  the matches for  each  person   and  
;; accumulate   them in a list, but it  doesn't work correctly

(define-unit all-matches
  (works-like 'prototypical-slot)
  (makes-sense-for 'dating-worlds)
  (methods '(match-dw %unit%))
  )

;; do all matches,  print results nicely, also return list of results
(deffcn match-dw (dw)
  (let ((potential-dates (get-value dw 'potential-dates))
        match-list )
    (dolist (p potential-dates)
      (push (list p (match-person dw p)) match-list))
    (format-match-list match-list)
    match-list))

(defun format-match-list (ml)
  (dolist (l ml)
    (format t "~%matching ~a" (car l))
    (format t "~%best matches ~a" (cdr l))))
    
  
  
         