(in-package #+CL2 :common-lisp-user #-CL2 :user)

#+:CCL-2
(progn
  (rename-package "COMMON-LISP" "COMMON-LISP" '("LISP"))
  (rename-package "COMMON-LISP-USER" "COMMON-LISP-USER" '("USER")))

;;; Define USER::DEFPACKAGE
(unless (fboundp (find-symbol "DEFPACKAGE"))
 (eval '(defmacro defpackage (name &body options)
	  (let ((package-name (if (symbolp name) (symbol-name name) name))		
		(uses (cdr (assoc :use options)))
		(nicknames (cdr (assoc :nicknames options))))
	    `(if (find-package ,package-name)
	      (use-package ',uses (find-package ,package-name))
	      (make-package ,package-name :use ',uses
	       :nicknames ',nicknames))))))

#-(or CL2 Genera)
(defpackage :common-lisp (:use lisp))
(defpackage :arlotje (:nicknames aj) (:use loader common-lisp lisp)
	    #+LUCID (:import-from :lucid-common-lisp record-source-file)
	    #+MACL   (:shadowing-import-from ccl record-source-file)
            #+MACL (:shadow listener))
(defpackage test-arlo (:use arlotje #-CL2 lisp #+CL2 common-lisp #+MACL ccl)
   #+MACL(:shadowing-import-from arlotje listener realp)
   #+LUCID(:shadowing-import-from lcl ignore-errors))
(defpackage :CONSTRAINTS
  (:nicknames cstr)
  (:use arlotje lisp))

(import 'defpackage :arlotje)
(export 'aj::defpackage :arlotje)

(defpackage :huh (:use arlotje loader common-lisp lisp)
  #+LUCID (:import-from :lucid-common-lisp record-source-file)
  #+CCL   (:shadowing-import-from ccl record-source-file))
(export 'aj::defpackage :huh)
(defpackage :words (:use))

(defpackage :restaurant (:use huh arlotje common-lisp lisp) (:nicknames rstr))
(defpackage :stories (:use huh arlotje common-lisp lisp))

#-(OR CLIM)
(defpackage :arlotje-interface
    (:nicknames :aji)
  (:use :huh :arlotje :lisp)
  (:export :edit-unit))

#+CLIM
(#-GENERA defpackage #+GENERA future-common-lisp:defpackage :arlotje-interface
    (:nicknames :aji)
  (:shadowing-import-from clim-lisp clim-lisp:defpackage) 
  (:shadowing-import-from clim-shared
     clim-shared:x1 clim-shared:x2 clim-shared:origin clim-shared:radius)
  (:shadowing-import-from clim clim:color)
  (:use :huh :arlotje)
  (:use :clim :clim-shared :clim-lisp)
  (:export :edit-unit))

(when (find-package :xp)
  (funcall (intern "INSTALL" :xp) :package :arlotje)
  (funcall (intern "INSTALL" :xp) :package :huh))
