;;; -*- Mode: LISP; Package: (ARLOTJE :use ("CL")); Syntax: Common-Lisp -*-

(in-package :arlotje)

(defvar *arlotje-files*
  '("utils" "basic"  "types" "annotate"
    "cache" "many-valued" "inferences" "interface"
    "deffcn" "tests" "collections" "fast-collections"
    "bootstrap" "user" "ontology" "arlotje-tests" "user-startup"
    ))

(defun load-arlotje ()
  (dolist (file *arlotje-files*)
    (load-file (merge-pathnames file *arlotje-directory*))))

(defun load-arlotje-binary ()
  (dolist (file *arlotje-files*)
    (load-binary-file (merge-pathnames file *arlotje-directory*))))

(defun load-arlotje-source ()
  (dolist (file *arlotje-files*)
    (load-source-file (merge-pathnames file *arlotje-directory*))))

(defun update-arlotje (&optional (verbose t))
  (dolist (file *arlotje-files*)
    (update-file (merge-pathnames file *arlotje-directory*))))

(defun recompile-arlotje (&optional (verbose t))
  (dolist (file *arlotje-files*)
    (recompile-file (merge-pathnames file *arlotje-directory*))))

(export
 '(;; These are standard functions for accessing units:
   assertion retraction query get-value annotated-value
   ;; These are unit defining macros:
   define-unit define-internal-unit make-unit make-internal-unit
   new-unit declare-unit deffcn fcn annotations kill-changes 
   define-individual define-slot define-collection define-structure
   define-units list-all-units bundling
   ;; These have to do with maintaining sessions:
   new-session save-session push-session pop-session
   within-session loading-session restore-session 
   ;; These are user interface functions:
   du eu cu copy-and-edit create-unit define-unit-editor-command unit
   ;; These are useful when defining default methods:
   as-a-side-effect failurep fail support-set while-doing
   ;; These are random:
   for-possible-slots doslots dovalues docollections over-tests mapvalues
   fsymbol gensymbol symbolize show-arlotje-stack do-members
   unitp slotp anythingp specializes? satisfies? excludes? over-generalizations
   read-english-number lunion lintersection yes-no-or-why-p why
   ;; For put demons:
   assert-value %unit% %slot% %value% assert-on-each assert-each-value
   ;; Loading and compiling functions
   load-arlotje compile-arlotje))
