;;; -*- LISP -*-

(in-package :huh)


;;;; Sentences

;; For instance, "The robot is a big toaster."
(define-parser (sentence is-a)
    ((subject noun-phrase)
     (assertive (is-exactly-one-of is))
     (complement noun-phrase)
     (punctuation (the-end-of-the-sentence |.|)))
  `(copy-object ,subject ,complement))
;; For instance, "The robot is big."
(define-parser (sentence is-adj)
    ((subject noun-phrase)
     (assertive (is-exactly-one-of is))
     (adjectives modifiers)
     (punctuation (the-end-of-the-sentence |.|)))
  `(extend-object ,subject ,@adjectives))
;; For instance, "The brain of the robot is a 68030."
(define-parser (sentence what-is)
    ((question (is-exactly-one-of What Who))
     (is (is-exactly-one-of is))
     (subject noun-phrase)
     (punctuation (the-end-of-the-sentence |?|)))
  `(du ,subject))

(define-parser (sentence what-slot)
    ((question (is-exactly-one-of What Who))
     (slot (interpretation slot-interpretation))
     (is (is-exactly-one-of is))
     (subject noun-phrase)
     (punctuation (the-end-of-the-sentence |?|)))
  `(print (get-value ,subject ',slot)))


;;;; New noun phrase stuff.

(defun declared-unit-not-word-p (x)
  (and (get x 'creation-id) (not (satisfies? x 'words))))

(define-parser (noun-phrase proper-name)
  ((unit (interpretation proper-name-of)))
  `(introduce! ',unit))

(define-parser (noun-phrase direct-unit-reference)
  ((unit (satisfies declared-unit-not-word-p)))
  `(introduce! ',unit))

(define-parser (noun-phrase construct-reference)
  ((determiner (is-exactly-one-of the a an))
   (adjectives adjectives)
   (noun (interpretation class-interpretation)))
  `(create-object (member-of ',noun) ,@adjectives))

(define-parser (noun-phrase find-reference)
  ((determiner (is-exactly-one-of the that))
   (adjectives adjectives)
   (noun (interpretation class-interpretation))
   (reference (discourse-reference `((member-of ',noun) ,@adjectives))))
  `',reference)

(define-parser (noun-phrase slot-reference)
  ((determiner    (is-exactly-one-of the))
   (slot-spec     (interpretation slot-interpretation))
   (genitive-prep (is-exactly-one-of of))
   (thing         noun-phrase))
  `(get-value ,thing ',slot-spec))

(define-parser (noun-phrase resolve-it)
  ((label (exactly-matches it))
   (reference (discourse-reference '((member-of 'things)))))
  `',reference)

(define-parser (noun-phrase resolve-he)
  ((label (exactly-matches he))
   (reference (discourse-reference '((member-of 'men)))))
  `',reference)

(define-parser (noun-phrase resolve-she)
  ((label (exactly-matches she))
   (reference (discourse-reference '((member-of 'women)))))
  `',reference)

(define-parser (noun-phrase human-full-name)
    ((first-name (satisfies first-names))
     (last-name (satisfies symbolp))
     (reference (discourse-reference
		 `((MEMBER-OF 'Humans)
		   ,@(unless (failurep (get-value first-name 'likely-gender))
		       `((MEMBER-OF ',(get-value first-name 'likely-gender))))
		   (First-Name ',first-name) (Last-Name ',last-name)))))
  `',reference)
(define-parser (noun-phrase human-first-name)
  ((first-name (satisfies first-names))
   (reference (discourse-reference
	       `((MEMBER-OF 'Humans)
		 ,@(unless (failurep (get-value first-name 'likely-gender))
		     `((MEMBER-OF ',(get-value first-name 'likely-gender))))
		 (First-Name ',first-name)))))
  `',reference)

(define-parser (noun-phrase unit-reference)
  ((determiner (is-exactly-one-of the a an))
   (unit-ref explicit-unit-reference))
  unit-ref)

(define-parser (noun-phrase new-human-first-name)
  ((first-name (satisfies first-names)))
  `(create-named-object (gensymbol ',first-name)
    (member-of 'humans)
    (member-of ',(get-value first-name 'likely-gender))
    (first-name ',first-name)))

(define-parser (noun-phrase new-human-first-name-last-name)
  ((first-name (satisfies first-names))
   (last-name (satisfies symbolp)))
  `(create-named-object (gensymbol ',first-name)
    (member-of 'humans)
    (member-of ',(get-value first-name 'likely-gender))
    (first-name ',first-name)
    (last-name ',last-name)))

(define-parser (noun-phrase with-prepositions)
    ((core noun-phrase)
     (preposition (interpretation english-preposition-for))
     (prep-object noun-phrase))
  `(extend-object ,core
    (,preposition ,prep-object)))

(define-parser (adjectives none)
    ()
  '())
(define-parser (adjectives some)
    ((adj (interpretation adjective-interpretation))
     (remainder adjectives))
  (cons `(,(car adj) ',(cadr adj)) remainder))

(define-parser (modifiers adjectival-modifier)
    ((adj   (interpretation adjective-interpretation))
     (comma (noise-word |,|))
     (conjunction (noise-word AND))
     (remainder modifiers))
  `((,(car adj) ',(cadr adj)) ,@remainder))

(define-parser (modifiers prepositional-modifier)
    ((prep (interpretation english-preposition-for))
     (prep-object noun-phrase)
     (comma (noise-word |,|))
     (conjunction (noise-word AND))
     (remainder modifiers))
  `((,prep ,prep-object) ,@remainder))

(define-parser (modifiers no-modifier)
    ()
  '())


;;;; Explicit unit references.

(register-words "unit" "slot" "property" "collection" "set" "class" "of")

(define-parser (explicit-unit-reference unit-terminus)
  ((name (is-exactly-one-of unit))
   (unit (satisfies symbolp)))
  `(create-new-unit ',unit))

(define-parser (explicit-unit-reference slot-terminus)
  ((name (is-exactly-one-of slot property))
   (unit (satisfies symbolp)))
  `(extend-object (create-new-unit ',unit)
    '((Member-Of Slots))))

(define-parser (explicit-unit-reference collection-terminus)
  ((name (is-exactly-one-of collection set class))
   (unit (satisfies symbolp)))
  `(extend-object (create-new-unit ',unit)
    '((Member-Of Collections))))

(define-parser (explicit-unit-reference modifiers)
  ((modifier (interpretation adjective-interpretation))
   (remainder explicit-unit-reference))
  `(extend-object ,remainder ',modifier))


