;;;; -*- LISP -*-

(in-package 'arlotje)

(define-unit prototype
  (member-of 'single-valued-slots)
  (makes-sense-for 'unitp)
  (must-be 'unitp))
(define-unit prototype-for
  (member-of 'many-valued-slots)
  (inverse-slot 'prototype))

(define-unit prototypical-prototype-slot
  (works-like 'prototypical-slot)
  (to-compute-value 'copy-from-prototype))

(define-unit prototype-relations
  (member-of 'collections)
  (generalizations 'slotp)
  (members-have '(pushes-through prototype)))

(defun copy-from-prototype (unit slot)
  (let ((prototype (get-value unit 'prototype)))
    (make-unit (gensymbol (get-value prototype slot))
      (prototype (get-value prototype slot)))))