;;; -*- LISP -*-

(in-package 'arlotje)

(define-unit mother
  (member-of 'slots)
  (makes-sense-for 'humans)
  (must-be 'women)
  (genl-slots 'parents))

(define-unit father
  (member-of 'slots)
  (makes-sense-for 'humans)
  (must-be 'men)
  (genl-slots 'parents))

(define-unit parents
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'humans))

(define-unit children
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'humans)
  (inverse-slot 'parents))

(define-unit last-name
  (member-of 'slots)
  (transfers-through 'father))

(define-unit heritage
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (transfers-through 'father))


(define-unit kirk.douglas
    (member-of 'men)
    (first-name 'kirk)
    (last-name 'douglas)
    (heritage 'irish)
    (heritage 'german))

(define-unit michael.douglas
    (member-of 'humans)
    (first-name 'michael)
    (father 'kirk.douglas))


;;;; Copies through tests.

(define-unit sorta-like
  (member-of 'slots))

(define-unit players
  (member-of 'many-valued-slots)
;; (genl-slots 'participants)
  (copies-through 'sorta-like))

(define-unit loves
  (member-of 'many-valued-slots)
;;  (makes-sense-for 'humans)
;;  (must-be 'humans)
  (inverse-slot 'loves)
  (copies-through 'sorta-like))

(define-unit hates
  (member-of 'many-valued-slots)
;;  (makes-sense-for 'humans)
;;  (must-be 'humans)
  (inverse-slot 'hates)
  (copies-through 'sorta-like))

(define-unit relative-of
  (member-of 'many-valued-slots)
;;  (makes-sense-for 'humans)
;;  (must-be 'humans)
  (inverse-slot 'relative-of)
  (copies-through 'sorta-like))

(define-unit friend-of
  (member-of 'many-valued-slots)
;;  (makes-sense-for 'humans)
;;  (must-be 'humans)
  (inverse-slot 'relative-of)
  (copies-through 'sorta-like))

(define-unit romeo-and-juliet
  (member-of 'processes)
  (players
   (make-unit 'romeo
     (member-of 'men)))
  (players
   (make-unit 'juliet
     (member-of 'women)
     (loves 'romeo)))
  (players
   (make-unit 'mercutio
     (member-of 'men)
     (friend-of 'romeo)))
  (players
   (make-unit 'tybalt
     (member-of 'men)
     (hates 'mercutio)
     (relative-of 'juliet))))

(define-unit west-side-story
  (member-of 'processes)
  (sorta-like 'romeo-and-juliet))

;;(get-value 'west-side-story 'players)


