;;; -*- LISP -*-

(in-package :MCD :use '(STORIES RESTAURANT HUH ARLOTJE LISP))

(defparameter *longer-restaurant-text*
  "Kathy arrived at the restaurant.  The waiter led Kathy to the table.
 She ordered the eggplant.  The waiter brought the eggplant to her.
She ate the eggplant.  She paid the waiter.  She left the restaurant.")

(read-text *longer-restaurant-text*)

(define-word "Kathy"
    (member-of 'first-names)
  (likely-gender 'women))

(define-word "ARRIVE"
    (member-of 'infinitives)
  (past-tense (register-word "ARRIVED"))
  (case-frames
   '(BEING-MOVED (initiator thing-moved) () ()
      (AT destination) (IN vehicle))))

(define-word "AT"
    (member-of 'prepositions))


;;;; Leading and following

(define-unit leading-another
  (member-of 'collections)
  (supersets 'being-moved))

(define-unit leader
  (member-of 'single-valued-slots)
  (makes-sense-for 'leading-another)
  (must-be 'agents))
(define-unit follower
  (member-of 'single-valued-slots)
  (makes-sense-for 'leading-another)
  (must-be 'agents))
(define-unit led-to
  (member-of 'single-valued-slots)
  (makes-sense-for 'leading-another)
  (must-be 'spatial-extents))

(define-unit leading
  (member-of 'single-valued-slots)
  (makes-sense-for 'leading-another)
  (must-be 'being-moved)
  (structure '(initiator leader))
  (structure '(thing-moved leader))
  (structure '(destination led-to)))
(define-unit following
  (member-of 'single-valued-slots)
  (makes-sense-for 'leading-another)
  (must-be 'being-moved)
  (structure '(initiator follower))
  (structure '(thing-moved follower))
  (structure '(destination led-to)))

(define-word "lead"
    (member-of 'infinitives)
  (past-tense (register-word "led"))
  (case-frames
   '(leading-another (leader) (follower) () (to led-to))))

(assertion 'leading-another
	   'local-members-demons
	   '(assert-value %value%
	     'leading (aj::instantiate 'being-moved)))
(assertion 'leading-another
	    'local-members-demons
	    '(assert-value %value%
	      'following (aj::instantiate 'being-moved)))


(define-parser (huh::noun-phrase resolve-feminine-pronoun)
  ((pronoun (is-exactly-one-of she her))
   (reference (discourse-reference '((member-of 'women)))))
  `'reference)
