;;; -*- LISP -*-

;;;;.Implementing local methods

;;.In some early versions of ARLOtje, there are no local methods;
;;.they are defined by constructing the slot @code{local-methods}

(define-unit methods
  (works-like 'prototypical-set-slot)
  (must-be 'listp)
  (makes-sense-for 'slotp)
  (inferences '(to-compute-value apply-multiple-methods)))

(define-unit local-methods
  (member-of 'many-valued-slots)
  (makes-sense-for 'annotated-valuep)
  (must-be 'listp))

(defun run-method (method unit slot)
  "Evaluates PUT-DEMON with appropriate interpretations to UNIT, SLOT, and VALUE."
  (block fail
    (labels ((evaller (x)
	       (cond ((null x) x)		     
		     ((listp x)
		      (cond ((eq (car x) 'quote) (cadr x))
			    ((macro-function (car x))
			     (evaller (macroexpand x)))
			    ((eq (car x) 'if)
			     (if (evaller (cadr x)) (evaller (caddr x))
			       (evaller (cadddr x))))
			    ((eq (car x) 'get-value)
			     (let ((unit (evaller (cadr x)))
				   (slot (evaller (caddr x))))
			       (if (computing? get-value unit slot)
				   (return-from fail (fail unit slot))
				 (let ((result (get-value unit slot)))
				   (if (failurep result) (return-from fail result)
				     result)))))
			    ((eq (car x) 'query)
			     (let ((unit (evaller (cadr x)))
				   (slot (evaller (caddr x)))
				   (value (evaller (cadddr x))))
			       (if (computing? check-value unit slot value)
				   (return-from fail NIL)
				 (check-value unit slot value))))
			    (t (let ((result (apply (car x) (mapcar #'evaller (cdr x)))))
				 (if (failurep result) (return-from fail result) result)))))
		     ((eq x '%UNIT%) unit)
		     ((eq x '%SLOT%) slot)
		     (T x))))
      (evaller method))))

(defun apply-slot-methods (unit slot)
  "Applies a variety of methods to compute a slot value."
  (let ((attempt nil))
    (dolist (method (get-value slot 'methods) attempt)
      (setq attempt (run-method method unit slot))
      (unless (failurep attempt) (return attempt)))))

(defun apply-local-methods (unit slot)
  "Applies a the local (per-value) methods to compute a slot value."
  (let ((attempt nil))
    (dolist (method (get-value (annotated-value unit slot) 'local-methods)
	     (or attempt (fail unit slot)))
      (setq attempt (run-method method unit slot))
      (unless (failurep attempt) (return attempt)))))

(defun apply-multiple-methods (unit slot)
  "Applies a variety of methods to compute a slot value."
  (if *recursion-checking*
      (let ((local-value (apply-local-methods unit slot)))
	(if (failurep local-value)
	    (apply-slot-methods unit slot)
	  local-value))
    (let ((*recursion-checking* T))
      (computing (get-value unit slot)
	 (let ((local-value (apply-local-methods unit slot)))
	   (if (failurep local-value)
	       (apply-slot-methods unit slot)
	     local-value))))))



