;;; -*- LISP -*-

;;.@chapter What ARLOtje does when it starts up
(in-package :arlotje)

(define-unit arlotje-users
  (member-of 'collections)
  (supersets 'agents))

(define-unit students
  (member-of 'collections)
  (supersets 'humans))

(define-unit professors
  (member-of 'collections)
  (supersets 'humans))

(define-unit undergraduate-students
  (member-of 'collections)
  (supersets 'students))

(define-unit graduate-students
  (member-of 'collections)
  (supersets 'students))

(define-unit special-students
  (member-of 'collections)
  (supersets 'students))

(define-unit 4.933-students
  (member-of 'collections)
  (supersets 'students))

(define-unit mit-departments
  (member-of 'collections)
  (members (declare-unit 'civil-engineering))
  (members (declare-unit 'mechanical-engineering))
  (members (declare-unit 'materials-science))
  (members (declare-unit 'architecture))
  (members (declare-unit 'electrical-engineering))
  (members (declare-unit 'political-science))
  )

(define-unit mit-affiliation
  (member-of 'many-valued-slots)
  (makes-sense-for 'humans)
  (must-be 'mit-departments))

(define-unit email-address
  (member-of 'single-valued-slots)
  (makes-sense-for 'agents)
  (must-be 'stringp))

(define-unit full-name
  (member-of 'single-valued-slots)
  (makes-sense-for 'agents)
  (must-be 'stringp))

(define-unit phone-numbers
  (member-of 'many-valued-slots)
  (makes-sense-for 'agents)
  (must-be 'stringp))

(defun user-init ()
  (try-to-load-unit (arlotje-user))
  (load-all-unit-references (arlotje-user))
  (setq *default-slot-filter*
	(or (and (arlotje-user) (get-value (arlotje-user) 'default-slot-filter))
	    'slotp))
  (new-session))


;;;;.Entering individual descriptions for class.

(defun enter-individual ()
  (let* ((namestring (progn (format T "~&Enter the individual's name: ") (read-line)))
	 (name (intern (substitute #\. #\Space (string-upcase namestring)) :ARLOTJE))
	 (session-name (intern (format NIL "~S.INTRO" name) :ARLOTJE)))
    (within-session session-name
      (declare-unit name)
      (assertion name 'member-of 'humans)
      (assertion name 'member-of '4.933-students)
      (assertion name 'member-of 'arlotje-users)
      (assertion name 'full-name namestring)
      (format T "~&Enter the course number: ")
      (let ((course (assoc (read) '((1 Civil-Engineering) (2 Mechanical-Engineering)
				    (3 Materials-Science) (4 Architecture)
				    (6 Electrical-engineering) (17 Political-Science)))))
	(when course (assertion name 'mit-affiliation (cadr course))))
      (let ((code (progn (format T "~&Affiliation (F,G,U,S) ")
			 (let ((*package* *arlotje-package*)) (read)))))
	(cond ((eq code 'F)
	       (assertion name 'member-of 'professors))
	      ((eq code 'G)
	       (assertion name 'member-of 'graduate-students))
	      ((eq code 'U)
	       (assertion name 'member-of 'undergraduate-students))
	      ((eq code 'S)
	       (assertion name 'member-of 'special-students))))
      (assertion name 'email-address (progn (format T "~&Email: ") (read-line)))
      (assertion name 'phone-numbers (progn (format T "~&Phone: ") (read-line)))
      (du name))))

(defun enter-individuals ()
  (loop (enter-individual)))

