;;; $Id: read-objects.scm,v 1.1.1.1 1993/06/24 10:06:03 queinnec Exp $
;;; Copyright (c) 1990-93 by Christian Queinnec. All rights reserved.
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;;                        LiSP2TeX
;;;   Christian Queinnec             or to:  Christian Queinnec
;;;   <queinnec@polytechnique.fr>            <Christian.Queinnec@inria.fr>
;;;   Laboratoire d'Informatique de l'X      INRIA -- Rocquencourt
;;;   Ecole Polytechnique                    Domaine de Voluceau, BP 105
;;;   91128 Palaiseau                        78153 Le Chesnay Cedex
;;;   France                                 France
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

;;; This program is distributed in the hope that it will be useful.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted, so long as the following
;;; conditions are met:
;;;      o credit to the authors is acknowledged following current
;;;        academic behaviour
;;;      o no fees or compensation are charged for use, copies, or
;;;        access to this software
;;;      o this copyright notice is included intact.
;;; This software is made available AS IS, and no warranty is made about
;;; the software or its performance.

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; This file defines how symbols and strings are created by the reader.
;;; An extensible string is used to incrementally build symbols or strings.
;;; It is at the end finalized into the appropriate data structure.

;;; add a character to a symbol under construction.
;;; The boolean `respect' if true imposes that the character will not be
;;; turned to upper or lower case.
(define (increment-symbol char sm respect)
  (increment-string 
   (cond (respect char)
         (*respect-input* char)
         (*uppercase-input* (char-upcase char))
         (*lowercase-input* (char-downcase char))
         (else char) )
   sm ) )

;;; add a character to an extensible string
(define (increment-string char sm)
  (let ((string (extensible-string-characters sm))
        (index (extensible-string-index sm)) )
    (string-set! string index char)
    (set-extensible-string-index! sm (+ 1 index))
    (if (< (+ 1 index) (string-length string))
        sm
        (let* ((newindex (+ 1 index))
               (newstring (make-string (* 2 newindex))) )
          (set-extensible-string-characters! sm newstring)
          (do ((i 0 (+ 1 i)))
              ((= i newindex) sm)
            (string-set! newstring i (string-ref string i)) ) ) ) ) )

;;; takes an extensible string and returns a symbol
(define (finalize-symbol sm)
  (string->symbol (finalize-string sm)) )

;;; takes an extensible string and returns a string
(define (finalize-string sm)
  (substring (extensible-string-characters sm)
             0 
             (extensible-string-index sm) ) )


;;; An extensible string is extended as needed.
(define (make-extensible-string initial-size)
  (vector 'extensible-string (make-string initial-size) 0) )
(define (extensible-string-characters sm)
  (vector-ref sm 1) )
(define (set-extensible-string-characters! sm newstring)
  (vector-set! sm 1 newstring) )
(define (extensible-string-index sm)
  (vector-ref sm 2) )
(define (set-extensible-string-index! sm index)
  (vector-set! sm 2 index) )

;;; end of read-object.scm
