;;; $Id: port-bigloo.scm,v 1.7 1994/02/03 17:36:11 queinnec Exp $
;;; Copyright (c) 1990-93 by Christian Queinnec. All rights reserved.
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;;                        LiSP2TeX
;;;   Christian Queinnec             or to:  Christian Queinnec
;;;   <queinnec@polytechnique.fr>            <Christian.Queinnec@inria.fr>
;;;   Laboratoire d'Informatique de l'X      INRIA -- Rocquencourt
;;;   Ecole Polytechnique                    Domaine de Voluceau, BP 105
;;;   91128 Palaiseau                        78153 Le Chesnay Cedex
;;;   France                                 France
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

;;; This program is distributed in the hope that it will be useful.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted, so long as the following
;;; conditions are met:
;;;      o credit to the authors is acknowledged following current
;;;        academic behaviour
;;;      o no fees or compensation are charged for use, copies, or
;;;        access to this software
;;;      o this copyright notice is included intact.
;;; This software is made available AS IS, and no warranty is made about
;;; the software or its performance.

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; This file contains the functions that are highly dependent of the
;;; Scheme implementation and, here, Bigloo from Manuel Serrano.
;;; NOTE: You need at least Bigloo 1.4 to run correctly LiSP2TeX.
;;; It also contains some utilities that are not present.

;;; The name of the underlying Scheme system.

(define scm-name "Bigloo")

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; Utilities are mapcan, atom?, string-uppercase and
;;; string-lowercase. Some ports do not need to define them as they
;;; may already be present.

(define (mapcan fn l)
  (if (pair? l)
      (append (fn (car l))
              (mapcan fn (cdr l)) )
      '() ) )

(define (atom? e)
  (not (pair? e)) )

(define (string-uppercase string)
  (let* ((n (string-length string))
         (s (make-string n)) )
    (do ((i 0 (+ i 1)))
        ((= i n) s)
      (string-set! s i (char-upcase (string-ref string i))) ) ) )

(define (string-lowercase string)
  (let* ((n (string-length string))
         (s (make-string n)) )
    (do ((i 0 (+ i 1)))
        ((= i n) s)
      (string-set! s i (char-downcase (string-ref string i))) ) ) )

;;;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; Biloo dependencies.

;;; Only used in their dynamic extent so bind-exit is safe.

(define (call/cc f)
  (bind-exit (k) (f k)) )

;;; Bigloo has a working peek-char.

(define system-can-peek-char? #t)

;;; The three POSIX streams.

(define stdin-port (current-input-port))
(define stdout-port (current-output-port))
(define stderr-port (current-error-port))

;;; Defines case sensitivity.

(define *respect-input* #t)
(define *uppercase-input* #f)
(define *lowercase-input* #f)

;;; Set how expressions to be evaluated (by Bigloo) should be read.
;;; Bigloo reads symbols in uppercase.

(define *evaluator-preferred-respect-input*   #f)
(define *evaluator-preferred-uppercase-input* #t)
(define *evaluator-preferred-lowercase-input* #f)

;;; By default respect case sensitivity.

(define *respect-output* #t)
(define *uppercase-output* #f)
(define *lowercase-output* #f)

;;; After each directive processing, flush buffers if not automatically
;;; provided by the implementation. 

(define (flush-all-buffers) 
  (flush-output-port stdout-port)
  (flush-output-port stderr-port ) )

;;; probe-file tests if a file exists.

(define probe-file file-exists?)

;;; Dynamically evaluates an expression. If an error occurs, wrap the
;;; error in a list with a distinguished symbol.
;;; This is specific to Bigloo.

(define (LiSP2TeX-eval exp)
  (try (eval exp)
       (lambda (k a b c)
         (k (list '***EVALUATION-ERROR*** a b c)) ) ) )

;;; The entry point of LiSP2TeX. The args variable is the list of 
;;; arguments of the shell invokation (a list of strings). This function
;;; has to be called as the initial function.

(define (unix-main args)
  (set! args (cdr args)) ; strip executable name
  (LiSP2TeX args) )

;;; load the content of file. Load it non verbosely to not clutter the
;;; output stream.  The content of the file may use the various macros
;;; that are defined in emit.scm. It is better to load the file not in
;;; verbose mode to avoid cluttering the output: loadq does this.

(define (load-parameter-file file)
  (loadq file) )

;;; Define macros. They must be present for the compilation and the
;;; run-time since they are necessary to load customization files.
;;; New macros can be defined in customization files if they are defined
;;; with define-lisp2tex-macro.

(define-macro (define-lisp2tex-macro call . body)
  `(begin 
     (eval '(define-macro ,call . ,body))
     (define-macro ,call . ,body) ) )

;;; Make define-lisp2tex-macro pervasive itself  

(eval '(define-macro (define-lisp2tex-macro call . body)
         `(define-macro ,call . ,body) ))

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; Define some macros

;;; PC Scheme has still a binary apply so any port has to define this macro.
;;; But this macro is only needed for compilation.

(define-lisp2tex-macro (LiSP2TeX-apply . args)
  `(apply . ,args) )

(define-lisp2tex-macro (unless condition . body)
  `(if ,condition #f (begin . ,body)) )

(define-lisp2tex-macro (when condition . body)
  `(if ,condition (begin . ,body)) )

;;; end of port-bigloo.scm
