;;; $Id: emit.scm,v 1.3 1993/06/27 13:01:54 queinnec Exp $
;;; Copyright (c) 1990-93 by Christian Queinnec. All rights reserved.
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;;                        LiSP2TeX
;;;   Christian Queinnec             or to:  Christian Queinnec
;;;   <queinnec@polytechnique.fr>            <Christian.Queinnec@inria.fr>
;;;   Laboratoire d'Informatique de l'X      INRIA -- Rocquencourt
;;;   Ecole Polytechnique                    Domaine de Voluceau, BP 105
;;;   91128 Palaiseau                        78153 Le Chesnay Cedex
;;;   France                                 France
;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

;;; This program is distributed in the hope that it will be useful.
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted, so long as the following
;;; conditions are met:
;;;      o credit to the authors is acknowledged following current
;;;        academic behaviour
;;;      o no fees or compensation are charged for use, copies, or
;;;        access to this software
;;;      o this copyright notice is included intact.
;;; This software is made available AS IS, and no warranty is made about
;;; the software or its performance.

;;;oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; This file contains the printing routines.

;;; The output base for numbers
(define *output-base* 10)
(define *number-images*
  (vector #\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9 #\A #\B #\C #\D #\E #\F) )

;;; How boolean values are printed:
(define *true-image* "#T")
(define *false-image* "#F")

;;; Error formats
(define *unprintable-object* 
  "Do not know how to print this object: ~A" )
(define *too-big-format*
  "Too less arguments for format: \"~A\"." )
(define *incorrect-format*
  "Incorrect format specifier in format \"~A\", at index ~A." )
(define *too-short-format*
  "Too much arguments for format: \"~A\"." )
(define *not-a-string* 
  "format ~~U in \"~A\", not a string ~A." )

;;; Thee main printing function
(define (pp-format stream fmt . arguments)
  (define (prin-dotted-list o)
    (display-string " . " stream)
    (princ o) )
  (define (princ-list o)
    (cond ((null? o) o)
          ((pair? o) 
           (if (memq (car o) '(quote quasiquote unquote unquote-splicing))
               (prin-dotted-list o)
               (begin (write-char #\space stream)
                      (princ (car o))
                      (princ-list (cdr o)) ) ) )
          (else (prin-dotted-list o)) ) )
  (define (princ-normal-list o)
    (write-char #\( stream)
    (princ (car o))
    (princ-list (cdr o))
    (write-char #\) stream) )
  (define (princ-special-list o)
    (case (car o)
      ((quote) 
       (cond ((and (pair? (cdr o)) (null? (cddr o)))
              (write-char #\' stream)
              (princ (cadr o)) )
             (else (princ-normal-list o)) ) )
      ((quasiquote) 
       (cond ((and (pair? (cdr o)) (null? (cddr o)))
              (write-char #\` stream)
              (princ (cadr o)) )
             (else (princ-normal-list o)) ) )
      ((unquote)  
       (cond ((and (pair? (cdr o)) (null? (cddr o)))
              (write-char #\, stream)
              (princ (cadr o)) )
             (else (princ-normal-list o)) ) )
      ((unquote-splicing)  
       (cond ((and (pair? (cdr o)) (null? (cddr o)))
              (display-string ",@" stream)
              (princ (cadr o)) )
             (else (princ-normal-list o)) ) )
      (else (princ-normal-list o)) ) )
  (define (princ-vector o leng)
    (do ((i 0 (+ i 1))
         (j 1 (+ j 1)) )
        ((= i leng) o)
      (princ (vector-ref o i))
      (unless (= j leng) (write-char #\space stream)) ) )
  (define (princ o)
    (cond ((symbol? o) 
           (let ((s (symbol->string o)))
             (cond 
              (*respect-output* (display-string s stream))
              (*uppercase-output* (display-string (string-uppercase s) stream))
              (*lowercase-output* (display-string (string-lowercase s) stream))
              ) ) )
          ((null? o) (display-string "()" stream))
          ;; ports are pairs in Scheme->C, so test them before
          ((input-port? o) (display-string "#<an input Port>" stream))
          ((output-port? o) (display-string "#<an output Port>" stream))
          ((pair? o) (princ-special-list o))
          ((integer? o) (prin-integer o stream))
          ((string? o) (write-string o stream))
          ((vector? o) (display-string "#(" stream)
                       (princ-vector o (vector-length o))
                       (display-string ")" stream) )
          ((boolean? o) 
           (display-string (if o *true-image* *false-image*) stream) )
          ((procedure? o) (display-string "#<a Function>" stream))
          ((number? o) (display-number o stream))
          ((char? o) (display o stream))
          (else (command-error *unprintable-object* o)) ) )
  (define format-length (string-length fmt))
  (do ((i 0 (+ 1 i)))
      ((>= i format-length) #t)
    (if (char=? (string-ref fmt i) #\~)
        (begin (set! i (+ 1 i))
               (cond 
                ;; Displays a Sexpression
                ((char-ci=? (string-ref fmt i) #\A)
                 (if (pair? arguments)
                     (let ((o (car arguments)))
                       (set! arguments (cdr arguments))
                       (princ o) )
                     (command-error *too-big-format* fmt) ) )
                ;; pretty-prints a Sexpression
                ((char-ci=? (string-ref fmt i) #\Q)
                 (if (pair? arguments)
                     (let ((o (car arguments)))
                       (set! arguments (cdr arguments))
                       (pp-greekify o stream) )
                     (command-error *too-big-format* fmt) ) )
                ;; Displays a tilde
                ((char=? (string-ref fmt i) #\~)
                 (write-char #\~ stream) )
                ;; Displays a string without surrounding quotes
                ((char-ci=? (string-ref fmt i) #\U)
                 (if (pair? arguments)
                     (let ((o (car arguments)))
                       (set! arguments (cdr arguments))
                       (if (string? o)
                           (display-string o stream)
                           (command-error *not-a-string* fmt o) ) )
                     (command-error *too-big-format* fmt) ) )
                ;; emits a newline
                ((char=? (string-ref fmt i) #\%)
                 (newline stream) )
                (else (command-error *incorrect-format* fmt i)) ) )
        (write-char (string-ref fmt i) stream) ) )
  (or (null? arguments)
      (command-error *too-short-format* fmt) ) )
                            
(define (write-string string stream)
  (write string stream) )
(define (display-string string stream)
  (display string stream) )

(define (prin-integer n stream)
  (when (< n 0) (write-char #\- stream)
                (set! n (- n)) )
  (let ((p (quotient n *output-base*)))
    (when (> p 0) (prin-integer p stream))
    (write-char (vector-ref *number-images* (remainder n *output-base*))
                stream ) ) )

;;; Other numbers are printed by the native Scheme
(define (display-number o stream)
  (display o stream) )

;;; Tests
; (pp-format stdout-port "foo")
; (pp-format stdout-port "foo~A bar" 1)
; (pp-format stdout-port "foo~A bar~A~%,~A." 1 2 3)
; (pp-format stdout-port "foo~A bar" -123)
; (pp-format stdout-port "foo~A bar" #t)
; (pp-format stdout-port "foo~A bar" #f)
; (pp-format stdout-port "foo~A bar" stderr-port)
; (pp-format stdout-port "foo~A bar" "STrInG")
; (pp-format stdout-port "foo~A bar" '#(1 -2 "FoO"))
; (pp-format stdout-port "foo~A bar" 'foo)
; (pp-format stdout-port "foo~A bar" '(foo 1))
; (pp-format stdout-port "foo~A bar" '(foo 1 (3 . \Ba\R)))
; (pp-format stdout-port "foo~A bar" ''foo)
; (pp-format stdout-port "foo~A bar" '(foo `(bar ,foo ,@hux) . 3))
; (pp-format stdout-port "foo~A bar" '(foo `(bar ,foo . ,hux) . 'gazonk))

;;; Erroneous tests
; (pp-format stdout-port "foo~Z bar")
; (pp-format stdout-port "foo~A bar" )
; (pp-format stdout-port "foo~A bar" 1 2)
; (pp-format stdout-port "foo~A bar" '(quote a b))

;;; end of emit.scm
