;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(proclaim '(special scheme-directory **ticks** *toplevel-continuation*
	    *scheme-version* *banner-line* unprintable-symbols))

(proclaim '(special *initial-env* *initial-args* *initial-result* *init-base*
	    *initial-pc* *initial-cont* development?))

;;; Initial vsm register values

(proclaim '(special keyboard))

;;; for system debugging setq development? to a non-nil value and
;;; a lisp debugger will be entered (instead of a (reset)) on
;;; vsm, compiler, etc. errors.

;(setq development? nil)

;??jg??--debug
;(defun lisp-debug ()
;    (if (not (null development?))
;	(print "Sorry, no debugging available currently")
	;(debug '|developmental debugging|)
;	(reset)))

(load (concatenate 'string scheme-directory "base.o"))
	; base environment functions

(setq initial-unprintables
  '((&closure . <FUNCTION>) ;;; unprintables
	(&synthetic-lambda . <FUNCTION>)
	(&cont . <FUNCTION>)
	(&rest-closure . <CLOSURE>)
	(&transform . <TRANSFORM>)
	(&sys . <SYSTEM-FUNCTION>)
	(&in-port . <INPUT-PORT>)
	(&out-port . <OUTPUT-PORT>)
	(&base . <BASE-ENV>)
	(&vector . <VECTOR>)
	(&ref . <REF>)
	(&unassigned-constant . <UNASSIGNED-CONSTANT>)
	(&closed-port . <CLOSED-PORT>)
	(&lexical-env . <LEXICAL-ENVIRONMENT>)))

(setq keyboard `(&in-port ,*standard-input*))

(setq *init-base* (genbase))

(extendbase 'scheme-global-note nil)
(extendbase 'scheme-prompt ">>> ")
(extendbase 'defined-forms nil)
(extendbase 'defining-forms nil)
(extendbase 'input-port keyboard)
(extendbase 'output-port `(&out-port ,*standard-output* 74 . 1))
(extendbase 'unprintables initial-unprintables)
(extendbase 'scheme-top-level nil)
(extendbase 'I '(&cont))

(setq *initial-env* nil)

; all the other hand S-coded definitions are at the head of std.s and sys.s

(setq *initial-pc* '((*pr &ms . result)))

(setq *toplevel-function*
  `(&closure
     (1 (v) (*lr 0 . 0) (*pu) (*gr . ,(baselocation 'scheme-top-level))
	(*at . 1))))

(setq *initial-vsm-args* '(--------------------------------------))
(setq *initial-args* nil)
(setq *initial-result* nil)
(setq *initial-cont* nil)
(setq *toplevel-continuation*
  `((,*initial-pc* ,*initial-args* . ,*initial-env*) . ,*initial-cont*))

(defun vsm-help (pc cont env args result)
  (handler-case (vsm pc cont env args result)
		(arithmetic-error (condition)
				  (standardprint condition)
				  (standardprint ": ")
				  (standardprint
				   (cons (arithmetic-error-operation condition)
					 (arithmetic-error-operands condition))
				   )
				  (standardprint ".")
				  (new-line schpoport)
				  (reset-ids))
		(cell-error (condition)
			    (standardprint condition)
			    (standardprint ": ")
			    (standardprint (cell-error-name condition))
			    (standardprint ".")
			    (new-line schpoport)
			    (reset-ids))
		(file-error (condition)
			    (standardprint "Cannot open/close file: ")
			    (standardprint (file-error-pathname condition))
			    (standardprint ".")
			    (new-line schpoport)
			    (reset-ids))
		(stream-error (condition)
			      (standardprint condition)
			      (standardprint ": ")
			      (standardprint (stream-error-stream condition))
			      (standardprint ".")
			      (new-line schpoport)
			      (reset-ids))
		(type-error (condition)
			    (standardprint (type-error-datum condition))
			    (standardprint " is not of type ")
			    (standardprint (type-error-expected-type condition))
			    (standardprint ".")
			    (new-line schpoport)
			    (reset-ids))
		(storage-condition ()
				   (standardprint "Out of storage space.")
				   (new-line schpoport)
				   (reset-ids))
		((or simple-warning simple-condition simple-error simple-type-error) (condition)
		 (apply 'format
			(cons *standard-output*
			      (cons (simple-condition-format-string condition)
				    (simple-condition-format-arguments condition))))
		 (if ptport
		     (apply 'format
			    (cons ptport
				  (cons (simple-condition-format-string condition)
					(simple-condition-format-arguments condition)))))
		 (new-line schpoport)
		 (reset-ids))
		(condition (condition)
			   (standardprint condition)
			   (standardprint ": Forget it.")
			   (new-line schpoport)
			   (reset-ids))))

(defun run (pc)
    (vsm-help
      pc
      *toplevel-continuation*
      *initial-env*
      *initial-args*
      *initial-result*))
   
(defun load-scheme ()
    (prog (port)
	  (load (concatenate 'string scheme-directory "except.o")) ; exception handler
	  (load (concatenate 'string scheme-directory "error.o")) ; error handler
	  (load (concatenate 'string scheme-directory "print.o")) ; print stuff
	  (load (concatenate 'string scheme-directory "hostmacs.o")) ; host macros
	  (load (concatenate 'string scheme-directory "env.o"))   ; initial environment
	  ; must be loaded before
	  ; env!!
	  (load (concatenate 'string scheme-directory "constant.o")) ; constants
	  (load (concatenate 'string scheme-directory "vector.o")); vectors
	  (load (concatenate 'string scheme-directory "prims.o")) ; primitives
	  (load (concatenate 'string scheme-directory "vsm.o"))   ; virtual machine
	  (load (concatenate 'string scheme-directory "comp.o"))  ; scheme compiler in 
	  ; lisp
	  (load (concatenate 'string scheme-directory "expand.o")); beta-expander
	  (load (concatenate 'string scheme-directory "mkmac.o")) ; mkmac
	  (load (concatenate 'string scheme-directory "signal.o")); signal handlers
	  (princ "[scheme-load sys.s]")(terpri)
	  (with-open-stream
		(port	(open (concatenate 'string scheme-directory "sys.s")
			      :direction :input))
		(run (compile (read port))))))

(defun user-top-level ()
  (prog ()
	loop
         (new-line schpoport)
	 (standardprint *banner-line*)
	 (standardprint *scheme-version*)
	 (new-line schpoport)
	 (setq **ticks** nil)
         (vsm-help '((*at . 1))
	           *initial-cont*
		   *initial-env*
	           *initial-vsm-args*
	           *toplevel-function*)
	(go loop)))

(defun reset ()
        (reset-ids)
	(user-top-level))
(defun reset-ids ()
        (rplacd (baselocation 'standard-input) keyboard)
	(rplacd (baselocation 'standard-output) schpoport))

(setq unprintable-symbols (mapcar 'car initial-unprintables))

(setq **ticks** nil) ; initialize virtual machine registers

;--debug
(princ "[initiating (load-scheme)]") 

(load-scheme)

;-- debug
(princ "[finished (load-scheme) gracefully]")

(setf (symbol-function 'system:top-level)
      (symbol-function 'user-top-level))
; (user-top-level)
