(declare (special vactor-hunksize))

(def nth
   (macro (l)
	  `(nthelem (1+ ,(cadr l)) ,(caddr l))))

(setq vactor-hunksize 128)

(def vactor?
   (lambda (obj)
      (cond ((dtpr obj) (eq (car obj) '&vector))
	    (t nil))))

(def vactor-ref
   (lambda (v n)
      (cond ((vactor? v)
	     (let ((hunks (cdr v))
		   (nums (Divide n vactor-hunksize)))
		(let ((hunknum (car nums))
		      (offset (cadr nums)))
		   (cxr offset (nth hunknum hunks)))))
	    (t (raise (list 'SE%vector 0 t 'vector-ref:
			 '|first argument not a vector: | v))))))

(def vactor-set!
   (lambda (v n value)
      (cond ((vactor? v)
	     (let ((hunks (cdr v))
		   (nums (Divide n vactor-hunksize)))
		(let ((hunknum (car nums))
		      (offset (cadr nums)))
		   (rplacx offset (nth hunknum hunks) value)
		   nil)))
	    (t (raise (list 'SE%vector 0 t 'vector-set!:
			 '|first argument not a vector: | v))))))

(def vactor-length
   (lambda (v)
      (cond ((vactor? v) (map-plus-length-hunks (cdr v) 0))
	    (t (raise (list 'SE%vector 0 t 'vector-length:
			 '|argument not a vector: | v))))))

(def map-plus-length-hunks
   (lambda (l sum)
      (cond ((null l) sum)
	    (t (map-plus-length-hunks (cdr l)
		  (+ sum (hunksize (car l))))))))

(def vactor->list
   (lambda (v)
      (cond ((vactor? v) (mapcan 'hunk-to-list (cdr v)))
	    (t (raise (list 'SE%vector 0 t 'vector->list:
			 '|argument not a vector: | v))))))

(def make-vactor
   (lambda (args)
	  (cond ((null (cdr args))
		 (cons '&vector (make-vactor/fill (car args) nil)))
		(t (cons '&vector
		      (make-vactor/fill (car args) (cadr args)))))))

(def make-vactor/fill
   (lambda (n x)
      (cond ((< vactor-hunksize n)
	     (cons (fill-hunk (makhunk vactor-hunksize)
		      (1- vactor-hunksize) x)
		   (make-vactor/fill (- n vactor-hunksize) x)))
	    (t (cons (fill-hunk (makhunk n) (1- n) x) nil)))))

(def fill-hunk
   (lambda (h n x)
      (cond ((minusp n) h)
	    (t (rplacx n h x)
	       (fill-hunk h (1- n) x)))))

(def vactor-fill!
   (lambda (v x)
      (cond ((vactor? v) (vactor/fill (cdr v) x))
	    (t (raise (list 'SE%vector 0 t 'vector-fill!:
			 '|first argument not a vector: | v))))))

(def vactor/fill
   (lambda (hunks x)
      (cond ((null hunks) hunks)
	    (t (fill-hunk (car hunks) (1- (hunksize (car hunks))) x)
	       (vactor/fill (cdr hunks) x)))))

(def list->vactor
   (lambda (l)
      (let ((pieces (break-list l)))
	 (cons '&vector (mapcar 'makhunk pieces)))))

(def break-list
   (lambda (l)
      (cond ((null l) nil)
	    ((> (length l) vactor-hunksize)
	     (let ([p (vec-parts l vactor-hunksize)])
		(cons (car p)
		      (break-list (cdr p)))))
	    (t (cons l nil)))))

(def vec-parts
   (lambda (l n)
      (cond ((null l) (cons nil nil))
	    ((zerop n) (cons nil l))
	    (t (let ((p (vec-parts (cdr l) (1- n))))
		  (cons (cons (car l) (car p))
			(cdr p)))))))

