(add-to-syntax-table '(autoload-macro)
  (#!lambda (l)
    `(add-to-syntax-table '(,(cadr l))
       (#!lambda (e) (load ,(caddr l)) (expand-once e)))))

(let
  ([gen
     (lambda (pat exp body)
       (let ([vars nil])
	 (iterate loop ([pat pat] [exp exp] [body (lambda () body)])
	   (let ([t1 (gensym 'temp)])
	     (cond
	       [(null? pat) `(if ,exp (fail) ,(body))]
	       [(or (and (symbol? pat) (memq pat vars))
		    (and (pair? pat) (pair? (cdr pat))
			 (null? (cddr pat)) (eq? (car pat) 'quote))
		    (string? pat))
		`(if (equal? ,pat ,exp) ,(body) (fail))]
	       [(symbol? pat) (set! vars (cons pat vars))
		`(let ([,pat ,exp]) ,(body))]
	       [(number? pat) `(if (= ,pat ,exp) ,(body) (fail))]
	       [(and (eq? '? (car pat)) (pair? (cdr pat))
		     (pair? (cddr pat)) (null? (cdddr pat)))
		(let ([pred (cadr pat)] [a (caddr pat)])
		  (if (pair? exp)
		      `(let ([,t1 ,exp])
			 (if (,pred ,t1) ,(loop a t1 body) (fail)))
		      `(if (,pred ,exp) ,(loop a exp body) (fail))))]
	       [(and (eq? 'ref (car pat)) (pair? (cdr pat)) (null? (cddr pat)))
		(if (pair? exp)
		    `(let ([,t1 ,exp])
		       (if (ref? ,t1)
			   ,(loop (cadr pat) `(deref ,t1) body)
			   (fail)))
		    `(if (ref? ,exp)
			 ,(loop (cadr pat) `(deref ,exp) body)
			 (fail)))]
	       [(eq? 'vector (car pat))
		(if (pair? exp)
		    `(let ([,t1 ,exp])
		       (if (vector? ,t1)
			   (if (= ,(length (cdr pat)) (vector-length ,t1))
			       ,(loop (cdr pat) `(vector->list ,t1) body)
			       (fail))
			   (fail)))
		    `(if (vector? ,exp)
			 (if (= ,(length (cdr pat)) (vector-length ,exp))
			     ,(loop (cdr pat) `(vector->list ,exp) body)
			     (fail))
			 (fail)))]
	       [t (if (pair? exp)
		      `(let ([,t1 ,exp])
			 (if (pair? ,t1)
			     ,(loop (car pat) `(car ,t1)
				    (lambda nil
				      (loop (cdr pat) `(cdr ,t1) body)))
			     (fail)))
		      `(if (pair? ,exp)
			   ,(loop (car pat) `(car ,exp)
				  (lambda nil
				    (loop (cdr pat) `(cdr ,exp) body)))
			   (fail)))])))))])
  (declare-syntax match (? ref vector quote)
    [(match exp [pat b ...])
     (with ([code gen (pat e (begin b ...))])
	   (let ([e exp] [fail (lambda () any)]) code))]
    [(match exp [pat b ...] p2 ...)
     (with ([code gen (pat e (begin b ...))])
	   (let* ([e exp] [fail (lambda () (match e p2 ...))]) code))]))
      
(declare-syntax match-lambda (? ref vector quote)
  [(match-lambda l ...) (lambda (x) (match x l ...))])

(declare-syntax match-mulambda (? ref vector quote)
  [(match-mulambda l ...) (lambda x (match x l ...))])

(alias recur iterate)
(syntax (when <test> <exp> ...) (if <test> (begin <exp> ...)))
(define map mapcar)

(define for-each
  (lambda x
    (match x
      [(function list) (mapc function list)]
      [(function . lists)
       (recur loop ([lists lists])
	 (if (not (null? (car lists)))
	     (begin (apply function (map car lists))
		    (loop (map cdr lists)))))])))

(define compose (lambda (f g) (lambda (x) (f (g x)))))

(extend-syntax (record-case else)
  [(record-case (f x ...) c ...) (let ((v (f x ...))) (record-case v c ...))]
  [(record-case v) (error "Unmatched record-case: " v)]
  [(record-case v (else e ...)) (begin e ...)]
  [(record-case v (tag xs e ...) c ...)
   (if (eq? (car v) 'tag)
       (apply (lambda xs e ...) (cdr v))
       (record-case v c ...))])
