(eval-when (compile load) (setsyntax 35 'vcharacter))

(declare (special host-macs any))

(setq any '#!unspecified)

(def if
   (macro (l)
	  (cond ((eq (length l) 3) `(cond (,(cadr l) ,(caddr l))))
		((eq (length l) 4) `(cond (,(cadr l) ,(caddr l))
					  (t ,(cadddr l)))))))

(setq host-macs
  '(lambda if set! define! let cond begin define and or rec let* letrec
     iterate freeze begin0 apply-if macro alias step engine fluid-lambda
     fluid-let fluid-bind autoload mulambda sigma mvlet mvlet*
     semantic-mode-reset))

(def host-mac-dispatch
   (lambda (e)
      (let ([mac (car e)])
	 (cond
	    [(eq mac 'lambda) (host-lambda e)]
	    [(eq mac 'if) (host-if e)]
	    [(eq mac 'set!) (host-set! e)]
	    [(eq mac 'cond) (host-cond e)]
   	    [(eq mac 'let) (host-let e)]
	    [(eq mac 'begin) (host-begin e)]
	    [(eq mac 'define!) (host-define! e)]
	    [(eq mac 'define) (host-define e)]
	    [(eq mac 'and) (host-and e)]
	    [(eq mac 'or) (host-or e)]
;	    [(eq mac 'case) (host-case e)] ; remember to put case back in list
	    [(eq mac 'rec) (host-rec e)]
	    [(eq mac 'let*) (host-let* e)]
	    [(eq mac 'letrec) (host-letrec e)]
	    [(eq mac 'iterate) (host-iterate e)]
	    [(eq mac 'freeze) (host-freeze e)]
	    [(eq mac 'begin0) (host-begin0 e)]
	    [(eq mac 'apply-if) (host-apply-if e)]
	    [(eq mac 'macro) (host-macro e)]
	    [(eq mac 'alias) (host-alias e)]
	    [(eq mac 'mvlet) (host-mvlet e)]
	    [(eq mac 'mvlet*) (host-mvlet* e)]
	    [(eq mac 'step) (host-step e)]
	    [(eq mac 'mulambda) (host-mulambda e)]
	    [(eq mac 'sigma) (host-sigma e)]
	    [(eq mac 'synthetic-set!) (host-synthetic-set!)]
	    [(eq mac 'hidden-delay) (host-hidden-delay e)]
	    [(eq mac 'engine) (host-engine e)]
	    [(eq mac 'fluid-lambda) (host-fluid-lambda e)]
	    [(eq mac 'fluid-bind) (host-fluid-bind e)]
	    [(eq mac 'fluid-let) (host-fluid-let e)]
	    [(eq mac 'autoload) (host-autoload e)]
	    [(eq mac 'semantic-mode-reset) (host-semantic-mode-reset e)]))))
	 
(def host-let
   (lambda (*pattern*)
      (cond [(and (not (null (cadr *pattern*)))
		  (atom (cadr *pattern*)))
	     (host-iterate *pattern*)]
	    [t (cons (cons (quote #!lambda)
			   (cons (mapcar 'car (cadr *pattern*))
				 (cddr *pattern*)))
		     (mapcar 'cadr (cadr *pattern*)))])))
         
(def host-define
   (lambda (l)
      `(begin (#!set! ,(cadr l) ,(caddr l))
	      (quote ,(cadr l)))))

(def host-define!
   (lambda (l)
      `(begin (#!set! ,(cadr l) ,(caddr l))
	      (quote ,(cadr l)))))

(def host-and
   (lambda (*pattern*)
      (cond [(null (cdr *pattern*)) (quote true)]
	    [(null (cddr *pattern*)) (cadr *pattern*)]
	    [t (list (quote #!if)
		    (cadr *pattern*)
		    (cons 'and (cddr *pattern*))
		    (quote false))])))

(def host-or
   (lambda (*pattern*)
      (cond [(null (cdr *pattern*)) (quote false)]
	    [(null (cddr *pattern*)) (cadr *pattern*)]
	    [t (let ([g (gensym)])
		  (list (list (quote #!lambda)
			      (cons g nil)
			      (list (quote #!if)
				    g
				    g
				    (cons 'or (cddr *pattern*))))
			(cadr *pattern*)))])))

(def host-rec
   (lambda (l) `((#!lambda (,(cadr l)) (#!set! ,(cadr l) ,(caddr l))) any)))

(def host-let*
   (lambda (*00000)
      ((lambda (tail)
	  (let ([pairs (car tail)]
		[body (cdr tail)])
	     (list (cons '#!lambda
		      (cons (list (caar pairs))
			    (cond
			       [(cdr pairs)
				(list
				   (cons 'let*
				      (cons (cdr pairs)
					    body)))]
			       [t body])))
		   (cadar pairs))))
       (cdr *00000))))

(def host-letrec
   (lambda (*00000)
      ((lambda (tail)
	  (let ([pairs (car tail)] [body (cdr tail)])
	     (cons (cons '#!lambda
		      (cons (mapcar 'car pairs)
			    (append (mapcar (function (lambda (x)
							 (cons '#!set! x)))
				       pairs)
			       body)))
		   (mapcar (function (lambda (x) 'any)) pairs))))
       (cdr *00000))))

(def host-cond
   (lambda (e)
      (let ([e (cdr e)])
	 (cond [(null e) 'any]
	       [(and (null (cdr e)) (eq (caar e) t))
		(cond [(null (cdar e)) t]
		      [t ((lambda (x)
			     (cond [(cdr x) (cons 'begin x)]
				   [t (car x)]))
			  (cdar e))])]
	       [(null (cdr e))
		(let ([test (caar e)]
		      [then (cdar e)])
		   (cond [(null test) 'any]
			 [(null then)
			  `((#!lambda (*00000)
			       (#!if *00000 *00000))
			    ,test)]
			 [t  `(#!if ,test
				 ,((lambda (x)
				      (cond [(cdr x) (cons 'begin x)]
					    [t (car x)]))
				   then))]))]
	       [t (let ([test (caar e)]
			[then (cdar e)])
		     (cond [(null test) (cons 'cond (cdr e))]
			   [(null then)
			    (let ([g (gensym)])
			       `((#!lambda (,g)
				    (#!if ,g ,g
				       ,(cons 'cond (cdr e))))
				 ,test))]
			   [t `(#!if ,test
				  ,((lambda (x)
				       (cond [(cdr x) (cons 'begin x)]
					     [t (car x)]))
				    then)
				  ,(cons 'cond (cdr e)))]))]))))
    
(def host-iterate	; don't delete this without changing let
   (lambda (*pattern*)
      (cons (list (list (quote #!lambda)
			(cons (cadr *pattern*) nil)
			(list (quote #!set!)
			      (cadr *pattern*)
			      (cons (quote #!lambda)
				    (cons (mapcar 'car (caddr *pattern*))
					  (cdddr *pattern*)))))
		  (quote any))
	    (mapcar 'cadr (caddr *pattern*)))))

;(def host-case
;   (lambda (*00000)
;      ((lambda (*00000)
;	  (let ([tag (car *00000)]
;		[pairs (cdr *00000)])
;	     (list
;		(let ([g (gensym)])
;		   (list (quote lambda)
;			 (list g)
;			 (iterate-over pairs pairs tag g)))
;		tag)))
;       (cdr *00000))))

(def host-freeze
   (lambda (*pattern*)
      (cons '#!lambda (cons nil (cdr *pattern*)))))

(def host-begin0
   (lambda (*pattern*)
      (let ([v (gensym)])
	 (list (cons '#!lambda
		  (cons (cons v nil)
			(append (cddr *pattern*) (cons v nil))))
	       (cadr *pattern*)))))

(def host-apply-if
   (lambda (*pattern*)
      (let ([v (gensym)])
	 (list (list '#!lambda
		  (cons v nil)
		  (list '#!if
		     v
		     (list (caddr *pattern*) v)
		     (cons 'begin (cdddr *pattern*))))
	       (cadr *pattern*)))))

(def host-macro
   (lambda (*pattern*)
      (list 'begin
	 (list 'add-to-syntax-table
	    (list 'quote (cons (cadr *pattern*) nil))
	    (list '#!lambda
	       (cons 'l nil)
	       (list 'beta-tag
		  (list 'copy
		     (list (caddr *pattern*)
			   '(intern* l))))))
	 (list 'quote (cadr *pattern*)))))
   
(def host-alias
   (lambda (*pattern*)
      (list 'begin
	 (list 'add-to-syntax-table
	    (list 'cons
	       (list 'quote (cadr *pattern*))
	       (list 'cdr
		  (list 'cadr
		     (list 'getprop
			(list 'quote (caddr *pattern*))
			''beta-transform))))
	    (list '#!lambda
	       (cons 'l nil)
	       (list 'cons
		  (list 'quote (caddr *pattern*))
		  '(cdr l))))
	 (list 'quote (cadr *pattern*)))))
   
(def host-step
   (lambda (*pattern*)
      (list 'let
	 (mapcar (function
		    (lambda (^00028)
		       (list (car ^00028) (cadr ^00028))))
	    (cadr *pattern*))
	 (cons (list 'rec
		  '*00000
		  (list '#!lambda
		     nil
		     (list '#!if
			(car (caddr *pattern*))
			(cons 'begin (cdr (caddr *pattern*)))
			(cons 'begin
			   (append (cdddr *pattern*)
			      (append 
				 (mapcar (function
					    (lambda (^00026)
					    (list '#!set!
					       (car ^00026)
					       (list
						   (caddr ^00026)
						   (car ^00026)))))
				    (cadr *pattern*))
				 (cons (cons '*00000 nil) nil)))))))
	       nil))))

(def host-fluid-let
   (lambda (*pattern*)
      (let ([pairs (cadr *pattern*)] [bods (cddr *pattern*)])
	 (cond
	    [(null pairs) (cons 'begin bods)]
	    [t (list '#!fluid-bind (car (car pairs)) (cadr (car pairs))
		  (cons 'fluid-let (cons (cdr pairs) bods)))]))))

(def host-fluid-bind (lambda (*pat*) (cons '#!fluid-bind (cdr *pat*))))

(def host-fluid-lambda
  (lambda (*pattern*)
    (let ([ids (new-ids (cadr *pattern*))])
      (list '#!lambda ids
	 (cons 'fluid-let
	    (cons
	      (mapcar '(lambda (id1 id2) (list id1 id2))
		(identifier-list (cadr *pattern*))
		(identifier-list ids))
	      (cddr *pattern*)))))))

(def new-ids
  (lambda (args)
    (cond
      [(dtpr args) (cons (gensym) (new-ids (cdr args)))]
      [(null args) nil]
      [t (gensym)])))

(def identifier-list
   (lambda (args)
      (cond
	 [(dtpr args) (cons (car args) (identifier-list (cdr args)))]
	 [(null args) nil]
	 [t (list args)])))
   
(def host-autoload
   (lambda (*pattern*)
      (list 'define
	 (cadr *pattern*)
	 (list '#!lambda
	    (caddr *pattern*)
	    (list 'load (cadddr *pattern*))
	    (list 'apply (cadr *pattern*) (caddr *pattern*))))))

(def host-begin
   (lambda (*pattern*)
      (cond
	 [(null (cdr *pattern*)) nil]
         [t (cons (cons '#!lambda (cons nil (cdr *pattern*))) nil)])))

;(def iterate-over 
;   (lambda (p pairs tag g)
;      (if p
;	 (if (and (null (cdr p))
;		  (eq (caar p) (quote else)))
;	     (cons
;		(quote begin)
;		(cdar p))
;	     (list
;		(quote if)
;		(list
;		   (cond
;		      [(atom (caar p)) (quote eq?)]
;		      [t (quote memq)])
;		   g
;		   (list
;		      (quote quote)
;		      (caar p)))
;		(cons (quote begin)
;		      (append (cdar p) (quote nil)))
;		(iterate-over (cdr p) pairs tag g)))
;	 (cons
;	    (quote begin)
;	    (cons
;	       (quote (print (quote |[case |)))
;	       (cons
;		  (list (quote print)
;			(list (quote quote) tag))
;		  (cons
;		     (cons (quote if)
;			   (cons
;			      (list (quote quote) pairs)
;			      (quote ((newline)))))
;		     (cons
;			(list
;			   (quote mapc)
;			   (quote
;			      (lambda (x)
;				 (writeln
;				    (quote |   |)
;				    x)))
;			   (list (quote quote) pairs))
;			`((writeln (quote |]|))
;			  (writeln
;			     (quote
;				|[case: unmatched tag: |)
;			     ,g
;			     (quote |]|)))))))))))

(def host-engine
   (lambda (*pattern*)
      (list 'make-engine (cons '#!lambda (cons nil (cdr *pattern*))))))

(def host-lambda
   (lambda (*pattern*)
      (cons '#!lambda (cdr *pattern*))))

(def host-if
   (lambda (*pattern*)
      (cons '#!if (cdr *pattern*))))

(def host-set!
   (lambda (*pattern*)
      (cons '#!set! (cdr *pattern*))))

(def host-mulambda
   (lambda (*pattern*)
      (cons '#!lambda (cdr *pattern*))))

(def help-sigma
   (lambda (i new-i)
      (list '#!set! i new-i)))

(def host-sigma
   (lambda (*pattern*)
      (let ([new-ids (mapcar 'gensym (cadr *pattern*))])
	 (cons '#!lambda
	     (cons new-ids
		 (append (mapcar 'help-sigma (cadr *pattern*) new-ids)
		    (cddr *pattern*)))))))

(def map-vars 
   (lambda (vars body)
      (cond
	 [(dtpr vars) 
	  (let [[v (map-vars [cdr vars] body)]]
	     (let [[vvars (car v)]
		   [vbody (cadr v)]]
		(let [[a (make-var [car vars] vbody)]]
		   (let [[avar (car a)]
			 [abody (cadr a)]]
		      (list (cons avar vvars)
			    abody)))))]
	 [t (list vars body)])))

(def make-var
   (lambda (vars body)
      (cond [(dtpr vars)
	     (let [[p (map-vars vars body)]]
		(let [[pvars (car p)]
		      [pbody (cadr p)]]
		   (let [[tvar (gensym 'm)]]
		      (list tvar 
			 `(apply (lambda ,pvars
				    ,pbody)
				 ,tvar)))))]
	    [t (list vars body)])))

(def make-let 	  
   (lambda (var-lists body)
      (cond [(null var-lists) (list nil nil body)]
	    [t (let ([ll (car var-lists)])
		  (cond
		     [(or (atom ll)
			  (not (= (length ll) 2)))
		      (raise (list 'SE%mvlet 0 t '|Bad let pair:| ll))]
		     [t (let ([vars (car ll)]
			      [exp (cadr ll)])
			   (let [[x (make-var vars body)]]
			      (let [[xvar (car x)]
				    [xbody (cadr x)]]
				 (let [[y (make-let [cdr var-lists] xbody)]]
				    (let [[yvars (car y)]
					  [yvals (cadr y)]
					  [ybody (caddr y)]]
				       (list (cons xvar yvars)
					     (cons exp yvals)
					     ybody))))))]))])))

(def make-let* 	  
   (lambda (var-lists body)
      (cond
	 [(null var-lists) body]
	 [t (let ([ll (car var-lists)])
	       (cond [(or (atom ll) (not (= (length ll) 2)))
		      (raise (list 'SE%mvlet 0 t '|Bad let pair:| ll))]
		     [t (let ([vars (car ll)]
			      [exp (cadr ll)])
			   (let [[y (make-let* [cdr var-lists] body)]]
			      (let [[x (make-var vars y)]]
				 (let [[xvar (car x)]
				       [xbody (cadr x)]]
				    `((#!lambda (,xvar) 
					 ,xbody)
				      ,exp)))))]))])))

(def host-mvlet
   (lambda (form)
      (let [[x (make-let [cadr form] (cons 'begin (cddr form)))]]
	 `((lambda ,(car x) ,(caddr x))
	   . ,(cadr x)))))

(def host-mvlet*
   (lambda (form)
      (make-let* (cadr form) (cons 'begin (cddr form)))))


(def host-semantic-mode-reset
   (lambda (form)
      (set-lexical-semantics nil)
      (set-application-semantics nil)
      (set-literal-semantics nil)
      t))
