(eval-when (compile load) (setsyntax 35 'vcharacter)) ;#

(declare (special last-ring ring-size %primitives))
(setq ring-size 10)
(setq %primitives nil)

(def include-primitives
   (lambda ()
      (setq %primitives nil)))

(def exclude-primitives
   (lambda ()
      (setq %primitives t)
      t))

(def init-history-queue
   (lambda (n)
      (setq ring-size n)
      (prog (i ring)
	    (setq i n)
	    (setq ring nil)
	    top (cond [(= 0 i) (setq last-ring (nconc ring ring)) (return t)])
	    (setq i (sub1 i))
	    (setq ring (cons (cons 0 nil) ring))
	    (go top))))

(init-history-queue ring-size)

(def print-exp
   (lambda (x)
      (let ([raw (cadr x)]
	    [ans (caddr x)]
	    [ins (cadddr x)])
         (schprint (car x))
         (schprint ": with ")
	 (mapc (function magic-schprint) (matchup (mktlis raw) ins))
         (new-line)
	 (schprint "       ")
	 (schprint raw)
	 (schprint " ===> ")
	 (schprint ans)
	 (new-line))))

(def magic-schprint
   (lambda (x)
      (schprint x)
      (schprint " ")))

(def matchup
   (lambda (l1 l2)
      (cond
	 [(eq l2 '*) (list "unbound-id")]
	 [(null l1) nil]
	 [(or (numberp (car l1))
	      (dtpr (car l1)))
	  (matchup (cdr l1) (cdr l2))]
	 [t (cons (list (car l1) "=" (car l2))
		  (matchup (cdr l1) (cdr l2)))])))

(def mktlis
   (lambda (e)
      (cond
	 [(null e) nil]
	 [(not (dtpr (car e)))
	  (cond
	     [(memq (car e) (cdr e)) (mktlis (cdr e))]
	     [t (cons (car e) (mktlis (cdr e)))])]
	 [t (mktlis (cdr e))])))

(def hist-pred
   (lambda (x)
      (cond [(not (symbolp x)) nil]
	    [t (not (or (memq x 
			   '(playback1 playback exclude-primitives
			       include-primitives init-history-queue))
			(cond
			   [%primitives (or (get x 'scheme-primitive)
					    (get x 'constant-primitive))]
			   [t nil])))])))

(def playback1
   (lambda (n m)
      (prog (front tail ttail)
	 (setq front (nthcdr (add1 (- ring-size n)) last-ring))
	 (setq tail (nthcdr (sub1 m) front))
	 (setq ttail (cdr tail))
         (rplacd tail nil)
	 (mapc 'print-exp front)
	 (rplacd tail ttail)
	 (return nil))))
            
(def recall
   (lambda (v)
      (cond
	 [(hist-pred (car v))
	  (let ([n (caar last-ring)])
	     (setq last-ring (cdr last-ring))
	     (rplaca last-ring (list (add1 n) v 'unknown '*))
	     (car last-ring))]
	 [t (list '* '* '* '*)])))

(def %store-ans
   (lambda (box ans)
      (rplaca (cddr box) ans)
      ans))

(def %store-vals
   (lambda (box vals)
      (rplaca (cdddr box) vals)))

(def get-frame
   (lambda (n)
      (prog (front l)
	    (setq front (cdr last-ring))
	    (rplacd last-ring nil)
	    (setq l front)
	    loop 
	    (cond [(null l)
		   (princ "The ")
		   (ldisplay n)
		   (princ "th application is no")
		   (terpri)
		   (princ "longer in the history list, ")
		   (rplacd last-ring front)
		   (return '|sorry.|)]
		  [(= n (caar l))
		   (rplacd last-ring front)
		   (return (car l))])
	    (setq l (cdr l))
	    (go loop))))

(def inst
   (lambda (e)
      (list '#!application (cons 'list (help-inst e)))))

(def help-inst
   (lambda (l)
      (cond
	 [(null l) nil]
	 [(not (dtpr (car l)))
	  (cond
	     [(memq (car l) (cdr l)) (help-inst (cdr l))]
	     [t (cons (car l) (help-inst (cdr l)))])]
	 [t (help-inst (cdr l))])))

