(declare (special scheme-directory **fnv** **ticks** *toplevel-continuation*
	    *scheme-version* *banner-line* unprintable-symbols))

(def if
   (macro (l)
	  (cond ((eq (length l) 3) `(cond (,(cadr l) ,(caddr l))))
		((eq (length l) 4) `(cond (,(cadr l) ,(caddr l))
					  (t ,(cadddr l)))))))

(sstatus gcstrings t)  ; garbage collect strings

(declare (special *initial-env* *initial-args* *initial-result* *init-base*
	    piport poport *initial-pc* *initial-cont* development?))

;;; for system debugging setq development? to a non-nil value and
;;; a lisp debugger will be entered (instead of a (reset)) on
;;; vsm, compiler, etc. errors.

(setq development? nil)

(cond [(not (null development?)) (*rset t) (sstatus translink nil)])

(def lisp-debug
  (lambda ()
    (if (not (null development?))
	(debug '|developmental debugging|)
	(reset))))

;;; Initial vsm register values

(declare (special *initial-fnv* keyboard))
(load (concat scheme-directory "base.o"))  ; base environment functions

(setq initial-unprintables
  '((&closure . <FUNCTION>) ;;; unprintables
	(&synthetic-lambda . <FUNCTION>)
	(&cont . <FUNCTION>)
	(&rest-closure . <CLOSURE>)
	(&transform . <TRANSFORM>)
	(&sys . <SYSTEM-FUNCTION>)
	(&port . <PORT>)
	(&base . <BASE-ENV>)
	(&vector . <VECTOR>)
	(&ref . <REF>)
	(&unassigned-constant . <UNASSIGNED-CONSTANT>)
	(&closed-port . <CLOSED-PORT>)
	(&fluid-env . <FLUID-ENVIRONMENT>)
	(&lexical-env . <LEXICAL-ENVIRONMENT>)))

(setq keyboard `(&port ,piport))

(setq *init-base* (genbase))

(extendbase 'scheme-global-note nil)
(extendbase 'scheme-prompt ">>> ")
(extendbase 'defined-forms nil)
(extendbase 'defining-forms nil)
(extendbase 'input-port keyboard)
(extendbase 'output-port `(&port ,poport 74 . 1))
(extendbase 'unprintables initial-unprintables)
(extendbase 'scheme-top-level nil)

(setq *initial-fnv* nil)

(setq *initial-env* nil)

; all the other hand S-coded definitions are at the head of std.s and sys.s

(setq *initial-pc* '((*pr &ms . result)))

(setq *toplevel-function*
  `(&closure
     (1 (v) (*lr 0 . 0) (*pu) (*gr . ,(baselocation 'scheme-top-level))
	(*at . 1))))

(setq *initial-vsm-args* '(--------------------------------))
(setq *initial-args* nil)
(setq *initial-result* nil)
(setq *initial-cont* nil)
(setq *toplevel-continuation*
  `((,*initial-pc* ,*initial-args* . ,*initial-env*) . ,*initial-cont*))

(def run
  (lambda (pc)
    (setq **fnv** *initial-fnv*)
    (vsm pc
      *toplevel-continuation*
      *initial-env*
      *initial-args*
      *initial-result*)))
   
(def load-scheme
  (lambda ()
    (prog (port)
	  (load (concat scheme-directory 'except.o)) ; exception handler
	  (load (concat scheme-directory 'error.o)) ; error handler
	  (load (concat scheme-directory 'print.o)) ; print stuff
	  (load (concat scheme-directory 'hostmacs.o)) ; host macros
	  (setq **fnv** *initial-fnv*)
	  (load (concat scheme-directory 'env.o))   ; initial environment
	  ; must be loaded before
	  ; env!!
	  (load (concat scheme-directory 'constant.o)) ; constants
	  (load (concat scheme-directory 'vector.o)); vectors
	  (load (concat scheme-directory 'prims.o)) ; primitives
	  (load (concat scheme-directory 'vsm.o))   ; virtual machine
	  (load (concat scheme-directory 'comp.o))  ; scheme compiler in 
	  ; lisp
	  (load (concat scheme-directory 'expand.o)); beta-expander
	  (load (concat scheme-directory 'mkmac.o)) ; mkmac
	  (load (concat scheme-directory 'signal.o)); signal handlers
	  (load (concat scheme-directory 'debug.o)); history debugger
	  (setq port (infile (concat scheme-directory 'sys.s)))
	  (run (compile (read port)))
	  (close port))))

(setq user-top-level
  '(lambda ()
     (prog ()
	   loop
	   (princ *banner-line*)
	   (princ *scheme-version*)
	   (terpri)
	   (setq **fnv** *initial-fnv*)
	   (setq **ticks** nil)
	   (errset (vsm '((*at . 1)) 
			 *initial-cont*
			 *initial-env*
			 *initial-vsm-args*
			 *toplevel-function*))
	   (go loop))))

(setq unprintable-symbols (mapcar 'car initial-unprintables))

(setq **fnv** nil **ticks** nil) ; initialize virtual machine registers

(load-scheme)
