;;; -*-Scheme-*-
;;;
;;; mgu algorithms
;;;

;;; 30 Oct 88 identified major structures and code to be fixed -- mw
;;;  (with help from margaret)

;;; Revision 1.6  85/01/11  15:08:49  mw

;;; Revision 1.1  83/08/25  14:49:08  mw
;;; Initial revision

;;;; Most General Unifier

;; (declare (usual-integrations)) ;; for C-scheme

;;; ****************************************************************

;;; seen-list : a list of nodes, without duplications.  This is
;;; obsolescent, and will be eliminated when we use congruence.

(define seen? memq)

(define add-to-seen
  (lambda (x l)
    (if (memq x l)
	l
	(cons x l))))

;;; ****************************************************************

;;; mgu:  calls mgu-body wrapped in a timer.  Need to replace by
;;; uniform instrumentation package.

;;; Arguments:
;;; t1, t2 -- type expressions, with free variables
;;; env   -- a type env
;;; succeed -- continuation for success, expects a type env
;;; fail -- continuation for failure, expects a message.

(define mgu
  (lambda (t1 t2 env succeed fail)
    (let ((start (ptime)))
      (mgu-body t1 t2 env
		(lambda (x) (update-mgu-clock! start) (succeed x))
		(lambda (x) (update-mgu-clock! start) (fail x))))))

(define update-mgu-clock!
  (lambda (start)
    (set-car! mgu-time (+ (car mgu-time)
			  (- (- (car (ptime)) (car start))
			     (- (cadr (ptime)) (cadr start)))))))

;;; ****************************************************************

;;; mgu-body.  Does main work of mgu.  

(define mgu-body
  (lambda (t1 t2 env succeed fail)
    (letrec ((loop
	       (lambda (t1 seen1 t2 seen2 env succeed)
		 (cond ((and (eq? t1 t2)
			     (not (bad-typevar? t1))
			     (not (bad-typevar? t2)))
			(succeed env))
		   ((var? t1)
		    (cond ((isbound? t1 env)
			   (if (and (seen? t1 seen1)
				    (var? t2)
				    (seen? t2 seen2))
			     (compare-looping-structures t1 t2 env
			       succeed fail)
			     (loop (lookup-typevar t1 env)
				   (add-to-seen t1 seen1)
				   t2 seen2 env succeed)))
		      ((and (var? t2) (isbound? t2 env))
		       (loop t1 seen1 (lookup-typevar t2 env)
			 (add-to-seen t2 seen2) env succeed))
		      ((bad-typevar? t1)  (fail `(undefined-type: ,t1)))
		      ((bad-typevar? t2)  (fail `(undefined-type: ,t2)))
		      (else  (succeed (extend-type-env t1 t2 env)))))
		   ((var? t2)
		    (loop t2 seen2 t1 seen1 env succeed))
		   ((not (eq? (type->constructor t1) (type->constructor t2)))
		    (fail `(mismatch: ,t1 ,t2)))
		   (else
		     (letrec ((inner	; loop thru subterms
				(lambda (l1 l2 env)
				  (if (null? l1)
				    (succeed env)
				    (loop (car l1) seen1 (car l2) seen2 env
				      (lambda (env)
					(inner (cdr l1)
					       (cdr l2)
					       env)))))))
		       (cond ((eq? (type->constructor t1) 'seq)
			      (unify-seq-tails
				(type->args t1) (type->args t2) inner env
				fail succeed))
			 ((eq? (length t1) (length t2))
			  (inner (type->args t1) (type->args t2) env))
			 (else
			   (fail `(wrong-no-of-args-to-constructor:
				    ,t1 ,t2))))))))))
      (loop t1 nil t2 nil env succeed))))

;;; compare-looping-structures is known to be buggy, but will be
;;; replaced when we go to congruence closure algorithm.

(define compare-looping-structures
  (lambda (t1 t2 env succeed fail)
    (letrec ((loop
	      (lambda (t1 t2)
		(cond ((var? t1)  (loop (lookup-typevar t1 env) t2))
		      ((var? t2)  (loop t1 (lookup-typevar t2 env)))
		      ((eq? (car t1) (car t2))  (succeed env))
		      (else  (fail `(unmatched-loop: ,t1 ,t2)))))))
      (loop t1 t2))))

(define unify-seq-tails
  (lambda (l1 l2 inner env fail succeed)
    (cond ((and l1 (atom? l1))
	   (cond ((isbound? l1 env)
		  (unify-seq-tails (lookup-typevar l1 env) l2 inner env
				   fail succeed))
		 ((bad-typevar? l1)
		  (fail `(undefined-type: ,l1)))
		 ((bad-typevar? l2)
		  (fail `(undefined-type: ,l2)))
		 ((eq? l1 l2)
		  (succeed env))
		 (else
		  (succeed (cons (cons l1 l2) env)))))
	  ((and l2 (atom? l2))
	   (unify-seq-tails l2 l1 inner env fail succeed))
	  ((eq? (length l1) (length l2))
	   (inner l1 l2 env))
	  (else
	   (fail `(wrong-no-of-args-to-function: ,l1 ,l2))))))

(define test-mgu
  (lambda (t1 t2)
    (mgu t1 t2 empty-type-env
      (lambda (x) x)
      (lambda (msg) (printf "mgu failed: ~s" msg)))))

(define mgu-test1
  (lambda ()
    (test-mgu '(-> (seq int) int) '(-> (seq x) y))))
