;;; ***********************************
;;; * Dino P. Oliva                   *
;;; * A simple recursive language     *
;;; * Version 3.0 - The final version *
;;; **************************************************
;;; * Instructions:                                  *
;;; * 1] Get into SPS                                *
;;; * 2] Load this file                              *
;;; * 3] Sample runs are in thunks 'pgm-1' to 'pgm6' *
;;; **************************************************

; Type information


; Basic Types

(define-type-abbrev Val Number)


; Production types

(define-type-abbrev Exp (-> (seq Env) (-> (seq E-cont) Val)))
(define-type-abbrev Assert (list Decl))
(define-type-abbrev Decl (pair Id Exp))
(define-type-abbrev Id symbol)
(define-type-abbrev Number int)


; Types of continuations

(define-type-abbrev E-cont (-> (seq Val) Val))

; Environment types (envs as contours)

(define-type-abbrev Env (-> (seq Id) (-> (seq E-cont) Val)))


;;; **********************************************************************

; Basic functions

(declare-unchecked assoc () (-> (seq Id Assert) Decl))

(define-unchecked defined?
  (-> (seq Decl) bool)
  (lambda (dec)
    (if (null? dec) nil t)))

(define-checked Y-1
  (-> (seq (-> (seq Env) Env)) Env)
  (lambda (f)
    (let ([g (lambda (x) (lambda (x1) ((f (x x)) x1)))])
      (g g))))

(define-checked init-env
  Env
  (lambda (id) 
    (lambda (cont) -1)))

(define-checked init-cont
  Cont
  (lambda (val) val))

(define-checked extend-contour
  (-> (seq Assert Env) Env)
  (lambda (assert env)
    (lambda (id) 
      (let ((lu (assoc id assert)))
	(if (defined? lu) ((rson lu) env) (env id))))))

;(define-checked extend-rec-contour 
;  (-> (seq Assert Env) Env)
;  (lambda (assert env)
;    (lambda (id) 
;      (let ([lu (assoc id assert)])
;	(if (defined? lu) 
;	    ((rson lu) (Y-1 (lambda (env2) (extend-rec-contour assert env))))
;	    (env id))))))

;;; This seems to be a little more interesting.

(define-checked extend-rec-contour 
  (-> (seq Assert Env) Env)
  (lambda (assert env)
    (Y-1 (lambda (env2)
	   (lambda (id) 
	     (let ([lu (assoc id assert)])
	       (if (defined? lu) ((rson lu) env2) (env id))))))))


;;; ******************************************************************

(define-checked fetch
  (-> (seq Id) Exp)
  (lambda (id)
    (lambda (env)
      (lambda (e-cont)
	((env id) e-cont)))))

(define-checked return-val
  (-> (seq Number) Exp)
  (lambda (num)
    (lambda (env)
      (lambda (e-cont)
	(e-cont num)))))

(define-checked return-let
  (-> (seq Assert Exp) Exp)
  (lambda (assert exp)
    (lambda (env)
      (lambda (e-cont)
	((exp (extend-contour assert env)) e-cont)))))

(define-checked return-letrec
  (-> (seq Assert Exp) Exp)
  (lambda (assert exp)
    (lambda (env)
      (lambda (e-cont)
      ((exp (extend-rec-contour assert env)) e-cont)))))

(define-checked assert-decl 
  (-> (seq Decl) Assert) 
  (lambda (decl)
    (cons decl nil)))

(define-checked assert-empty-decl
  Assert
  nil)

(define-checked assert-decls
  (-> (seq Decl Assert) Assert)
  (lambda (decl assert)
    (cons decl assert)))

(define-checked declare
  (-> (seq Id Exp) Decl)
  (lambda (id exp)
    (pair id exp)))


;;; *******************************************************************

; The transducer.

(define-grammar rec-rho
  Program
    
  (program				; <program> ::= <exp>
    (Program (Exp))
    (exp)
    ((exp init-env) init-cont))

  (exp0					; <exp> ::= <number>
    (Exp (Number))
    (num)
    (return-val num))

  (exp1					; <exp> ::= <id>
    (Exp (Id))
    (id)
    (fetch id))

  (exp2					; <exp> ::= let <assert> in <exp>
    (Exp ('let Assert 'in Exp))
    (assert exp)
    (return-let assert exp))

  (exp3					; <exp> ::= letrec <assert> in <exp>
    (Exp ('letrec Assert 'in Exp))
    (assert exp)
    (return-letrec assert exp))

;  (assert0				; <assert> ::= <decl> 
;    (Assert (Decl))
;    (decl)
;    (assert-decl decl))

  (assert0
    (Assert ())
    ()
    assert-empty-decl)

  (assert1				; <assert> ::= <decl> <assert> 
    (Assert (Decl Assert))
    (decl assert)
    (assert-decls decl assert))
     
  (decl					; <decl> ::= <id> = <exp>
    (Decl (Id '= Exp))
    (id exp)
    (declare id exp))

  (symbol-to-id			; <id> ::= symbol
    (Id (symbol))
    (id)
    id)

  (int-to-number			; <number> ::= int
    (Number (int))
    (num)
    num)
  )


;;; *******************************************************************



;;; *******************************************************************

(define run
  (lambda (string)
    (print string)
    (newline)
    (rec-rho string)))

(define pgm-1
  (lambda ()
    (run "letrec a = 4 in b")))

(define pgm0
  (lambda ()
    (run "let b = 0 in let a = b in a")))

(define pgm1
  (lambda ()
    (run "let b = 1 in letrec a = b in a")))

(define pgm2
  (lambda ()
    (run "letrec b = 2 in let a = b in a")))

(define pgm3
  (lambda ()
   (run "letrec b = 3 in letrec a = b in a")))

(define pgm4
  (lambda ()
    (run "letrec a = b b = 4 c = a in c")))

(define pgm5
  (lambda ()
    (run "let a = 5 in let a = 6 b = a in b")))

(define pgm6
  (lambda ()
    (run "let a = 5 in letrec a = 6 b = a in b")))



