;;; Data Structures for SPS

;;; Created Sat Nov  5 10:31:43 1988

;;; ****************************************************************

;;; Types

;;; should have explicit syntax for these.

;;; type ::= atom | (constructor . args)

(define gen-type-var gensym)		; this should be a little cleverer
(define var? atom?)  ;; this should be typevar? (maybe?)

(define type->constructor car)
(define type->args  cdr)

(define make-type
  (lambda (constructor args) (cons constructor args)))

(define make-functional-type
  (lambda (arg-types result-type)
    `(-> (seq . ,arg-types) ,result-type)))

;;; ****************************************************************

;;; Type Schemes

;;; type-scheme ::= (quantified-variables type)
;;; quantified-variables ::= list of type variables free in the type.

;;; (make-type-scheme typevars type)
;;; (type-scheme->generics type-scheme)
;;; (type-scheme->type type-scheme)
;;; (subst-gensyms-for-generics type-scheme)  --returns a type
;;; (external-type->type-scheme external-type) 

(define make-type-scheme
  (lambda (typevars type) (list typevars type)))
(define type-scheme->generics car)
(define type-scheme->type     cadr)

(define subst-gensyms-for-generics
  (lambda (type-scheme) 
    (let* ((generics (type-scheme->generics type-scheme)) 
	   (type-exp (type-scheme->type type-scheme))
	   (newvars (mapcar (lambda (x) (gen-type-var)) generics))
	   (table (ext-ribcage generics newvars nil)))
      (letrec ((loop
		(lambda (x)
		  (cond ((null? x) x)
			((and (atom? x) (memq x generics))
			 (car (assq-ribcage x table)))
			((atom? x)  x)
			(else  (cons (loop (car x)) (loop (cdr x))))))))
	(loop type-exp)))))


(define subst-consts-for-generics
  (lambda (type-scheme) 
    (let* ((generics (type-scheme->generics type-scheme)) 
	   (type-exp (type-scheme->type type-scheme))
	   (newconsts
	     (mapcar
	       (lambda (x) (make-type (gen-type-var) '()))
	       generics))
	   (table (ext-ribcage generics newconsts nil)))
      (letrec ((loop
		 (lambda (x)
		   (cond ((null? x) x)
		     ((and (atom? x) (memq x generics))
		      (car (assq-ribcage x table)))
		     ((atom? x)  x)
		     (else  (cons (loop (car x)) (loop (cdr x))))))))
	(loop type-exp)))))

;;; external-type->type-scheme takes an external type (possibly of the form)
;;; (generic (x) ...) and converts it into a type scheme.

(define external-type->type-scheme
  (lambda (external-type) 
    (cond
      [(var? external-type)
	(make-type-scheme '() external-type)]
      [(eq? (car external-type) 'generic)
       (make-type-scheme (cadr external-type) (caddr external-type))]
      [else
	(make-type-scheme '() external-type)])))

;;; ****************************************************************

;;; type environments.

;;; maps type variables to type expressions (what about quantifiers?
;;; they are only in type hypotheses.)

;;; Operations:
;;; isbound? var env
;;; is-locally-bound? var env
;;; lookup-typevar var env
;;; empty-type-env          --added Sat Nov  5 10:35:24 1988
;;; extend-type-env var type env --added Sat Nov  5 10:36:52 1988

;;; bad-typevar? var   -- a mystery

(define bad-typevar? (lambda (x) #f))	; a stub

;;; current representation:  a-list (passable to assq) -- nil defaults
;;; to global-type-env.
;;; global-type-env is another a-list.

(define empty-type-env '())

(define extend-type-env
  (lambda (var type env)
    (cons (cons var type) env)))

(define isbound?
  (lambda (var env)
    (or (assq var env) (assq var global-type-env))))

(define is-locally-bound? assq)

(define lookup-typevar
  (lambda (var env)
    (let ((pair (assq var env)))
      (if pair
	  (cdr pair)
	  (cdr (assq var global-type-env))))))

;;; global type environment

(define global-type-env '())

(define initialize-global-type-env!
  (lambda ()
    (set! global-type-env '())))

(define extend-global-type-env!
  (lambda (var type)
    (set! global-type-env (cons (cons var type) global-type-env))))

;;; ****************************************************************

;;; Ribcages

;;; Operations:

;;; empty-ribcage
;;; (ext-ribcage vbles vals env)
;;; (assq-ribcage var ribcage)  --returns list with value in car, or
;;; else #f  -- this should be changed to take success and failure
;;; continuations, and return value (not list) to the success continuation.

(define empty-ribcage '())

(define ext-ribcage
  (lambda (vbles vals env)
    (cons (cons vbles vals) env)))

(define assq-ribcage
  (lambda (var env)
    (if (null? env)
	#f
	(letrec ((loop
		  (lambda (vars cells)
		    (if (null? vars)
			(assq-ribcage var (cdr env))
			(if (eq? var (car vars))
			    cells
			    (loop (cdr vars) (cdr cells)))))))
	  (loop (caar env) (cdar env))))))

;;; ****************************************************************

;;; Type Hypotheses (or Assumptions or Prefixes)

;;; type-hypotheses simulates a function from variables to type-schemes

;;; Operations:

;;; empty-prefix

;;; (ext-prefix list-of-type-variables list-of-typeschemes prefix)
;;; (lookup-symbol-type variable type-hypotheses failure-continuation)

;;; Representation:

;;; type-hypotheses ::= ribcage of type-schemes;  empty ribcage
;;; means global type assumptions.  

;;; assq-ribcage sucks, and should be replaced by something sensible.


(define empty-prefix empty-ribcage)

(define ext-prefix
  (lambda (vbles schemes p)
    (ext-ribcage vbles schemes p)))

(define lookup-symbol-type
  (lambda (var p fail)		; p is a ribcage
    (let
      ((ans (assq-ribcage var p))); assq-ribcage returns cell w/ data in car
      (if ans 
	  (subst-gensyms-for-generics (car ans))
	  (let
	    ((ans (lookup-global-type var)))
	    (if ans
		(subst-gensyms-for-generics ans)
		(fail `(untyped-identifier ,var))))))))


; this may be bogus:
(define lookup-in-prefix assq-ribcage)


;;; ****************************************************************

;;; global-prefix

;;; lookup-global-type returns type-scheme, else #f.
;;; use of putprop and getprop is not RRRS, but is chez-scheme specific.

;;; the following two are bogus if we use property lists:

(define global-prefix empty-ribcage)	
(define initialize-global-prefix!
  (lambda () (set! global-prefix empty-ribcage)))

(define lookup-global-type
  (lambda (var) (getprop var 'global-type)))

(define change-global-prefix!
  (lambda (var type-scheme)
    (putprop var 'global-type type-scheme)))

;;; ****************************************************************

;;; Checker-result

;;; checker-result ::= (type type-env)

;;; may need to return (type generic-vbles type-env) to accomodate LET
;;; properly?? 

(define make-checker-result
  (lambda (type type-env) (list type type-env)))

(define checker-result->type  car)
(define checker-result->env   cadr)

;;; ****************************************************************

;;; Source terms (expressions, forms, etc.)

(define make-application
  (lambda (fn-exp arg-exps) (cons fn-exp arg-exps)))
