;;; -*-Scheme-*-
;;;
;;; Kernel typechecker algorithm
;;;

;;; 30 Oct 88 -- identified major data structures and commented code
;;; to be changed. mw, with help from margmon

;;; Revision 1.9  85/02/14  12:23:58  mw

;;; Revision 1.7  83/09/05  15:10:53  mw
;;; revised to work without compat file
;;; 
;;; Revision 1.6  83/08/26  14:48:49  mw
;;;
;;; Revision 1.1  83/08/18  10:35:38  mw
;;; Initial revision

;;; CSchemeism:

;(declare (usual-integrations))

;;; ****************************************************************

;;; Setup for calling checker

;;; checker:  
;;; takes arguments:

;;; p -- prefix associating types with variables (type hypotheses)  
;;; form -- the form to be checked
;;; env -- type environment (typevars -> types)
;;; fail -- what to do if you fail (a continuation)

;;; checker calls checker-body inside a timing device.  This should be
;;; replaced with something standardized.

(define checker 
  (lambda (p form env fail)
    (let* ((start-time (ptime))
	   (res (checker-body p form env fail))
	   (end (ptime)))
      (set! checker-time 
	    (+ checker-time 
	       (- (- (car end) (car start-time))
		  (- (cadr end) (cadr start-time)))))
      res)))

;;; checker-body
;;; takes arguments:

;;; p -- prefix associating types with variables (type hypotheses)  
;;; form -- the form to be checked
;;; env -- type environment (typevars -> types)
;;; fail -- continuation to be invoked on failure.  Expects an error message.

;;; returns:
;;; checker-result ::= (type type-env)

;;; may need to return (type generic-vbles type-env) to accomodate LET properly??

(define checker-body
  (lambda (p form env fail)
    (let ((unify
	    (lambda (t1 t2 form)
	      ;; destructively update env
	      (set! env 
		(mgu t1 t2 env (lambda (env) env)
		  (lambda (failmsg)
		    (fail `((type-error ,form)
			    (bad-types:
			      ,(expand-type-exp t1 env)
			      ,(expand-type-exp t2 env))
			    ,failmsg))))))))
      (let ((ans
	      (letrec ((loop
			 (lambda (p form)
			   (if *trace-loop?*
			     (printf "checker loop: ~s~%" form))
			   (cond ((number? form)  'int)
			     ((string? form)  'string)
			     ((null? form) (lookup-symbol-type 'nil p fail))
			     ((symbol? form) (lookup-symbol-type form p fail))
			     ((eq? (car form) 'lambda)
					;(lambda vars forms ...)
			      (let* ((beta*
				       (mapcar
					 (lambda (x)
					   (make-type-scheme
					     '()
					     (gen-type-var)))
					 (cadr form)))
				     (rho (loop (ext-prefix (cadr form) 
						  beta*
						  p)
						(cons 'begin (cddr form)))))
				(make-functional-type
				  (map type-scheme->type beta*)
				  rho)))
			     ((memq (car form) '(fix rec))
					;(fix v form1)
			      (let* ((beta (make-type-scheme '()
					     (gen-type-var)))
				     (rho (loop (ext-prefix (list (cadr form))
						  (list beta)
						  p)
						(caddr form)))
				     (beta (type-scheme->type beta)))
				(unify beta rho form)
				beta))
			     ((and
				(eq? (car form) 'quote)
				(symbol? (cadr form)))
			      'symbol)
			     ((eq? (car form) 'quote)
			      (fail `(quote applied to non-symbol: ,form)))
			     ((eq? (car form) 'unchecked)  '(unchecked))
			     ((eq? (car form) 'list)
			      ;; no way to specify "many arguments,
			      ;; all of the same type", so have to
			      ;; simulate the macro-expansion.
			      (if (null? (cdr form))
				(loop p 'nil)
				(loop p `(cons ,(cadr form)
					       (list ,@(cddr form))))))
			     ((eq? (car form) 'begin)
			      (if (null? (cddr form))
				(loop p (cadr form))
				(car 
				  (last-pair
				    (mapcar (lambda (exp) (loop p exp))
				      (cdr form))))))
			     ((and (symbol? (car form))
				   (syntactic-extension? (car form))
				   ;; patch for Chez expand-once macros:
				   (not (memq (car form) '(if set!))))
			      (loop p (expand-once form)))
			     (else	;must be an application
			       (let ((beta (gen-type-var))
				     (rho (loop p (car form)))
				     (sigma* ; type the arguments
				       (mapcar (lambda (form1) (loop p form1))
					 (cdr form))))
				 (unify rho
					(make-functional-type sigma* beta)
					form)
				 beta))))))
		(loop p form))))
	(list ans env)))))
		
(define *trace-loop?* #f)

;;; ****************************************************************

;;; check0 -- take a form and pretty-print its type.

(define check0
  (lambda (form)
    (pretty-print (checker empty-prefix form empty-type-env report-error))))

;;; check1 -- like check0, but cleverer about printing the answers:
;;; it expands the type abbrevs in its answer.  

(define check1 
  (lambda (form) 
    (let ((ans (checker empty-prefix form empty-type-env report-error)))
      (pretty-print
	(expand-type-exp
	  (checker-result->type ans)
	  (checker-result->env ans))))))


;;; expand-type-exp:
;;; takes: type-expression and type-env.  Returns a list structure
;;; with bound type variables replaced by their values, checks for
;;; looping types and does something appropriate.  The resulting list
;;; structure should give a nice printable form of the type.

;;; It really does not do a very good job on looping types.

;;; This will probably be rewritten when we get to congruence rep,
;;; since we can then be awhole lot cleverer about recognizing
;;; abbreviations. 

(define expand-type-exp
  (lambda (exp env)
    (letrec ((loop
	      (lambda (exp seen)
		(if (symbol? exp)
		    (cond ((memq exp seen)
			   (list 'loop: (lookup-typevar exp env)))
			  ((is-locally-bound? exp env)
			   (loop (lookup-typevar exp env) (cons exp seen)))
			  (else  exp))
		    (cons (car exp)
			  (letrec ((inner
				    (lambda (l)
				      (cond ((null? l)  nil)
					    ((symbol? l)  (loop l seen))
					    (else
					     (cons (loop (car l) seen)
						   (inner (cdr l))))))))
			    (inner (cdr exp))))))))
      (loop exp nil))))


