;;;; "ppfile.scm".  Pretty print a Scheme file.

(require 'pretty-print)

(define (pprint-filter-file inport filter outport)
  ((lambda (fun)
     (if (input-port? inport)
	 (fun inport)
	 (call-with-input-file inport fun)))
   (lambda (port)
     ((lambda (fun)
	(if (output-port? outport)
	    (fun outport)
	    (call-with-output-file outport fun)))
      (lambda (export)
	(let ((old-load-pathname *load-pathname*))
	  (set! *load-pathname* inport)
	  (letrec ((lp (lambda (c)
			 (cond ((eof-object? c))
			       ((char-whitespace? c)
				(display (read-char port) export)
				(lp (peek-char port)))
			       ((char=? #\; c)
				(cmt c))
			       (else (sx)))))
		   (cmt (lambda (c)
			  (cond ((eof-object? c))
				((char=? #\newline c)
				 (display (read-char port) export)
				 (lp (peek-char port)))
				(else
				 (display (read-char port) export)
				 (cmt (peek-char port))))))
		   (sx (lambda ()
			 (let ((o (read port)))
			   (cond ((eof-object? o))
				 (else
				  (pretty-print (filter o) export)
				  ;; pretty-print seems to have extra newline
				  (let ((c (peek-char port)))
				    (cond ((eqv? #\newline c)
					   (read-char port)
					   (set! c (peek-char port))))
				    (lp c))))))))
	    (lp (peek-char port)))
	  (set! *load-pathname* old-load-pathname)))))))

(define (pprint-file ifile . optarg)
  (pprint-filter-file ifile
		      (lambda (x) x)
		      (if (null? optarg) (current-output-port) (car optarg))))
