(define *stack-trace?* #f)

(define (vm-trace) (set! *stack-trace?* #t) (set! *trace?* #t))
(define (vm-untrace) (set! *stack-trace?* #f) (set! *trace?* #f))

(define-opcode 'call
  (lambda ()
    (display-stack)
    (let ((nargs (next-instruction-integer)))
;      (assert (= (+ (fetch *sp*) nargs)
;                 (address-of-length-cell (fetch *cont*)))
;              'call)
      (start-call (fetch *val*) nargs))))

(define display-stack
  (lambda ()
    (newline)
    (newline)
    (display "Stack")
    (newline)
    (display "-----")
    (newline)
    (let ((end (area-end *stack-area*)))
      (do ((sp (fetch *sp*) (+ sp 1)))
	  ((= sp end) (display 'BOTTOM-OF-STACK))
	(newline)
	(display-descriptor (vector-ref *memory* sp))))))

(define display-descriptor
  (lambda (desc)
    (display-tag desc)
    (display ": ")
    (display-data desc)))

(define display-tag
  (lambda (desc)
    (display (table-lookup (descriptor-tag desc) 
			   tag-table 
			   (lambda () (error "unrecognized-tag"))))))

(define display-data
  (lambda (desc)
    (if (miscellaneous? desc)
	(display-miscellaneous (descriptor-data desc))
	(display (descriptor-data desc)))))

(define display-miscellaneous
  (lambda (data)
    (display (table-lookup data
			   misc-table
			   (lambda () (error "Unknown MISC value"))))))


(define miscellaneous?
  (lambda (desc)
    (eq? (table-lookup (descriptor-tag desc) 
		       tag-table 
		       (lambda () (error "Unknown tag")))
	 'MISC)))

(define table-lookup
  (lambda (key table error-thunk)
    (let ((probe (assoc key table)))
      (if probe
	  (cdr probe)
	  (error-thunk)))))

(define misc-table
  '((0 . FALSE)
    (1 . TRUE)
    (2 . EMPTY-LIST)
    (3 . UNSPECIFIED)
    (4 . UNDEFINED)))

(define tag-table
  '((0 . INT)
    (1 . MISC)
    (2 . RESERVED)
    (3 . PAIR) 
    (4 . VECTOR)
    (5 . SYMBOL)
    (6 . PROCEDURE)
    (7 . REF)))
	  
