;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;               This is the file PLSCHEME.SCM                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Should wrpa this up in a way that it's easier
;;; to extend; i.e. should make it easier to add
;;; new opcodes - Lyn 

; Code common to VM and compiler

; The instruction set

(define special-opcodes
  '(check-nargs
    make-environment
    load-constant
    load-variable
    set-variable
    make-procedure
    push
    call
    make-continuation ;for non-tail-calls
    return
    leave-environment
    jump-if-false
    jump))

(define primitive-opcodes ;open-codeable procedures
  '((eq?             2)
    (integer?        1)
    (+               2)
    (-               2)
    (*               2)
    (=               2)
    (<               2)
    (quotient        2)
    (remainder       2)
    (pair?           1)
    (cons            2)
    (car             1)
    (cdr             1)
    (set-car!        2)
    (set-cdr!        2)
    (ref?            1)
    (ref             1)
    (get             1)
    (put!            2)
    (vector?         1)
    (make-vector     2)
    (vector-length   1)
    (vector-ref      2)
    (vector-set!     3)
    (read            0)
    (write           1)
    (display         1)
    (newline         0)))

(define opcodes-vector
  (list->vector (append special-opcodes (map car primitive-opcodes))))

(define number-of-opcodes
  (vector-length opcodes-vector))

(define (opcode-name opcode)
  (vector-ref opcodes-vector opcode))

(define (opcode name)
  (let loop ((opcode 0))
    (cond ((>= opcode number-of-opcodes) (error "no such opcode" name))
          ((eq? name (opcode-name opcode)) opcode)
          (else (loop (+ opcode 1))))))

; The following kludge is necessary to enforce the #f/() distinction
; in the VM even if the distinction isn't enforced in the Scheme in
; which the VM runs.  An analogous paranoia about #t and a standard
; unspecified value is humored.

(define (mistakable? x)                        ;Don't pay any attention to this
  (or (null? x) (symbol? x) (number? x) (pair? x) (string? x) (char? x)
      (vector? x) (procedure? x)))

(define upper-case? (char=? (string-ref (symbol->string 'a) 0) #\A))

(define false       (if (mistakable? #f)
                        (string->symbol (if upper-case? "#F" "#f"))
                        #f))
(define true        (if (mistakable? #t)
                        (string->symbol (if upper-case? "#T" "#t"))
                        #t))
(define unspecified (let ((u (set-car! (cons 1 2) 3)))
                      (if (mistakable? u)
                          (string->symbol (if upper-case?
                                              "#<UNSPECIFIED>"
                                              "#<unspecified>"))
                          u)))
