;;; N queeens problem

(define (queens n)
  (let ((indices
	 (let loop ((x 0))
	   (if (< x n)
	       (cons x (loop (1+ x)))
	       '())))
	(enumerate!
	 (lambda (indices receiver)
	   (let x-loop ((x indices))
	     (if (not (null? x))
		 (begin
		   (for-each (lambda (y)
			       (receiver (car x) y))
			     (cdr x))
		   (x-loop (cdr x)))))))
	(make-inequality
	 (lambda (x y)
	   (let ((e (make-constraint equality)))
	     (== (constraint/cell e 'p) (make-constant 0))
	     (== (constraint/cell e 'a) x)
	     (== (constraint/cell e 'b) y))))
	(make-subtractor
	 (lambda (x y)
	   (let ((a (make-constraint adder)))
	     (== (constraint/cell a 'sum) x)
	     (== (constraint/cell a 'a) y)
	     (constraint/cell a 'b)))))
    (let ((queens
	   (map (lambda (index)
		  (make-variable
		   (intern (string-append "q" (number->string index)))))
		indices)))
      (for-each (lambda (queen)
		  (== queen (make-oneof indices)))
		queens)
      (enumerate!
       indices
       (lambda (x y)
	 (let ((qx (list-ref queens x))
	       (qy (list-ref queens y)))
	   (make-inequality qx qy)
	   (let ((b (make-subtractor qx qy)))
	     (make-inequality b (make-constant (- y x)))
	     (make-inequality b (make-constant (- x y)))))))
      queens)))