;;; $Id: book.sc,v 1.10 1994/09/02 15:02:44 queinnec Exp $

;;;(((((((((((((((((((((((((((((((( L i S P ))))))))))))))))))))))))))))))))
;;; This file is part of the files that accompany the book:
;;;     LISP Implantation Semantique Programmation (InterEditions, France)
;;; By Christian Queinnec <Christian.Queinnec@INRIA.fr>
;;; Newest version may be retrieved from:
;;;   (IP 128.93.2.54) ftp.inria.fr:INRIA/Projects/icsla/Books/LiSP*.tar.gz
;;; Check the README file before using this file.
;;;(((((((((((((((((((((((((((((((( L i S P ))))))))))))))))))))))))))))))))

;;; This file defines an interpreter containing all that is needed to
;;; interpret the programs of C. Queinnec's book. This file is to be
;;; compiled by Scheme->C. It contains Meroonet, the syntax-case package
;;; of Hieb and Dybvig, and the tester utility to run test suites.

(module book (main start))

;;; This variable is used in chap8k.scm to determine the underlying
;;; Scheme interpreter.

(define book-interpreter-support 'scheme2c)

;;; Define macros for compiling the syntax-case package.  

;;; expand.ss is transformed (from ../../bigloo/others/expand.bb) into
;;; expand.sc so that it uses s2c-if instead.
;;; macro-defs.sc is similarly transformed.

(define-macro define-internal-macro
  (lambda (e m)
    (let* ((call (cadr e))
           (body (cddr e))
           (s2c-expander
            `(lambda (e m)
               (m (apply (lambda ,(cdr call) . ,body) (cdr e))
		   m ) ) )
           (e `(define-macro ,(car call) ,s2c-expander)) )
      ;; No need to make them pervasive, they're just local:
      ;; (m `(begin (eval ',e) ,e) m)
      (m e m) ) ) )

;;; syntax-case uses gensym (and mainly hooks.sc).

(define gensym
  (let ((counter 99))
    (lambda args
      (set! counter (+ counter 1))
      (string->symbol
       (string-append
        (if (pair? args) (car args) "G")
        (number->string counter) ) ) ) ) )

;;; This function may be generated by syntax-case.scm

(define (list* . args)
  (if (pair? args)
      (if (pair? (cdr args))
          (cons (car args) (apply list* (cdr args)))
          (car args) )
      (quote ()) ) )

;;; In Scheme->C, () and #f are different but both false.  If in
;;; Scheme2c recognizes () as false and syntax-case expects it to be
;;; true. So introduce s2c-if with the correct behavior. And and or
;;; special forms are already expanded so don't care.

(define-internal-macro (s2c-if c . parms)
  `(if (let ((g ,c)) (or g (null? g))) . ,parms) )

;;; Then compile the syntax-case package.

(include "scheme2c/others/compat.ss")
(include "scheme2c/others/hooks.sc")
(include "scheme2c/others/output.ss")
(include "scheme2c/others/init.ss")
(include "scheme2c/others/expand.sc")
(include "scheme2c/others/macro-defs.sc")

;;;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; Define some utilities.

(define call/cc call-with-current-continuation)

(define (reverse! l)
  (define (nreverse l r)
    (if (pair? l)
       (let ((cdrl (cdr l)))
         (set-cdr! l r)
         (nreverse cdrl l) )
       r ) )
  (nreverse l '()) )

(define (every? p . args)
  (let andmap ((args args) (value #t))
    (if (let any-at-end? ((ls args))
          (and (pair? ls)
               (or (not (pair? (car ls)))
                   (any-at-end? (cdr ls)))))
        value
        (let ((value (apply p (map car args))))
          (and value (andmap (map cdr args) value))))))

(define (any? p . args)
  (let ormap ((args args) (value #f))
    (if (let any-at-end? ((ls args))
          (and (pair? ls)
               (or (not (pair? (car ls)))
                   (any-at-end? (cdr ls)))))
        value
        (let ((value (apply p (map car args))))
          (or value (ormap (map cdr args) value))))))

;;; gensym is also used in the two following macros at expansion time
;;; so define it for the expander. This is a kind of
;;; eval-at-macroexpansion-time.

(define-internal-macro (hack)
  (set! gensym
        (let ((counter 99))
          (lambda args
            (set! counter (+ counter 1))
            (string->symbol
             (string-append
              (if (pair? args) (car args) "G")
              (number->string counter)) ) ) ) )
  '#t )
(hack)

;;;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; Prepare this macro for compiling Meroonet. It will only define a
;;; Dybvig macro.

(define-internal-macro (define-meroonet-macro call . body)
  (define (meroonet-make-expander call body g x)
    `(begin
       ;; define the Dybvig expander as a regular function:
       (define ,g 
         (lambda (,x)
           ;; x receives a syntax-object and not a form
           (define (strip x) (vector-ref x 1))
           ;; Don't check arity, apply directly
           (apply (lambda ,(cdr call) . ,body) 
                  (cdr (strip ,x)) ) ) )
       ;; register the Dybvig macro at load-time:
       (expand-syntax
        '(define-syntax ,(car call) ,g) ) ) )
  (meroonet-make-expander call body (gensym) (gensym)) )

(include "meroonet/meroonet.scm")

;;;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; The define-abbreviation macro is used throughout the book and
;;; should be present in the generated interpreter.

;;; This code is compiled with Scheme->C so it is expanded by Scheme->C's
;;; expand which knows the define-meroonet-macro which was defined
;;; just before. It will generate a Dybvig-macro named
;;; define-abbreviation whose aim is to be a Dybvig-macro
;;; definer. That's why define-meroonet-macro and define-abbreviation
;;; use the same expander (except that macros defined by
;;; define-meroonet-macro call a compiled expander whereas macros
;;; defined by define-abbreviation are interpreted since they are
;;; defined on the fly).

(define-meroonet-macro (define-abbreviation call . body)
  (define (meroonet-make-expander call body g x)
    `(begin
       ;; define the Dybvig expander as a regular function:
       (define ,g 
         (lambda (,x)
           ;; x receives a syntax-object and not a form
           (define (strip x) (vector-ref x 1))
           ;; Don't check arity, apply directly
           (apply (lambda ,(cdr call) . ,body) 
                  (cdr (strip ,x)) ) ) )
       ;; register the Dybvig macro at load-time:
       (expand-syntax
        '(define-syntax ,(car call) ,g) ) ) )
  (meroonet-make-expander call body (gensym) (gensym)) )

;;; The when and unless macros are no longer needed by Meroonet, I
;;; removed them (version 1.14). But many of my tests assume they are
;;; there. To define them hygienically with syntax-case and since
;;; syntax-case is not available at that time, they are left interpreted.

(eval 
 (expand-syntax
  '(begin
     (define-syntax unless
       (syntax-rules ()
         ((unless condition form ...)
          (if (not condition) (begin form ...)) ) ) )
     (define-syntax when
       (syntax-rules ()
         ((when condition form ...)
          (if condition (begin form ...)) ) ) ) ) ) )

;;; This is the simplest file to include.

(include "src/tester.scm")

;;;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; Defines specific error handlers for meroonet.scm and tester.scm

(define meroonet-error 'wait)

(define tester-error 'wait)

;;; This function will test meroonet on its test suite. It will also test
;;; the port of syntax-case.

(define (test file)
  (suite-test
   file "?? " "== " #t
   (lambda (read check err)
     (set! meroonet-error err)
     (set! tester-error    err)
     (lambda ()
       (let ((r (catch-error (lambda () 
                               (check (eval (expand-syntax (read)))) ))))
         (if (pair? r) (car r) (err 'internal-error r)) ) ) )
   equal? ) )

;;; This variable is needed by meroonet/oo-tests.scm test suite.

(define the-Point 'useful4tests)
;;; My tests suppose that the atom? function is present

(define (atom? x) (not (pair? x)))

;;; I also like the iota function. (iota 0 4) -> (0 1 2 3)

(define (iota start end)
  (if (< start end)
      (cons start (iota (+ 1 start) end))
      '() ) )

(define (symbol-append . args)
  (string->symbol
   (apply string-append
          (map (lambda (s)
                 (cond ((string? s) s)
                       ((symbol? s) (symbol->string s))
                       ((number? s) (number->string s))
                       (else (error 'symbol-append args)) ) )
               args ) ) ) )

;;; putprop and getprop are already there.

;;; Quick and dirty: sometimes very big objects are printed, limit
;;; them to something affordable.

(define *bounded-length* 4)
(define *bounded-depth* 3)

(define (bounded-display o stream)
  (define (print-list o* len dep)
    (cond ((null? o*) #t)
          ((atom? o*) (display " . " stream)
                      (display o* stream) )
          ((pair? o*) 
           (print (car o*) len (+ dep 1))
           (if (pair? (cdr o*)) (display " " stream))
           (print-list (cdr o*) (+ len 1) dep) ) ) )
  (define (print o len dep)
    (cond ((object? o) 
           (display "#<" stream)
           (display (Class-name (object->class o)) stream)
           (display ">" stream) )
          ((atom? o) (display o stream))
           (else (if (or (> len *bounded-length*)
                         (> dep *bounded-depth*) )
                     (display "&&&" stream)
                     (begin
                       (display "(" stream)
                       (print-list o len dep)
                       (display ")" stream) ) ) ) ) )
  (print o 0 0) )
;;; Test: (bounded-display (call-with-input-file "si/reflisp.scm" read) stdout-port)

;;; It is not necessary for tests but sometimes I measure durations
;;; with this function similar to CommonLisp:
(define-c-external (time pointer) longint "time")

(define (get-internal-run-time)
  (let ((t (make-string 4)))
    (time t)
    (c-unsigned-ref t 0) ) )
(define internal-time-units-per-second 1)

;;; They also suppose some variables to be predefined such as wrong.

(define wrong 'wait)
(define static-wrong 'wait)

;;;ooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
;;; A small toplevel loop that uses the syntax-case package of Hieb
;;; and Dybvig (define-syntax is used throughout the book).

(define (syntax-case-load file)
  (call-with-input-file file
    (lambda (in)
      (newline)
      (display ";;; Loading ")
      (display file)
      (newline)
      (let loop ((e (read in)))
        (if (eof-object? e) 
            file
            (let ((r (eval (expand-syntax e))))
              (display ";= ")
              (display r)
              (newline)
              (loop (read in)) ) ) ) ) ) )

(define (start options)
  (display "[C. Queinnec's book] Scheme->C+Meroonet+syntax-case...")
  (newline)
  ;; This is a hack to redefine load without hurting the compiler:
  (eval '(set! load syntax-case-load))
  (interpreter
   "? " "= " #t
   (lambda (read print err)
     (set! tester-error   err)
     (set! meroonet-error err)
     (lambda ()
       (let ((r (catch-error 
                 (lambda () (print (eval (expand-syntax (read))))) )))
         (if (pair? r) (car r) (err 'internal-error r)) ) ) ) )
  (display " Ite LiSP est.")
  (newline) )

;;; That generic function is predefined in Meroon not in Meroonet.
;;; The problem is to define a generic function with Meroonet macros
;;; while these macros are only compiled and not yet present.

(eval (expand-syntax
       '(begin
          (define-generic (show (o) . stream)
            (let ((stream (if (pair? stream) (car stream)
                              (current-output-port) )))
              (bounded-display o stream) ) )
          (define-generic (clone (o))
            (list->vector (vector->list o)) ) ) ))

;;; end of book.sc
