
/************************************************************************/
/*									*/
/* This file contains the constant declarations, macro definitions and  */
/* Global type declarations						*/
/*									*/
/************************************************************************/

#include <stdio.h>
#include "host.h"
#include "cksys.h"

typedef LONG VECTOR;		/* The type of word used in Bit-Vectors */

#define LONGLENGTH 32    /* Number of bits in a LONG -- used for bit-vectors */
#define WSHIFT 5         /* Log (base 2) LONGLENGTH */
#define WMASK 31         /* LONGLENGTH - 1 */
#define MaxNodes 32      /* Maximum number of nodes in a clause */
#define MaxJoin 2        /* Maximum number of arcs preceding a join node */
                         /* Simpler algorithm used when MaxJoin <= 2 */

/* Maximum number of tuples backpointers stored by a node */
#define MaxTP (MaxNodes / 2)


#define SLOT_TAG_SIZE 5
#define ARITY_SIZE    5
#define REF_CNT_SIZE  6
#define MAX_REF_COUNT 63
#define FUNCTOR_SHIFT 11	/* SLOT_TAG_SIZE + REF_CNT_SIZE  */
#define SYM_TAB_SHIFT 16 	/* SLOT_TAG_SIZE + REF_CNT_SIZE + ARITY_SIZE */

#define ABSOLUTE_ADDRESS 	0
#define MOLECULE	 	1
#define FUNCTOR		 	2
#define TUPLE_INDEX_1	 	3
#define TUPLE_INDEX_2	 	6
#define RELATIVE_INDEX	 	7
#define TERM_SPC_INDEX_1 	10
#define TERM_SPC_INDEX_2	11
#define INTEGER		 	14
#define REAL			15
#define UNBOUND_VAR		18
#define BLOCKED_VAR		19
#define TUPLE_SIZE		22
#define CLOSED_TERM		23
#define FREE_SLOT		26


/* the slot size is 32 bits. The least significant 5 bits will be used for the
   tag. Access procedures will be provided to insert/extract objects */

typedef struct 
	{
	SHORT CanImport;
	SHORT CanExport;
	}	CLAUSE_VAR_TYPE;

typedef LONG SLOT;

#if (MaxJoin <= 2)
typedef struct
	{
            SHORT Pbptr_idx;       /* Position of primary common ancestor
					backpointer in tuple pointers array */
            BYTE fptr_other;        /* Index into common ancestor's forward 
					pointer relation for join-arc tuple */
	    BYTE fptr_me;        /* Similar index for this-arc tuple */
            SHORT MCA_num;         /* Number of elements in MCA_idx */
	    LONG *MCA_me;        /* Positions of multiple CAs in tuple
 					pointer array */
	    LONG *MCA_other;
	    SHORT arclinkindex;    /* index used by a join tuple to maintain
				      chain of relevant tuples - Ram 8/5/89 */
	} FWDBACK;
#else
typedef struct
	{
	    SHORT numjoins;
	    SHORT joins_with[MaxJoin];
            SHORT Pbptr_idx[MaxJoin]; 
            SHORT fptr_other[MaxJoin];
	    SHORT fptr_me[MaxJoin];
            SHORT MCA_num[MaxJoin];
	    SHORT *MCA_me[MaxJoin];
	    SHORT *MCA_other[MaxJoin];
	} FWDBACK;
#endif

typedef struct
	{
	    SHORT nodecode[MaxTP];
	    SHORT index[MaxTP];
	    BYTE count;
	    BYTE linkindices;    /* number of link indices needed by node
				     tuples at this node - Ram 8/5/89 */
	} EXTEND;
 
/* A clause is limited to 32 literals because of the bit-vectors */

#include "state.h"	/* necessary for STATETBL def */
typedef struct CLAUSE
	{
	    struct CLAUSE *next; /* The next clause in the procedure */
	    LONG *FreeBlock;     /* Bit-Vector allocation block */
	    SHORT BlockSize;     /* Length of FreeBlock */
	    SHORT top;   	 /* Index into FreeBlock */
	    SHORT clause_det;	 /* the clause determinacy flag */
	    SLOT *PreUnify;	 /* Points to parse tree for pre-unification */
	    SHORT  num_nodes;	 /* need a short but conforming to multiples
				       of word length for the data structure */
	    SHORT sequential;	 /* TRUE if Clause is sequential */
	    SHORT num_arcs, 
	    	  num_vars;
	    SHORT query_size;	  /* the size of a query using this clause. */
	    SLOT  **lit_position; /* it_position[K] points to beginning 
				       of K'th literal in pure_code_frag.  */
	    SHORT *builtin_index; /* builtin_index[K] gives the index of
				       builtin along edge K. 0 if not builtin */
	    STATETBL **states;	  /* states[K] is the state of the variables
				       at node K.  See state.h */
	    SHORT *succ_node;	  /* succ_node[K] is node that follows  
				       K'th literal. 			   */
	    SHORT *pred_node;	  /* pred_node[K] is node that preceeds  
				       K'th literal. 			   */
	
	    VECTOR *succ_arcs;    /* succ_arcs[K] is the set of arcs that  
				       follow node K, stored as bit-vector */
	    SHORT *succ_count;	  /* succ_count[K] is the count of arcs
				       that follow node K. */
	    VECTOR *pred_arcs;	  /* pred_arcs[K] is the set of arcs that  
				       precede node K, stored as bit-vector */
	    SHORT *pred_count;	  /* pred_count[K] is the count of arcs
				       that precede node K. */
	    SHORT *shared_tuple;  /* shared_tuple[K] is a bit which tells
				       whether a tuple here may be shared. */
	    FWDBACK *ArcIndices;
            EXTEND *NodeIndices;
	    SHORT  maxlinks;      /* the max number of links needed by
				     join tuples in the clause          */
	    SHORT MaxEmbVars;	  /* Maximum number of embedded variables
					in a clause */
	    CLAUSE_VAR_TYPE *var_info; /* var_info[K] (k>=1) tells whether 
					$K can import or export embedded 
					variables */
	    SHORT *fwd_ptr;	  /* fwd_ptr[K] is number of forward
 					pointers which each node tuple
					must hold. */
	    VECTOR *lit_det;   /* Kth bit set means Kth goal deterministic */
	    VECTOR *lit_cannot_fail;   /* Kth bit set - goal K can't fail */
	    LONG   *node_distance;	/* node_distance[K] is the distance of
					   node K from the last node when
					   topologically sorted */
	    SHORT  numSeqLitBits;	/* number of log N bits needed
					   for literals of the clause */
	    SHORT  clauseNum;		/* the number of the clause */
	    SHORT  numClauseBits;	/* number of log N bits needed for
					   clauses with identical
					   names excluding facts */
	} CLAUSE;


/*
 *  CLAUSE_CHAIN is the structure used to represent the list of clauses.
 */

typedef struct CLAUSE_CHAIN {
	struct CLAUSE_CHAIN *next;
	CLAUSE *clause;
} CLAUSE_CHAIN;



typedef struct 
	{
	    SLOT *terms;
	    SLOT *tuple;
	    SHORT builtin_index;
	} GOAL;

typedef SLOT *RESPONSE;


typedef union
	{
	    GOAL *goal;
	    RESPONSE *response;
	} GOAL_OR_RESP;


typedef struct 
	{
	    SLOT ref_count;   /* wasted space */
	    SLOT *terms;
	    SLOT *tuple;
	} MOLECULE_PTR;



/*									    */
/* Message type definition:						    */
/*	To get major type of message, use	macro MSGTYPE(x)	    */
/* 	Only 6 bits are used to define the MSGTYPE (inc subtypes	    */
/*									    */
#define MSGTYPE_NULL	0		/* dummy type, used when init	    */
#define MSGTYPE_GOAL	MSGTYPE_NULL+1	/* goal message			    */
#define MSGTYPE_RESP	MSGTYPE_GOAL+1	/* response message		    */
#define MSGTYPE_ROUT	MSGTYPE_RESP+1	/* routing message		    */
#define MSGTYPE_CNTL	MSGTYPE_ROUT+1	/* control message		    */
#define MSGTYPE_CTRA	MSGTYPE_CNTL+1	/* contract message		    */
/*									    */
/* Message subtype definition 						    */
/*									    */
#define MSGTYPE_RESPRNUM	(MSGTYPE_RESP | 0x08)
					/* DONE, to indicate end of resp    */
#define MSGTYPE_RESPCNUM	(MSGTYPE_RESP | 0x10)
					/* report num of active clauses	    */
#define MSGTYPE_RESPDATA	(MSGTYPE_RESP | 0x20)
					/* data sent as a response 	    */
/* MACROS will be used to access  these fields */


/* Message data structure definition 					    */
/*									    */
typedef struct 
{
    SHORT 	 msgType;	/* only 4 bits used - rest free     	    */
				/* PART touched by system only:		    */
    ChareIDType	 srcPeNum;	/* processor ID the resp should go	    */
    LONG 	 srcTaskNum;	/* task ID the resp should go 		    */
    LONG 	 srcOsBlock;	/* contains os-dependent info		    */
				/* PART controled by usr program:	    */
    LONG	 goalSlot;      /* it is pointer to goal slot       	    */
    GOAL_OR_RESP goalResp;	/* ptr to Goal or Resp for long message     */
    SHORT	 rNum;          /* count value for responses 		    */
    SHORT  	 cNum; 		/* count value for clauses		    */
    PVECTOR	 *priority_vector; /* ptr to 32bit unsigned int as priority */
} MESSAGE;		

typedef struct str_taskbk {
    BOOLEAN	tskLock;
    LONG	tskWait;
    SHORT	tskRefNum;
} TASKBK;



