/* File Static.c
 * 
 * Static Analysis Phase 
 *  (right now it is common ancestor only )
 */

#include "typedefs.h"
#include "pgm_typedefs.h"
#include "macros.c"
#include "static_macros.c"

extern Procedure procedures[MaxProcs];
extern Procedure *procs;
extern SHORT VLEN_N, VLEN_A, VLEN_V;

StaticAnalysis()
   {
   Procedure *p;
   CLAUSE *c;

   WordLengthCheck();

  /* Traverse the database.  Perform common ancestor analysis on
   *   each clause.
   */
   for (p=procedures; p<procs; p++)
      {
      for (c=p->clauses; c!=NULL; c=c->next)
         {
      /* Skip over facts */
         if (PgmIsFact(c))
            {
            continue;
            }

         SetVectorLengths(c);

      /* Allocate space for in clause for static analysis results */
         ClauseAllocStatSpace(c);

      /* Perform Common Ancestor Analysis */
         Common_Ancestor_Info(c);  
         }
      }

  /* Determinacy Analysis */
   Determinacy_Analysis();
   }

/* SetVectorLengths()
 *
 * Set the lengths (in number of bits) of the vectors for this clause.
 */

SetVectorLengths(c)
CLAUSE *c;
   {
   /* Lengths of Vectors -- Must be set before trying to allocate vectors */
   VLEN_N = c->num_nodes;
   VLEN_A = c->num_arcs;
   VLEN_V = c->num_vars;
   }

/* WordLengthCheck()
 *
 * LONGLENGTH is assumed to be a power of 2.
 * If it is not, shifting left or right by WSHIFT must be replaced
 * by multiplying or dividing by LONGLENGTH.
 */

WordLengthCheck()
   {
   SHORT i;

   i=0;
   while((1<<i)<LONGLENGTH) i++;
   if (1<<i != LONGLENGTH)
      {
      fprintf(stderr,"LONGLENGTH ERROR -- must be a power of 2\n");
      exit(1);
      }
   }

/* ClauseAllocStatSpace()
 *
 * Allocate clause data structures for static analysis
 */

ClauseAllocStatSpace(c)
CLAUSE *c;
   {
   if(c->num_arcs > 0)
      {
      Malloc_FwdBack(c->ArcIndices,c->num_arcs);
      Malloc_Extend(c->NodeIndices,c->num_nodes);
      }
   if(c->num_nodes > 0)
      {
      palloc(SHORT,c->num_nodes,c->fwd_ptr);
      }
   }
