
#include "typedefs.h"
#include "pgm_typedefs.h"
#include "pgm.h"
#include "macros.c"
#include "pgm_macros.c"
#include "be_macros.c"
#include "cg.h"
#include "instruct.h"
#include <varargs.h>
#include "bit_macros.c"

CLAUSE *firstClause();


EmitSeqBody( c, ismain, nextEntry )
CLAUSE *c;
BOOLEAN ismain;
LONG nextEntry;
{
    SHORT lit, succNode;
    CLAUSE *tempc;
    SHORT predcount;  
    SHORT temp;
    extern SHORT MAXLINKSINPROGRAM;

    TRACE(OsPrint("EmitBody: %d arcs\n", c->num_arcs));
    if (c->num_arcs == 0) 
    {
	Emit( Return, "d", MAXLINKSINPROGRAM);
	return;
    }
    for( lit=1; lit <= c->num_arcs; lit++ ) 
    {
	/*==	define entry point for this arc =====*/
	SetLabel( c, lit);
	succNode = c->succ_node[ ARC(lit) ];
	predcount = c->pred_count[ succNode ];
	if (c->builtin_index[lit] == 0)
	{
	    temp = GET_FUNCTOR( ((SLOT *)(c->lit_position[lit])) );
	    tempc = procedures[temp].clauses;
	    if (tempc == NULL) 
	    {
		OsPrint("clause definition not found - aborting compilation!\n");
		exit(1);
	    }
	    while( tempc->next != NULL ) tempc = tempc->next;
	    Emit( Call, "pl", c->lit_position[lit], tempc, SEQHEAD);
	}
	else GenBuiltinCode(c, c->lit_position[lit],  nextEntry,
			    c->builtin_index[lit]);
    }
    Emit( Return, "d", MAXLINKSINPROGRAM );
}











