
/*
 *  The following define the table sizes for the parser. 
 */

#define NmHashVal 47		/* Name hash value */
#define MaxPrNames 65536    /* Maximum number of characters in atom names */
#define MaxNames 768		/* Maximum number of atom and variable names */
#define MaxVarTbl 256		/* Maximum number of variables */
#define MaxTokens 2048		/* Maximum number of tokens in a term */
#define MaxProcs 512		/* Maximum number of atoms */
#define MaxLits  64		/* Maximum number of literals in a clause */
#define MaxArcs 64
/* MaxNodes is defined in typedefs.h */

/*
 * The type CALLSUCC is used to represent call and success patterns
 * for a procedure.  CALSUCPR is a single call and success type.
 */

typedef struct CALSUCPR {
  SHORT		call,
  		succ;
} CALSUCPR;

typedef struct CALLSUCC {
  CALSUCPR		*patterns;
  struct CALLSUCC	*next;
} CALLSUCC;

/*
 *  The type Procedure is used to represent a name (atom or function symbol).
 *  if the name is a procedure name, it contains the list of clauses
 *  defining the procedure.  If the name is an operator, then it contains
 *  the prefix, postfix, and infix priorities.
 */

typedef struct Procedure {
	struct Procedure *hash_chain; /* The chain of procedures. */
	SHORT builtin;	       	/* If nonzero, the proc is a builtin */
	SHORT flags;		/* flags defined below */
	SHORT arity;	       	/* The arity of the head literal */
	CALLSUCC *call_succ;	/* Call & Success patterns */
	CLAUSE *clauses;	/* The list of clauses for the procedure */
	char *head;	       	/* The print name of the head's functor */
	int prefix,postfix,infix;	/* The operator precedences */
	char *op_kind;			/* The type of the operator */
} Procedure;

/*
 * flags
 * The following define the flags used in the flag entry of procedure
 */
#define	VISITED		0	/* procedure is called from somewhere */
#define ENTRY		1	/* procedure is an entry point */
#define RECURSIVE	2	/* procedure may be called recursively */
#define DETERMINISTIC	3    	/* procedure is deterministic */
#define CANNOT_FAIL	4	/* procedure can't fail */
#define CLAUSES_MUT_EX	5	/* all clauses have mutually exclusive heads */
#define CLAUSES_SEQ_EX	6	/* all clauses to be executed sequentially */

typedef struct NameEntry {
	struct NameEntry *next;	  /* Pointer to the next element in bucket */
	char *name;		  /* Pointer to the print name of the object */
	SHORT offset;		  /* Offset (if the term is a variable) */
	SHORT clause;	          /* Clause number (if term is a variable) */
	SHORT prefix;  		  /* The operator precedences */
	SHORT infix;
	SHORT postfix;
	Procedure *procs;         /* The chain of procedures with this atom 
						       as predicate name. */
} NameEntry;

