#include "typedefs.h"
#include "pgm_typedefs.h"
#include "pgm.h"
#include "macros.c"
#include "pgm_macros.c"
#include "cg.h"

SLOT *relPure;    /* base address of relocated pure code */
extern char PUREFILE[];

DumpPureCode(ptr,cnt)
SLOT *ptr;
LONG cnt;
{
	FILE *fd;

	fd = fopen(PUREFILE, "w");
	if( fd == NULL ) {
		OsPrint("can't open %s for output\n", PUREFILE );
		exit(1);
	}
	relPure = (SLOT *)malloc( cnt * sizeof(SLOT) );
	if( relPure == NULL ) {
		OsPrint("DumpPureCode: memory allocation failed\n");
		exit(1);
	}
	Relocate( ptr, relPure, cnt );
	if( fwrite(relPure, sizeof(SLOT), cnt, fd ) != cnt) {
		OsPrint("unable to write pure code\n");
		exit(1);
	}
	fclose(fd);
}


Relocate( oldPure, newPure, cnt )
SLOT *oldPure, *newPure;
LONG cnt;
{
	LONG i;
	register SLOT oldSlotVal;
	SLOT newSlotVal;
	extern SLOT *term_space;

	for( i=0; i<cnt; i++ ) {
		/*=====  new slot value defaults to old slot value  =====*/
		newPure[i] = oldSlotVal = oldPure[i];
		switch( SLOT_TAG( (oldPure+i) )) {
		case ABSOLUTE_ADDRESS:
			*(newPure + i) = (SLOT)( ((LONG)oldSlotVal) - ((LONG)term_space) );
			if( SLOT_TAG( (newPure+i) ) != ABSOLUTE_ADDRESS )
				OsPrint("ABS: is no longer abs address.  sigh.\n");
			break;
		case MOLECULE:
			break;
		case FUNCTOR:
		case CLOSED_TERM:
			break;
		case TUPLE_INDEX_1:
			break;
		case TUPLE_INDEX_2:
			break;
		case RELATIVE_INDEX:
			break;
		case TERM_SPC_INDEX_1 :
			INSERT_INDEX( (newPure+i), ((SLOT *)oldSlotVal - term_space), TERM_SPC_INDEX_1 );
			OsPrint("TSI_1: from %lx to %lx\n", oldPure[i], newPure[i] );
			break;
		case TERM_SPC_INDEX_2:
			break;
		case INTEGER:
			break;
		case REAL:
			break;
		case UNBOUND_VAR:
			break;
		case BLOCKED_VAR:
			break;
		case TUPLE_SIZE:
			break;
		case FREE_SLOT:
			break;
		default:
			break;
		}
/*		if( ((LONG)newPure[i]) > 4000000 )
			OsPrint("slot tag %d\n", SLOT_TAG((newPure+i)) ); */
	}
}

