 
/***************************************************************************/
/* This is the main process that runs on each pe 			   */
/* EXPORTS: nothing                                                        */
/*									   */
/* IMPORTS: 	void OsMcDepInit();					   */
/* 		MESSAGE *OsNextWorkPiece();				   */
/*		void RopmConsume(GOAL_OR_RESP *message);		   */
/*              void BePrintGoal(GOAL_OR_RESP *goalResp);                  */
/*		void BePrintResponse(GOAL_OR_RESP *goalResp);              */
/***************************************************************************/

#include <sys/time.h>
#include <sys/resource.h>

#include "typedefs.h"
#include "macros.c"

#define PROT 511
extern SHORT simTime;
extern char OBJFILE[];
extern char PUREFILE[];

main(argc,argv)
SHORT argc;
char * argv[];
{   
    void PgmListing();
#ifdef PRIORITY
    void PgmMaxClauseBits();
#endif
    SHORT  k=1,a = TRUE;
    char   c;
    extern SHORT goalNum;
#if SHARED 
    struct rusage usage;
    int begSec,endSec;
#endif
    while (a && k < argc) {
	a = FALSE;
        if (strcmp(argv[k],"-o") == 0)
	{ 
	    strcpy(OBJFILE, argv[++k]);
	    strcat(OBJFILE, ".bc");
	    strcpy(PUREFILE, argv[k]);
	    strcat(PUREFILE, ".pure");
	    k++; a = TRUE; continue;
	}
        if (strcmp(argv[k],"-D") == 0)
      		{ DEBUG = TRUE; k++; a = TRUE; continue;}
        if (strcmp(argv[k],"-D2") == 0)
      		{ DEBUG2 = TRUE; k++; a = TRUE; continue;}
        if (strcmp(argv[k],"-T") == 0)
      		{ k++; sscanf(argv[k],"%d",&maxTerm); maxTerm *= 1000;
		  k++; a = TRUE; continue;}
    } 
    term_space = (SLOT *)malloc(sizeof(SLOT)*maxTerm);
    if (term_space == NULLPTR) { 
	    perror("OS memory allocation error,too large term space ");
	    exit(1);
	    }

    printf("ROPM Code generator\n\n");

  {
#define BUFHEADLEN	3
int *pReadVar;
int  size;
    ReadInputForPgm(argv[k],&pReadVar,&size);

    PgmInit(pReadVar+BUFHEADLEN,pReadVar[1]);
    init_entry_list();	/* initialize Entry list for compiler */
    PgmConsult((char*)pReadVar+pReadVar[1]+BUFHEADLEN*sizeof(int),pReadVar[2]);
  }
    StaticAnalysis();
#ifdef PRIORITY
    PgmMaxClauseBits();
#endif
    TRACE(PgmListing());

#if SHARED 
     getrusage(0,&usage);
     begSec = usage.ru_utime.tv_sec * 1000 + usage.ru_utime.tv_usec / 1000;
#endif
     CodeGen();
     TRACE(OsPrintf("+++ end of code generator output\n"));
    SET_P_C_MARKER();

#if SHARED
     getrusage(0,&usage);
     endSec = usage.ru_utime.tv_sec * 1000 + usage.ru_utime.tv_usec / 1000;
     printf("Time: %d Milliseconds.\n",endSec-begSec);
#endif
}


ReadInputForPgm(str,ppBuf,pSize)
char *str;
int  **ppBuf,*pSize;
{
#define OPSPROLOGSIZE	50000

    FILE *fp1,*fp2;
    char *buf; 		/* 2nd = end index of OPS, 3rd = end index of input*/
    int	 i,*intPtr;	/* 1st = the end index of the buf */

    if((fp1 = fopen(OPS,"r")) == NULL) {
	fprintf(stderr,"Unable to open init file: %s\n",OPS);
	exit(1);
	}
    if((fp2 = fopen(str,"r")) == NULL) {
	fprintf(stderr,"PgmConsult: Could not open %s for reading.\n",str);
	exit(1);
	}
    Malloc_Block(buf,OPSPROLOGSIZE+BUFHEADLEN*sizeof(int),char);
    intPtr = (int*) buf;

    for (i=BUFHEADLEN*sizeof(int); (buf[i++]=getc(fp1))!=EOF && i<OPSPROLOGSIZE; )
	;	
    if (i >= OPSPROLOGSIZE) {
	fprintf(stderr,"Init file OPS too large (or buffer too small)\n");
	exit(1);
	}
    buf[i++] = '\0'; intPtr[1] = i-BUFHEADLEN*sizeof(int); fclose(fp1);

    for ( ; (buf[i++]=getc(fp2))!=EOF && i<OPSPROLOGSIZE; )
	;	
    if (i >= OPSPROLOGSIZE) {
	fprintf(stderr,"Prolog file %s too large \n",str);
	exit(1);
	}
    buf[i++] = '\0'; intPtr[2] = i-intPtr[1]-BUFHEADLEN*sizeof(int); 
    fclose(fp2);
    
    intPtr[0] = i;

    *ppBuf = intPtr; *pSize = intPtr[0];
}
