/*
 * lattice.h
 * Header file for lattice.c
 *
 * AUTHOR:  David Roch
 *
 * CONTRIBUTORS:
 *	DAR - David Roch
 *
 * HISTORY:
 *	6/25/88 - Created DAR
 */

#ifndef	H_LATTICE	/* if this file has not already been included */

#define H_LATTICE	1	/* indicate this file has been included */

/* type system definition */
#define EMPTY		0	/* empty set */
#define	SCALAR		1	/* ground w/ no top level functor */
#define	GROUND		2	/* term is fully ground */
#define	PARTIAL		3	/* term is partially instantiated
				   but has at least one free var */
#define	FREEVAR		4	/* term is a free variable */
#define	FREE_SCALAR	5	/* free or scalar */
#define	FREE_GROUND	6	/* free or ground */
#define	PARTIAL_GROUND	7	/* partial or ground */
#define DONTKNOW	8	/* term has no information */


typedef struct TYPEENTRY {
  char		*name;
  SHORT		entry;
} TYPEENTRY;

#endif	/* end #if H_LATTICE */
