 
/* the byte code interpreter for the ROPM compiler */

#ifdef PRIORITY
#define Priority
#endif

#include "typedefs.h"
#include "ropm.h"
#include "instruct.h"
#include "macros.c"
#include "ropm_macros.c"
#include "be_macros.c"
#include "seq_macros.c"
#include "gen.h"

#ifdef PRIORITY
#include "priority_macros.c"
#endif

#ifdef IPSC2
    extern Instruction *Instr; 
    extern char *ProcNames[];
    extern char *TopNames[];
    extern LONG *SeqStack, **SeqTrail;
    extern LONG MAXSTACKSIZE, MAXTRAILSIZE;
    extern LONG CONS;
    extern BOOLEAN PRINT_SOL_TIMES;
    SHORT i;
    SHORT nextterm;
    BOOLEAN PSubtermground;
    BOOLEAN suspend;
    BOOLEAN contexttupused;
    SLOT *debugCTerm;     /* for debugging only */
    BOOLEAN allbuiltins;
    SLOT *switchterm;    /* for optimising switch on term */
    SLOT *originaltuple; /* for detecting tuple extensions by builtins */
    SHORT PC;
    MESSAGE *delayedmsg;

#include "registers.c"
#endif

BCInterp(Entrypt, Msgptr, Dataptr)
SHORT Entrypt;
MESSAGE *Msgptr;
LocalArea *Dataptr;

{
#ifndef IPSC2

    extern Instruction *Instr; 
    extern char *ProcNames[];
    extern char *TopNames[];
    extern LONG *SeqStack, **SeqTrail;
    extern LONG MAXSTACKSIZE, MAXTRAILSIZE;
    extern LONG CONS;
    extern BOOLEAN PRINT_SOL_TIMES;
    SHORT i;
    SHORT nextterm;
    BOOLEAN PSubtermground;
    BOOLEAN suspend;
    BOOLEAN contexttupused;
    SLOT *debugCTerm;     /* for debugging only */
    BOOLEAN allbuiltins;
    SLOT *switchterm;    /* for optimising switch on term */
    SLOT *originaltuple; /* for detecting tuple extensions by builtins */
    SHORT PC;
    MESSAGE *delayedmsg;

#include "registers.c"

#endif

    PC = Entrypt;
    suspend = FALSE;
    seqexecution = FALSE;
    TOJstack = 0;
    TONTstack = 0;	  /*  builtins done inline for AND parallel branches */
    originaltuple = NULL;
    if (MSGMAINTYPE(Msgptr) == MSGTYPE_GOAL)
    {
	Dataptr->querycount = 0;  
	delayedmsg = NULL;
	X[2] = X[3] = 0;
	Mstack = mstack;
	TOMstack = 0;
    }
    while(!suspend)
    switch (Instr[PC].opcode)
    {
	case AllocateBlock:
		/* arg[0] gives the size of the required block in SLOTS */

		Malloc_Block(Mstack, 3*sizeof(SLOT)*Instr[PC].arg[0],SLOT *);
	        PC++;
		break;

	case FireArc:
		/* arg 0 is the arc number of arc being fired */
		/* arg 1 is the node number of the preceding node */
		/* arg 2 is the goal entrypt corresponding to arc */
		/* arg 3 is the response entrypt corresponding to arc */
		/* arg 4 is the address of the literal corresponding to the arc
		   in term_space */
		/* arg 5 gives the status bits associated with the call site */
		/* arg 6 is literal distance from the last node */
		/* arg 7 is the numSeqLitBits of the clause */
		{
		    ChareIDType mychareid;
		    GOALSLOT *goalslot;
		    SLOT *cxttuple;
		    PVECTOR	*arc_priority = NULLPTR;
#ifdef PRIORITY
		    PVECTOR	*PgenLiteralPriority();
#endif

#ifdef PRIO_INHERIT
		   PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector,arc_priority);
#endif

#ifdef PRIO_DISTANCE
		    arc_priority = PgenLiteralPriority(ptrQ,Instr[PC].arg[6],
					Instr[PC].arg[1], Instr[PC].arg[7]);
#endif

#ifdef INST_STATIC
		    arc_priority = PgenLiteralPriority(ptrQ,Instr[PC].arg[6],
					Instr[PC].arg[1], Instr[PC].arg[7]);
		    ptrQ->lit_start_count[Instr[PC].arg[1]]++;
#endif

#ifdef INST_DYNAMIC
		    arc_priority = PgenLiteralPriority(ptrQ,Instr[PC].arg[6],
					Instr[PC].arg[1], Instr[PC].arg[7]);
		    PGEN_UPDATE_LIT_START(ptrQ,Instr[PC].arg[1]);
#endif

		    allbuiltins = FALSE;
		    X[0] = Instr[PC].arg[1];
		    if ( originaltuple != NULL )
		         cxttuple = originaltuple;
		    else cxttuple = CTuple;
		    NewGoalSlot(goalslot,ptrQ,Instr[PC].arg[0], X[0],cxttuple);
		    ptrQ->activeTnum[X[0]]++;
		    ptrQ->nodeVec |= (1 << X[0]);
		    MyChareID(&mychareid);
		    SendGoalMsg((LONG)goalslot, CTuple, mychareid, 
				Instr[PC].arg[2], Instr[PC].arg[4], 
 				Instr[PC].arg[3], Instr[PC].arg[5],arc_priority);
		}
		PC++;
		break;

	case FreeBlock:
		/* arg[0] provides the size (in SLOTS) of block being freed */
		Free_Slots(Mstack, 3 * Instr[PC++].arg[0]);
		break;

	case CreateNewQuery:
		/* arg 0 gives the number of nodes in the clause */
		/* arg 1 gives the number of arcs in the clause  */
		/* arg 2 gives size of query - RopmGetQuerySize(Clauseptr) */
		/* arg 3 gives the log2(number of identical clauses/arity)
			 in bits: numClauseBits */
		/* arg 4 gives the clauseNumber starting with 0 for a set
			 of identical clauses/arity */

		{
		    SHORT size;
		    PVECTOR	*query_priority = NULLPTR;

		    Dataptr->querycount++;
#ifdef PRIORITY
		    PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, query_priority);
#endif
#ifdef PRIORITY
		    ptrQ = (QUERY *) NewQuery(MSGCHAREID(Msgptr),
					   MSGGSLOT(Msgptr), Instr[PC].arg[0],
					   Instr[PC].arg[1], Instr[PC].arg[2],
					   Msgptr->statusbits, Msgptr->respEP,
					   query_priority,
					   Instr[PC].arg[3], Instr[PC].arg[4]);
#else
		    ptrQ = (QUERY *) NewQuery(MSGCHAREID(Msgptr),
					   MSGGSLOT(Msgptr), Instr[PC].arg[0],
					   Instr[PC].arg[1], Instr[PC].arg[2],
					   Msgptr->statusbits, Msgptr->respEP,
					   query_priority, 0, 0);
#endif

		    if (DEBUG)
		    OsPrintf("NewRedChare: created new query %x\n",ptrQ);

		    if (PTuple == Y)     /* in Y regs */
		    {
			/* copy PTuple from Y registers */
			size = TUPLESIZE(PTuple);
			if (size != 1)
			{
			    Malloc_Slots(PTuple, size);
			    for (i = 0; i < size; i++)
			        PTuple[i] = Y[i];
			}
			else PTuple = NULL;   
		    }
		    ptrQ->ptrParentT = PTuple;
		}
		PC++;
		break;

	case Suspend:
		suspend = TRUE;
		break;

	case Exit:
		suspend = TRUE;
		OsPrintf("\n@@@@@@@@@@@@@@@@ SYSTEM DONE @@@@@@@@@@@@@@\n");
#ifndef SHARED
		OsPrintf("\n%d ms elapsed time\n\n", OsGetSysClk());
#endif
		if (DEBUG)
		OsPrintf("Term space usage is %d slots\n",next_term);
		OsKillSys();
		break;

	case GetFactEnv	:
		/* set up the global variables for unification */
		/* assuming parameters to be: 
		   	0 - address of fact literal 
			1 - # of variables in fact */
	        {
		    SHORT ptupsize;

		    ptrGS = (GOALSLOT *)Msgptr->goalSlot;
		    ptrQ = NULL;  
		    ptupsize = TUPLESIZE(Msgptr->goalResp);
		    CTuple = A;  /* using A registers for CTuple */
		    INSERT_TUPLE_SIZE(CTuple, Instr[PC].arg[1] + 1);
		    InitTuple((&CTuple[1]), Instr[PC].arg[1]);
		    PTerm = Msgptr->goalterm;
		    PTuple = Y;
		    INSERT_TUPLE_SIZE(PTuple, ptupsize);
		    for (i = 1; i < ptupsize; i++)
		   	PTuple[i] = (SLOT)(Msgptr->goalResp)[i];  
		    nextterm = 0;
		    PSubtermground = FALSE;
		    CTerm = (SLOT *)Instr[PC].arg[0]; 
		}
		PC++;
		break;

	case GetClauseEnv:
		/* set up the global variables for unification */
		/* assuming parameters to be: 
		   	0 - address of clause head
			1 - # of variables in child clause	*/
		{
		    SHORT ptupsize;

		    allbuiltins = TRUE;
		    ptrQ = NULL;  
		    ptrGS = (GOALSLOT *)Msgptr->goalSlot;
		    CTuple = A;  /* using A registers as CTuple */
		    INSERT_TUPLE_SIZE(CTuple, Instr[PC].arg[1] + 1);
		    InitTuple((&CTuple[1]), Instr[PC].arg[1]);
		    PTerm = Msgptr->goalterm;
		    ptupsize = TUPLESIZE(Msgptr->goalResp);
		    PTuple = Y;
		    INSERT_TUPLE_SIZE(PTuple, ptupsize);
		    for (i = 1; i < ptupsize; i++)
		    	PTuple[i] = (SLOT)(Msgptr->goalResp)[i];  
		    nextterm = 0;
		    PSubtermground = FALSE;
		    CTerm = (SLOT *)Instr[PC].arg[0]; 
		}
		PC++;
		break;


	/*=====  unification  =====*/
	case BeforeUnifPrint:
		if (DEBUG)
		{
		    OsPrintf("BE: unifying ");
		    PrintTerm(PTerm, PTuple);
		    OsPrintf("\nwith           ");
		    debugCTerm = CTerm;
		    PrintTerm(CTerm, CTuple);
		    OsPrintf("\n");
		}
		PC++;
		break;

	case AfterUnifPrint:
		if (DEBUG)
		{
		    /* should be called if unification is successful */
		    OsPrintf("BE: after unif: the child term is =\n      ");
		    PrintTerm(debugCTerm, CTuple);
		    OsPrintf("\n");
		}
		PC++;
		break;
		
	case Halt:
		suspend = TRUE;
		OsKillSys();
		break;

	case nop:
		/* do nothing */
		PC++;
		break;

	case Write:
		/* arg 0 gives the address of subterm being printed */
		PrintTerm(Instr[PC].arg[0], CTuple);
		PC++;
		break;

	case Newline:
		OsPrintf("\n");
		PC++;
		break;

	case PrintVars:
		/* arg 0 gives address of print_vars functor in term space */
		{
		    SLOT *varlist;
		    SHORT arity;
		    extern char *VarName();
    		    char    strout[2000], temp1[80], temp2[1000];

		    varlist = (SLOT *)Instr[PC].arg[0];
		    arity = ARITY(varlist);
  		    strout[0] = '\0';
		    for (i = 1; i <= arity; i++)
		    {
  		    	temp1[0] = '\0';
  		    	temp2[0] = '\0';
		    	sprintf(temp1, "%s = ",VarName(i));
		    	strcat(strout,temp1);
			ParPrintTerm(varlist + i, CTuple, temp2);
		    	strcat(strout,temp2);
		    	strcat(strout,"\n");
		    }
		    if (PRINT_SOL_TIMES)
		    {
  		    	temp1[0] = '\0';
  		    	sprintf(temp1, "%d MS to solution",OsTimer(TIMER_READ));
		    	strcat(strout,temp1);
		    }
  		    strcat(strout,"\n\n");
  		    OsPrintf(strout);
		}
		PC++;
		break;

	case Fail:
		/* arg 0 contains the fail address */
		PC = Instr[PC].arg[0];
		if (PC < 0)
		   if (seqexecution)
		      FAIL()
		   else suspend = TRUE;   
		break;

	case Succeed:
		/* for control information update */
		/* arg 0 is the address to jump to after this instruction
		   for mutex optimisation */
		X[3]++;
		PC = Instr[PC].arg[0];
		break;

	case ISVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
#ifdef IPSC2
		ISVarVarProc();
#else
		{
		    SLOT *leftterm, *rightterm;
		    BOOLEAN failed = FALSE;

		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
		       OsPrint("integer reqd. in rhs of IS\n");
		       OsKillSys();
		    }
		    else
		    {
			if (TAG_IS_INTEGER(leftterm))
			  failed = (INTVALUE(leftterm) != INTVALUE(rightterm));
			else if (TAG_IS_UNBOUND(leftterm))
			{
			    if (seqexecution) *TR++ = leftterm;
			    INSERT_INTEGER(leftterm, INTVALUE(rightterm));
			}
			else if (TAG_IS_TUPLE_INDEX_1(leftterm))
			{
			    if (seqexecution) *TR++ = &CTuple[INDEX(leftterm)];
			    INSERT_INTEGER(&CTuple[INDEX(leftterm)], 
					   INTVALUE(rightterm));
			}
			PC = failed ? Instr[PC].arg[2] : PC+1;
			if (failed)
			    if (seqexecution)
			        FAIL()
			    else suspend = (PC < 0);
		    }
		}
#endif
		break;

	case ISVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    BOOLEAN failed = FALSE;

		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (TAG_IS_INTEGER(leftterm))
		        failed = (INTVALUE(leftterm) != Instr[PC].arg[1]);
		    else if (TAG_IS_UNBOUND(leftterm))
		    {
			if (seqexecution) *TR++ = leftterm;
		        INSERT_INTEGER(leftterm, Instr[PC].arg[1]);
		    }
		    else if (TAG_IS_TUPLE_INDEX_1(leftterm))
		    {
			if (seqexecution) *TR++ = &CTuple[INDEX(leftterm)];
		        INSERT_INTEGER(&CTuple[INDEX(leftterm)], Instr[PC].arg[0]);
		    }
		    PC = failed ? Instr[PC].arg[2] : PC+1;
		    if (failed)
		        if (seqexecution)
		            FAIL()
			else suspend = (PC < 0);
		}
		break;

	case ISVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    BOOLEAN failed = FALSE;

		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (TAG_IS_INTEGER(leftterm))
		        failed = (INTVALUE(leftterm) != X[Instr[PC].arg[1]]);
		    else if (TAG_IS_UNBOUND(leftterm))
		    {
			if (seqexecution) *TR++ = leftterm;
		        INSERT_INTEGER(leftterm, X[Instr[PC].arg[1]]);
		    }
		    else if (TAG_IS_TUPLE_INDEX_1(leftterm))
		    {
			if (seqexecution) *TR++ = &CTuple[INDEX(leftterm)];
		        INSERT_INTEGER(&CTuple[INDEX(leftterm)], X[Instr[PC].arg[1]]);
		    }
		    PC = failed ? Instr[PC].arg[2] : PC+1;
		    if (failed)
		        if (seqexecution)
		             FAIL()
			else suspend = (PC < 0);
		}
		break;

	case ISIntVar:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;

		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
		       OsPrint("integer reqd. in rhs of IS\n");
		       OsKillSys();
		    }
		    else if (Instr[PC].arg[0] == INTVALUE(rightterm))
		        PC++;
		    else if (seqexecution)
		         FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case ISIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (Instr[PC].arg[0] == X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
	             FAIL()
		else 
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case NEVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm, *rightterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!(TAG_IS_INTEGER(leftterm) && TAG_IS_INTEGER(rightterm)))
		    {
			OsPrint("Integer required in =\\=\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else if (INTVALUE(leftterm) != INTVALUE(rightterm)) 
		         PC++;
		    else if (seqexecution)
		         FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);			
		    }
		}
		break;

	case NEVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in =\\=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) != Instr[PC].arg[1])
		         PC++;
		    else if (seqexecution)
		         FAIL()    
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);			
		    }
		}
		break;

	case NEVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in =\\=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) != X[Instr[PC].arg[1]])
		         PC++;
		    else if (seqexecution)
		         FAIL() 
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case NEIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (Instr[PC].arg[0] != X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		     FAIL()
		else
		{
		    PC =  Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case NEAccAcc:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (X[Instr[PC].arg[0]] != X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else 
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case LTVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm, *rightterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!(TAG_IS_INTEGER(leftterm) && TAG_IS_INTEGER(rightterm)))
		    {
			OsPrint("Integer required in <\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) < INTVALUE(rightterm)) 
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case LTVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in <\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) < Instr[PC].arg[1])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case LTVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the reg. no containing evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in <\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) < X[Instr[PC].arg[1]])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case LTIntVar:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in <\n");
			OsKillSys();
		    }
		    else if (Instr[PC].arg[0] < INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case LTIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (Instr[PC].arg[0] < X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else 
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case LTAccVar:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in <\n");
			OsKillSys();
		    }
		    else if (X[Instr[PC].arg[0]] < INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case LTAccInt:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */

		PC = (X[Instr[PC].arg[0]] < Instr[PC].arg[1]) ? PC+1 : Instr[PC].arg[2];
		suspend = (PC < 0);
		break;

	case LTAccAcc:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */

		if (X[Instr[PC].arg[0]] < X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case GTVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm, *rightterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!(TAG_IS_INTEGER(leftterm) && TAG_IS_INTEGER(rightterm)))
		    {
			OsPrint("Integer required in >\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) > INTVALUE(rightterm)) 
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case GTVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in >\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) > Instr[PC].arg[1])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else 
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case GTVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in >\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) > X[Instr[PC].arg[1]])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case GTIntVar:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in >\n");
			OsKillSys();
		    }
		    else if (Instr[PC].arg[0] > INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case GTIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */

		if (Instr[PC].arg[0] > X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else 
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case GTAccVar:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in >\n");
			OsKillSys();
		    }
		    else if (X[Instr[PC].arg[0]] > INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case GTAccInt:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the integer value of left subterm */
		/* arg 2 is the fail address */

		if (X[Instr[PC].arg[0]] > Instr[PC].arg[1])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case GTAccAcc:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */

		if (X[Instr[PC].arg[0]] > X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else 
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm, *rightterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!(TAG_IS_INTEGER(leftterm) && TAG_IS_INTEGER(rightterm)))
		    {
			OsPrint("Integer required in =:=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) == INTVALUE(rightterm)) 
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in =:=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) == Instr[PC].arg[1])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in =:=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) == X[Instr[PC].arg[1]])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (Instr[PC].arg[0] == X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQAccAcc:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */

		if (X[Instr[PC].arg[0]] == X[Instr[PC].arg[1]]) 
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQLTVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm, *rightterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!(TAG_IS_INTEGER(leftterm) && TAG_IS_INTEGER(rightterm)))
		    {
			OsPrint("Integer required in =<\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) <= INTVALUE(rightterm)) 
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQLTVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in =<\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) <= Instr[PC].arg[1])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQLTVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in =<\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) <= X[Instr[PC].arg[1]])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	    case EQLTIntVar:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in =<\n");
			OsKillSys();
		    }
		    else if (Instr[PC].arg[0] <= INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQLTIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (Instr[PC].arg[0] <= X[Instr[PC].arg[1]])
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQLTAccVar:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in =<\n");
			OsKillSys();
		    }
		    else if (X[Instr[PC].arg[0]] <= INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQLTAccInt:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the integer value of left subterm */
		/* arg 2 is the fail address */
		if (X[Instr[PC].arg[0]] <= Instr[PC].arg[1]) 
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQLTAccAcc:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if(X[Instr[PC].arg[0]] <= X[Instr[PC].arg[1]]) 
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQGTVarVar:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm, *rightterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    rightterm = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!(TAG_IS_INTEGER(leftterm) && TAG_IS_INTEGER(rightterm)))
		    {
			OsPrint("Integer required in >=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) >= INTVALUE(rightterm)) 
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQGTVarInt:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the integer value of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in >=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) >= Instr[PC].arg[1])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQGTVarAcc:
		/* arg 0 is the index of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		{
		    SLOT *leftterm;
		    
		    leftterm  = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(leftterm, CTuple);
		    if (!TAG_IS_INTEGER(leftterm))
		    {
			OsPrint("Integer required in >=\n");
			OsKillSys();
		    }
		    else if (INTVALUE(leftterm) >= X[Instr[PC].arg[1]])
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQGTIntVar:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in >=\n");
			OsKillSys();
		    }
		    else if (Instr[PC].arg[0] >= INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQGTIntAcc:
		/* arg 0 is the integer value of left subterm */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (Instr[PC].arg[0] >= X[Instr[PC].arg[1]]) 
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQGTAccVar:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the index of right subterm */
		/* arg 2 is the fail address */
		{
		    SLOT *rightterm;
		    
		    rightterm  = &CTuple[Instr[PC].arg[1]];
		    Deref_Term(rightterm, CTuple);
		    if (!TAG_IS_INTEGER(rightterm))
		    {
			OsPrint("Integer required in >=\n");
			OsKillSys();
		    }
		    else if (X[Instr[PC].arg[0]] >= INTVALUE(rightterm))
		         PC++;
		    else if (seqexecution)
		        FAIL()
		    else
		    {
			PC = Instr[PC].arg[2];
			suspend = (PC < 0);
		    }
		}
		break;

	case EQGTAccInt:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the integer value of left subterm */
		/* arg 2 is the fail address */
		if (X[Instr[PC].arg[0]] >= Instr[PC].arg[1]) 
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case EQGTAccAcc:
		/* arg 0 is the regno containing  evaluated lhs expression */
		/* arg 1 is the regno containing  evaluated rhs expression */
		/* arg 2 is the fail address */
		if (X[Instr[PC].arg[0]] >= X[Instr[PC].arg[1]]) 
		    PC++;
		else if (seqexecution)
		    FAIL()
		else
		{
		    PC = Instr[PC].arg[2];
		    suspend = (PC < 0);
		}
		break;

	case CopyVartoAcc:
		/* arg 0 is the index of variable */
		/* arg 1 is the index of the register to use */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (!TAG_IS_INTEGER(term))
		    {
			OsPrint("illegal tag in evaluate\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else X[Instr[PC].arg[1]] = INTVALUE(term);
		}
		PC++;
		break;

	case AddVartoAcc:
		/* arg 0 is the index of variable */
		/* arg 1 is the index of the register to use */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (!TAG_IS_INTEGER(term))
		    {
			OsPrint("illegal tag in evaluate\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else X[Instr[PC].arg[1]] += INTVALUE(term);
		}
		PC++;
		break;

	case SubVarFromAcc:
		/* arg 0 is the index of variable */
		/* arg 1 is the index of the register to use */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (!TAG_IS_INTEGER(term))
		    {
			OsPrint("illegal tag in evaluate\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else X[Instr[PC].arg[1]] -= INTVALUE(term);
		}
		PC++;
		break;

	case MultVartoAcc:
		/* arg 0 is the index of variable */
		/* arg 1 is the index of the register to use */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (!TAG_IS_INTEGER(term))
		    {
			OsPrint("illegal tag in evaluate\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else X[Instr[PC].arg[1]] *= INTVALUE(term);
		}
		PC++;
		break;

	case DivAccbyVar:
		/* arg 0 is the index of variable */
		/* arg 1 is the index of the register to use */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (!TAG_IS_INTEGER(term))
		    {
			OsPrint("illegal tag in evaluate\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else X[Instr[PC].arg[1]] = X[Instr[PC].arg[1]] / INTVALUE(term);
		}
		PC++;
		break;

	case ModAccbyVar:
		/* arg 0 is the index of variable */
		/* arg 1 is the index of the register to use */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (!TAG_IS_INTEGER(term))
		    {
			OsPrint("illegal tag in evaluate\n");
			OsKillSys();
			suspend = TRUE;
		    }
		    else X[Instr[PC].arg[1]] = X[Instr[PC].arg[1]] % INTVALUE(term);
		}
		PC++;
		break;

	case CopyInttoAcc:
		/* arg 0 is the integer value of term */
		/* arg 1 is the index of the register to use */
		X[Instr[PC].arg[1]] = Instr[PC].arg[0];
		PC++;
		break;

	case AddInttoAcc:
		/* arg 0 is the integer value of term */
		/* arg 1 is the index of the register to use */
		X[Instr[PC].arg[1]] += Instr[PC].arg[0];
		PC++;
		break;

	case SubIntFromAcc:
		/* arg 0 is the integer value of term */
		/* arg 1 is the index of the register to use */
		X[Instr[PC].arg[1]] -= Instr[PC].arg[0];
		PC++;
		break;

	case MultInttoAcc:
		/* arg 0 is the integer value of term */
		/* arg 1 is the index of the register to use */
		X[Instr[PC].arg[1]] *= Instr[PC].arg[0];
		PC++;
		break;

	case DivAccbyInt:
		/* arg 0 is the integer value of term */
		/* arg 1 is the index of the register to use */
		X[Instr[PC].arg[1]] = X[Instr[PC].arg[1]] / Instr[PC].arg[0];
		PC++;
		break;

	case ModAccbyInt:
		/* arg 0 is the integer value of term */
		/* arg 1 is the index of the register to use */
		X[Instr[PC].arg[1]] = X[Instr[PC].arg[1]] % Instr[PC].arg[0];
		PC++;
		break;


	case UnifyVarTerm:
		/* arg 0 is the index of the variable being unified */
		/* arg 1 is the address of the term being unified */
		/* arg 2 is the fail address */
#ifdef IPSC2
		UnifyVarTermProc();
#else
		{
		    SLOT *term = (SLOT *) Instr[PC].arg[1];
		    SLOT *tuple = CTuple;
		    MOLECULE_PTR *molecule;
		    BOOLEAN Unify(), SeqUnify(), thrumolecule = FALSE;

		    Deref_Term(term, CTuple);
		    CTerm = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(CTerm, CTuple);
		    if (TAG_IS_TUPLE_INDEX_1(CTerm))
			CTerm = &CTuple[INDEX(CTerm)];
		    if (TAG_IS_UNBOUND(CTerm))
		    {
			if (seqexecution) *TR++ = CTerm;
			if (TAG_IS_FUNCTOR(term))
			   if (seqexecution)
			   {
			       ALLOC_SEQ_MOLECULE(CTerm, molecule,StackLimit);
			       INSERT_MOLEC_TERMS(molecule, term);
			       INSERT_MOLEC_TUPLE(molecule, CTuple);
			   }
			   else INSERT_ADDRESS(CTerm, term)
			else if (TAG_IS_MOLECULE(term))
			{
			    molecule = MOLECULE_ADDRESS(term);
			    COPY_MOLECULE(CTerm, term, molecule);
			}
			else if (TAG_IS_SEQ_MOLECULE(term))
			    COPY_SEQ_MOLECULE(CTerm, term, StackLimit);
			PC++;
		    }
		    else
		    {
			if (TAG_IS_MOLECULE(term))
			{
			    molecule = MOLECULE_ADDRESS(term);
			    term = TERMS(molecule);
			    tuple = TUPLE(molecule);
			    thrumolecule = TRUE;
			}
			if (TAG_IS_SEQ_MOLECULE(term))
			{
			    molecule = SEQ_MOLECULE_ADDRESS(term);
			    term = TERMS(molecule);
			    tuple = TUPLE(molecule);
			}
			switch (SLOT_TAG(CTerm))
			{
			case MOLECULE:
			    molecule = MOLECULE_ADDRESS(CTerm);
			    if (seqexecution)
			    {
				if (SeqUnify(TERMS(molecule), TUPLE(molecule), 
					     term, tuple, TRUE, Stack, &TR,&StackLimit))
			         PC++;
				else PC = Instr[PC].arg[2];
			    }
			    else if (Unify(TERMS(molecule), TUPLE(molecule), 
					   term, tuple, TRUE))
			         PC++;
			    else PC = Instr[PC].arg[2];
			    break;
			case SEQ_MOLECULE:
			    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
			    if (SeqUnify(TERMS(molecule), TUPLE(molecule), 
					term, tuple, thrumolecule, Stack, &TR,&StackLimit))
			    PC++;
			    else PC = Instr[PC].arg[2];
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    if (seqexecution)
			    {
				if (SeqUnify(CTerm, CTuple, term, tuple,
					  thrumolecule, Stack, &TR,&StackLimit))
				PC++;
				else PC = Instr[PC].arg[2];
			    }
			    else if (Unify(CTerm,CTuple, term, tuple, 
					   thrumolecule))
			    PC++;
			    else PC = Instr[PC].arg[2];
			    break;
			default:
			    PC = Instr[PC].arg[2];  /* fail */
			    break;
			}
		    }
		    if (PC == Instr[PC].arg[2])
		        if (seqexecution)
		            FAIL()
			else suspend = (PC < 0);
		}
#endif
		break;

	case UnifyVarAtom:
		/* arg 0 is the index of the variable being unified */
		/* arg 1 is the address of the term being unified */
		/* arg 2 is the fail address */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (TAG_IS_UNBOUND(term))
		    {
			if (seqexecution) *TR++ = term;
		        COPY_ATOM(term, (SLOT *)Instr[PC].arg[1]);
			PC++;
		    }
		    else if (TAG_IS_TUPLE_INDEX_1(term))
		    {
			if (seqexecution) *TR++ = &CTuple[INDEX(term)];
		        COPY_ATOM(&CTuple[INDEX(term)], (SLOT *)Instr[PC].arg[1]);
			PC++;
		    }
		    else if (TAG_IS_FUNCTOR(term) && ARITY_IS_ZERO(term) &&
			    (GET_FUNCTOR(term) == GET_FUNCTOR((SLOT *)Instr[PC].arg[1])))
		         PC++;
		    else PC = Instr[PC].arg[2];

		    if (PC == Instr[PC].arg[2])
		        if (seqexecution)
		            FAIL()
			else suspend = (PC < 0);
		}
		break;

	case UnifyVarInt:
		/* arg 0 is the index of the variable being unified */
		/* arg 1 is the integer value of the second term */
		/* arg 2 is the fail address */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];
		    
		    Deref_Term(term, CTuple);
		    if (TAG_IS_UNBOUND(term))
		    {
			if (seqexecution) *TR++ = term;
		        INSERT_INTEGER(term, Instr[PC].arg[1]);
			PC++;
		    }
		    else if (TAG_IS_TUPLE_INDEX_1(term))
		    {
			if (seqexecution) *TR++ = &CTuple[INDEX(term)];
		        INSERT_INTEGER(&CTuple[INDEX(term)], Instr[PC].arg[1]);
			PC++;
		    }
		    else if (TAG_IS_INTEGER(term) &&
			     INTVALUE(term) == Instr[PC].arg[1])
		         PC++;
		    else PC = Instr[PC].arg[2];

		    if (PC == Instr[PC].arg[2])
		        if (seqexecution)
		            FAIL()
		    else suspend = (PC < 0);
		}
		break;

	case UnifyVarVar:
		/* arg 0 is the index of the variable being unified */
		/* arg 1 is the index of the variable being unified */
		/* arg 2 is the fail address */
#ifdef IPSC2
		UnifyVarVarProc();
#else
		{
		    SLOT *term1 = &CTuple[Instr[PC].arg[0]],
		    	 *term2 = &CTuple[Instr[PC].arg[1]];
		    SLOT *tuple1, *tuple2;
		    MOLECULE_PTR *molecule;
		    BOOLEAN Unify(), SeqUnify();

		    Deref_Term(term1, CTuple);
		    Deref_Term(term2, CTuple);
		    if (TAG_IS_TUPLE_INDEX_1(term1))
		        term1 = &CTuple[INDEX(term1)];
		    if (TAG_IS_TUPLE_INDEX_1(term2))
		        term2 = &CTuple[INDEX(term2)];

		    if (TAG_IS_UNBOUND(term1))
		    {
			if (seqexecution) *TR++ = term1;
			switch(SLOT_TAG(term2))
			{
			case FUNCTOR:
			    if (seqexecution)
			    {
				ALLOC_SEQ_MOLECULE(term1, molecule,StackLimit);
				INSERT_MOLEC_TERMS(molecule, term2);
				INSERT_MOLEC_TUPLE(molecule, CTuple);
				break;
			   }
			    /* else no break for non sequential case */
			case CLOSED_TERM:
			    if (ARITY_IS_ZERO(term2))
				COPY_ATOM(term1, term2);
			    else INSERT_ADDRESS(term1, term2);
			    break;
			case MOLECULE:
			     COPY_SLOT(term1, term2);
			case UNBOUND_VAR:
			    if (term1 != term2)
			    INSERT_INDEX(term1,term2 - CTuple,TUPLE_INDEX_1);
			    break;
			case INTEGER:
			    COPY_INTEGER(term1, term2);
			    break;
			default:
			    OsPrint("illegal slot tag in rhs of =\n");
			    OsKillSys();
			    suspend = TRUE;
			}
			PC++;
		    }
		    else if (TAG_IS_UNBOUND(term2))
		    {
			if (seqexecution) *TR++ = term2;
			switch(SLOT_TAG(term1))
			{
			case FUNCTOR:
			    if (seqexecution)
			    {
				ALLOC_SEQ_MOLECULE(term2, molecule,StackLimit);
			       INSERT_MOLEC_TERMS(molecule, term1);
			       INSERT_MOLEC_TUPLE(molecule, CTuple);
			       break;
			   }
			    /* else no break for non sequential case */
			case CLOSED_TERM:
			    if (ARITY_IS_ZERO(term1))
				COPY_ATOM(term2, term1);
			    else INSERT_ADDRESS(term2, term1);
			    break;
			case MOLECULE:
			     COPY_SLOT(term2, term1);
			case INTEGER:
			    COPY_INTEGER(term2, term1);
			    break;
			default:
			    OsPrint("illegal slot tag in lhs of =\n");
			    OsKillSys();
			    suspend = TRUE;
			}
			PC++;
		    }
		    else if (TAG_IS_MOLECULE(term1) || TAG_IS_MOLECULE(term2))
		    {
			if (TAG_IS_MOLECULE(term1))
			{
			    molecule = MOLECULE_ADDRESS(term1);
			    term1 = TERMS(molecule);
			    tuple1 = TUPLE(molecule);
			}
			else if (TAG_IS_SEQ_MOLECULE(term1))
			{
			    molecule = SEQ_MOLECULE_ADDRESS(term1);
			    term1 = TERMS(molecule);
			    tuple1 = TUPLE(molecule);
			}
			else tuple1 = CTuple;
			if (TAG_IS_MOLECULE(term2))
			{
			    molecule = MOLECULE_ADDRESS(term2);
			    term2 = TERMS(molecule);
			    tuple2 = TUPLE(molecule);
			}
			else if (TAG_IS_SEQ_MOLECULE(term2))
			{
			    molecule = SEQ_MOLECULE_ADDRESS(term2);
			    term2 = TERMS(molecule);
			    tuple2 = TUPLE(molecule);
			}
			else tuple2 = CTuple;
			if (seqexecution)
			{
			     if (SeqUnify(term1, tuple1, term2, tuple2,
					  TRUE, Stack, &TR,&StackLimit))
			         PC++;
			     else PC = Instr[PC].arg[2];
			}
			else if (Unify(term1, tuple1, term2, tuple2, TRUE))
			     PC++;
			else PC = Instr[PC].arg[2];
		    }
		    else if (TAG_IS_SEQ_MOLECULE(term1) || 
			     TAG_IS_SEQ_MOLECULE(term2))
		    {
			if (TAG_IS_SEQ_MOLECULE(term1))
			{
			    molecule = SEQ_MOLECULE_ADDRESS(term1);
			    term1 = TERMS(molecule);
			    tuple1 = TUPLE(molecule);
			}
			else tuple1 = CTuple;
			if (TAG_IS_SEQ_MOLECULE(term2))
			{
			    molecule = SEQ_MOLECULE_ADDRESS(term2);
			    term2 = TERMS(molecule);
			    tuple2 = TUPLE(molecule);
			}
			else tuple2 = CTuple;
			if (SeqUnify(term1, tuple1, term2, tuple2,
				     FALSE, Stack, &TR, &StackLimit))
			     PC++;
			else PC = Instr[PC].arg[2];
		    }
		    else if (TAG_IS_FUNCTOR(term1) && TAG_IS_FUNCTOR(term2))
		    {
			if (seqexecution)
			{
			     if (SeqUnify(term1, CTuple, term2, CTuple,
					  FALSE, Stack, &TR, &StackLimit))
			         PC++;
			     else PC = Instr[PC].arg[2];
			}
			else if (Unify(term1, CTuple, term2, CTuple, FALSE))
			     PC++;
			else PC = Instr[PC].arg[2];
		    }
		    else if (TAG_IS_INTEGER(term1) && TAG_IS_INTEGER(term2) &&
			    (INTVALUE(term1) == INTVALUE(term2)))
			     PC++;
		    else PC = Instr[PC].arg[2];
		    
		    if (PC == Instr[PC].arg[2])
		        if (seqexecution)
		            FAIL()
			else suspend = (PC < 0);
		}
#endif
		break;

	case NEqualVarAtom:
		/* arg 0 is the index of the variable in question */
		/* arg 1 is address of atom that it shouldn't be equal to */
		/* arg 2 is the fail address */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]],
		         *atom = (SLOT *) Instr[PC].arg[1];

		    Deref_Term(term, CTuple);
		    if (TAG_IS_TUPLE_INDEX_1(term))
		         PC = Instr[PC].arg[2];   /* fail */
		    else if (TAG_IS_FUNCTOR(term) && ARITY_IS_ZERO(term) &&
			    GET_FUNCTOR(term) == GET_FUNCTOR(atom))
		         PC = Instr[PC].arg[2];   /* fail */
		    else PC++;
		}
		break;

	case NEqualVarTerm:
		/* arg 0 is the index of the variable in question */
		/* arg 1 is address of term that it shouldn't be equal to */
		/* arg 2 is the fail address */
		{
		    SLOT *varterm = &CTuple[Instr[PC].arg[0]],
		         *term = (SLOT *) Instr[PC].arg[1];

		    Deref_Term(varterm, CTuple);
		    if (TAG_IS_TUPLE_INDEX_1(varterm))
		         PC = Instr[PC].arg[2];   /* fail */
		    else if (TAG_IS_FUNCTOR(varterm) && 
			          GET_FUNCTOR(varterm) == GET_FUNCTOR(term) &&
		                  ARITY(varterm) == ARITY(term))
		         if (NEqual(varterm, term, CTuple))
			      PC++;
		         else PC = Instr[PC].arg[2];   /* fail */
		    else PC++;
		}
		break;


	case NEqualVarInt:
		/* arg 0 is the index of the variable in question */
		/* arg 1 is the integer that it shouldn't be equal to */
		/* arg 2 is the fail address */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];

		    Deref_Term(term, CTuple);
		    if (TAG_IS_TUPLE_INDEX_1(term))
		         PC = Instr[PC].arg[2];   /* fail */
		    else if (TAG_IS_INTEGER(term) && 
				INTVALUE(term) == Instr[PC].arg[1])
		         PC = Instr[PC].arg[2];   /* fail */
		    else PC++;
		}
		break;

	case NEqualVarVar:
		/* arg 0 is the index of the variable in question */
		/* arg 1 is index of variable containing the 
		   term that it shouldn't be equal to */
		/* arg 2 is the fail address */
		{
		    SLOT *varterm = &CTuple[Instr[PC].arg[0]],
		         *term = &CTuple[Instr[PC].arg[1]];

		    Deref_Term(varterm, CTuple);
		    Deref_Term(term, CTuple);
		    if (TAG_IS_TUPLE_INDEX_1(varterm) || 
			                 TAG_IS_TUPLE_INDEX_1(term))
		         PC = Instr[PC].arg[2];   /* fail */
		    else if (NEqual(varterm, term, CTuple))
			      PC++;
		    else PC = Instr[PC].arg[2];   /* fail */
		}
		break;

	case Var:
		/* arg 0 is the index into ctuple of variable in question */
		/* arg 1 is the fail address */
		{
		    SLOT *term = &CTuple[Instr[PC].arg[0]];

		    Deref_Term(term, CTuple);
		    PC =(TAG_IS_TUPLE_INDEX_1(term)) ? PC+1 : Instr[PC].arg[1];
		}
		break;

	case NonVar:
		/* arg 0 is the index into ctuple of variable in question */
		/* arg 1 is the fail address */
		{
		   SLOT *term = &CTuple[Instr[PC].arg[0]];

		   Deref_Term(term, CTuple);
		   PC =(!TAG_IS_TUPLE_INDEX_1(term)) ? PC+1 : Instr[PC].arg[1];
		}
		break;

	case Atom:
		/* arg 0 is the address of term in question */
		/* arg 1 is the fail address */
		{
		   SLOT *term = (SLOT *) Instr[PC].arg[0];

		   Deref_Term(term, CTuple);
		   if (TAG_IS_FUNCTOR(term) && ARITY_IS_ZERO(term))
		        PC++;
		   else PC = Instr[PC].arg[1];
		}
		break;

	case Int:
		/* arg 0 is the index of variable that may be an int */
		/* arg 1 is the fail address */
		{
		   SLOT *term = &CTuple[Instr[PC].arg[0]];

		   Deref_Term(term, CTuple);
		   PC = (TAG_IS_INTEGER(term)) ? PC+1 : Instr[PC].arg[1];
		}
		break;

	    case BuiltinArg:
		/* arg 0 is the "arg" term that is to be evaluated */
		/* arg 1 is the fail address should the builtin fail */
		{
		    SLOT *term = (SLOT *) Instr[PC].arg[0];
		    BOOLEAN SeqBuiltinARG(), BuiltinARG();

		    if (seqexecution)
			if (SeqBuiltinARG(term, CTuple, &TR, Stack,&StackLimit))
		             PC++;
			else PC = Instr[PC].arg[1];
		    else 
		    {
			if (BuiltinARG(term, CTuple))
		             PC++;
			else PC = Instr[PC].arg[1];
		    }
		    if (PC == Instr[PC].arg[1])
		        if (seqexecution)
			    FAIL()
			else suspend = (PC < 0);
		}
		break;

	    case BuiltinFunc:
		/* arg 0 is the "func" term that is to be evaluated */
		/* arg 1 is the number of max chains in the "current" clause */
		/* arg 2 is the fail address should the builtin fail */
		{
		    SLOT *term = (SLOT *) Instr[PC].arg[0];
		    SLOT *oldCtuple = CTuple;
		    BOOLEAN SeqBuiltinFUNCTOR(), BuiltinFUNCTOR();
		    
		    if (seqexecution)
			if (SeqBuiltinFUNCTOR(term,CTuple, &TOS, &TR, Stack, &StackLimit))
			    PC++;
			else PC = Instr[PC].arg[2];
		    else 
		    {
			if (BuiltinFUNCTOR(term, &CTuple, Instr[PC].arg[1],A))
			{
			    PC++;
			    if (oldCtuple != CTuple && originaltuple == NULL)
			        originaltuple = oldCtuple;
			}
			else PC = Instr[PC].arg[2];
		    }
		    if (PC == Instr[PC].arg[2])
		        if (seqexecution)
			    FAIL()
			else suspend = (PC < 0);
		}
		break;

	    case BuiltinUniv:
		/* arg 0 is the "univ" term that is to be evaluated */
		/* arg 1 is the fail address should the builtin fail */
		{
		    SLOT *term = (SLOT *) Instr[PC].arg[0];
		    BOOLEAN SeqBuiltinUNIV(), BuiltinUNIV();

		    if (seqexecution)
			if (SeqBuiltinUNIV(term,CTuple, &TR, Stack, &StackLimit))
		             PC++;
			else PC = Instr[PC].arg[1];
		    else 
		    {
			if (BuiltinUNIV(term, CTuple))
		             PC++;
			else PC = Instr[PC].arg[1];
		    }
		    if (PC == Instr[PC].arg[1])
		        if (seqexecution)
			    FAIL()
			else suspend = (PC < 0);
		}
		break;

	case AddTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		X[Instr[PC].arg[1]] += tempreg[Instr[PC].arg[0]];
		PC++;
		break;

	case SubtractTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		X[Instr[PC].arg[1]] -= tempreg[Instr[PC].arg[0]];
		PC++;
		break;

	case MultiplyTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		X[Instr[PC].arg[1]] *= tempreg[Instr[PC].arg[0]];
		PC++;
		break;

	case DivideTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		X[Instr[PC].arg[1]] /= tempreg[Instr[PC].arg[0]] ;
		PC++;
		break;

	case ModTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		X[Instr[PC].arg[1]] %= tempreg[Instr[PC].arg[1]];
		PC++;
		break;

	case DivTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		X[Instr[PC].arg[1]] /= tempreg[Instr[PC].arg[1]];
		PC++;
		break;

	case StoreinTemp:
		/* arg 0 is the temp reg number */
		/* arg 1 is the index of register currently in use */
		tempreg[Instr[PC].arg[0]] = X[Instr[PC].arg[1]];
		PC++;
		break;

	case Unify1stVar:
		/* first occurrence of a variable - known to be unbound */
		/* index of var in CTuple is arg 0 */
		/* arg 1 is the jump address should unification fail */
#ifdef IPSC2
		Unify1stVarProc(Msgptr);
#else
		{
		    MOLECULE_PTR *molecule;
		    SHORT index = Instr[PC].arg[0];

		    CTerm = &A[index]; 
		    /* CTerm must be unbound */
		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(PSubterm))
		    {
		    case TUPLE_INDEX_1:
 			INSERT_INDEX(&PTuple[INDEX(PSubterm)], 
				             index,TUPLE_INDEX_2);
			break;
		    case CLOSED_TERM:
			if ( ARITY_IS_ZERO(PSubterm))
			     COPY_ATOM(CTerm, PSubterm);
			else INSERT_ADDRESS(CTerm, PSubterm);
			break;
		    case MOLECULE:
			molecule = MOLECULE_ADDRESS(PSubterm);
			COPY_MOLECULE(CTerm, PSubterm, molecule);
			break;
		    case FUNCTOR:
			if (PSubtermground)
			{
			    Malloc_Molecule(molecule);
			    INSERT_MOLEC_TERMS(molecule, PSubterm);
			    INSERT_MOLEC_TUPLE(molecule, PTuple);
			    INSERT_MOLECULE(CTerm, molecule);
			}
			else INSERT_INDEX(CTerm, PSubterm - term_space, 
					  TERM_SPC_INDEX_2);
			break;
		    case TUPLE_INDEX_2:
			COPY_INDEX(CTerm, PSubterm, TUPLE_INDEX_1);
			break;
		    case TERM_SPC_INDEX_2:
			COPY_INDEX(CTerm, PSubterm, TERM_SPC_INDEX_1);
			break;
		    case INTEGER:
		    case REAL:
			COPY_ATOM(CTerm, PSubterm);
			break;
		    default:
			OsPrintf("error! illegal slot_tag in Unify1stVar\n");
			suspend = TRUE;
		    }
		    PC++;
		}
#endif
		break;

	case UnifyVar:
		/* variable may be unbound or previously bound */
		/* index of var in CTuple is arg 0 */
		/* arg 1 is the jump address should unification fail */
#ifdef IPSC2
		UnifyVarProc(Msgptr);
#else
		{
		    MOLECULE_PTR *molecule;
		    BOOLEAN Unify();
		    SHORT index = Instr[PC].arg[0];

		    CTerm = &A[index];
		    Deref_Term(CTerm, CTuple);
		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);

		    if (TAG_IS_TUPLE_INDEX_1(CTerm))
		        CTerm = &A[INDEX(CTerm)];
		    if (TAG_IS_UNBOUND(CTerm))
		    {
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    INSERT_INDEX(&PTuple[INDEX(PSubterm)], 
					     index, TUPLE_INDEX_2);
			    break;
			case CLOSED_TERM:
			    if ( ARITY_IS_ZERO(PSubterm))
			         COPY_ATOM(CTerm, PSubterm);
			    else INSERT_ADDRESS(CTerm, PSubterm);
			    break;
			case MOLECULE:
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    COPY_MOLECULE(CTerm, PSubterm, molecule);
			    break;
			case FUNCTOR:
			    if (PSubtermground)
			    {
				Malloc_Molecule(molecule);
				INSERT_MOLEC_TERMS(molecule, PSubterm);
				INSERT_MOLEC_TUPLE(molecule, PTuple);
				INSERT_MOLECULE(CTerm, molecule);
			    }
			    else INSERT_INDEX(CTerm, PSubterm - term_space, 
					      TERM_SPC_INDEX_2);
			    break;
			case TUPLE_INDEX_2:
			    if (index != INDEX(PSubterm))
			        COPY_INDEX(CTerm, PSubterm, TUPLE_INDEX_1);
			    break;
			case TERM_SPC_INDEX_2:
			    COPY_INDEX(CTerm, PSubterm, TERM_SPC_INDEX_1);
			    break;
			case INTEGER:
			case REAL:
			    COPY_ATOM(CTerm, PSubterm);
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in UnifyVar\n");
			    suspend= TRUE;
			}
			PC++;
		    }
		    else if (TAG_IS_TUPLE_INDEX_1(PSubterm))
		    {
			switch(SLOT_TAG(CTerm))
			{
			case CLOSED_TERM:
			    if ( ARITY_IS_ZERO(CTerm))
			         COPY_ATOM(&PTuple[INDEX(PSubterm)], CTerm);
			    else INSERT_ADDRESS(&PTuple[INDEX(PSubterm)], CTerm);
			    break;
			case MOLECULE:
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    COPY_MOLECULE(&PTuple[INDEX(PSubterm)], CTerm, molecule);
			    break;
			case FUNCTOR:
			    INSERT_INDEX(&PTuple[INDEX(PSubterm)], CTerm - term_space, TERM_SPC_INDEX_2);
			    break;
			case TUPLE_INDEX_2:
			    COPY_INDEX(&PTuple[INDEX(PSubterm)], CTerm, TUPLE_INDEX_1);
			    break;
			case TERM_SPC_INDEX_2:
			    COPY_INDEX(&PTuple[INDEX(PSubterm)], CTerm, TERM_SPC_INDEX_1);
			    break;
			case INTEGER:
			case REAL:
			    COPY_ATOM(&PTuple[INDEX(PSubterm)], CTerm);
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in UnifyVar\n");
			    suspend = TRUE;
			}
			PC++;
		    }
		    else if(TAG_IS_INTEGER(PSubterm))
		         if (TAG_IS_INTEGER(CTerm) && 
			     INTEGERS_EQUAL(PSubterm, CTerm))
		              PC++;
			 else PC = Instr[PC].arg[1]; 
		    else if (TAG_IS_REAL(PSubterm))
		         if (TAG_IS_REAL(CTerm) && 
			     REALS_EQUAL(PSubterm, CTerm))
		              PC++;
			 else PC = Instr[PC].arg[1]; 
		    else 
		    {
			BOOLEAN thrumolecule = FALSE;
			SLOT *tempPTuple, *tempCTuple;
			
			if (TAG_IS_MOLECULE(PSubterm))
			{
			    tempPTuple = TUPLE((MOLECULE_ADDRESS(PSubterm)));
			    PSubterm = TERMS((MOLECULE_ADDRESS(PSubterm)));
			    thrumolecule = TRUE;
			}
			else tempPTuple = Msgptr->goalResp;

			if (TAG_IS_MOLECULE(CTerm))
			{
			    tempCTuple = TUPLE((MOLECULE_ADDRESS(CTerm)));
			    CTerm = TERMS((MOLECULE_ADDRESS(CTerm)));
			}
			else tempCTuple = CTerm;

			if (!Unify(PSubterm, tempPTuple, CTerm, tempCTuple,
				                                thrumolecule))
			         PC = Instr[PC].arg[1]; 
		         else PC++;
		    }
		}
#endif
		break;

	case UnifyGround:
		/* variable may be unbound and will be bound to a ground term
		   after unification, OR variable may have become bound
		   previously */
		/* arg 1 is the jump address should unification fail */
		{
		    SLOT  *CSubterm;
		    MOLECULE_PTR *molecule;
		    BOOLEAN Unify();

		    CSubterm = (SLOT *)Instr[PC].arg[0]; 
		    PSubterm = &PTerm[nextterm];
		    Deref_Term(PSubterm, PTuple);
/*		    Deref_Term(CSubterm, CTuple);  */
		    
		    if (!Unify(PSubterm, PTuple, CSubterm, CTuple,FALSE))
		         PC = Instr[PC].arg[1];  /* FAIL UNIFICATION */
		    else
		    {
			/* make the tag of bound term a ground term */
			if (TAG_IS_TERM_INDEX_2(CSubterm))
			{
			    Malloc_Molecule(molecule);
			    INSERT_MOLEC_TERMS(molecule, &term_space[INDEX(CSubterm)]);
			    INSERT_MOLEC_TUPLE(molecule, PTuple);
			    INSERT_MOLECULE(CSubterm, molecule);
			}
			PC++;
			nextterm++;
		    }
		}
		break;

	case UnifyStrct:
		/* arg 0 is the address of structure being unified */
		/* arg 1 is the jump address for the next argument */
		/* arg 2 is the jump address for failed unification */
		/* arg 3 is the depth of the structure being unified */
#ifdef IPSC2
		UnifyStrctProc();
#else
		{
		    MOLECULE_PTR *molecule;
		    
		    TOMstack = 4 * Instr[PC].arg[3]; 
		    CTerm = (SLOT *) Instr[PC].arg[0];
		    Mstack[TOMstack++] = PTuple; /* stack current PTuple
						   upon entry into struct */
		    Mstack[TOMstack++] = (SLOT *)++nextterm;
		    Mstack[TOMstack++] = (SLOT *)PSubtermground;
		    Mstack[TOMstack++] = PTerm;
		    PTerm = &PTerm[nextterm];
		    Deref_Term(PTerm, PTuple);
		    switch (SLOT_TAG(PTerm))
		    {
		    case TUPLE_INDEX_1:
			if (TAG_IS_CLOSED_TERM(CTerm))
			     INSERT_ADDRESS(&PTuple[INDEX(PTerm)], CTerm)
			else INSERT_INDEX(&PTuple[INDEX(PTerm)], (CTerm - term_space), TERM_SPC_INDEX_2);
			PTerm = Mstack[--TOMstack];
			TOMstack -= 3;    /* pop the stack - nexterm and 
					    PTuple unchanged */
			PC = Instr[PC].arg[1];   /* next argument */
			break;

		    case MOLECULE:
		    case TERM_SPC_INDEX_2:
			if (TAG_IS_MOLECULE(PTerm))
			{
			    molecule = MOLECULE_ADDRESS(PTerm);
			    PTerm = TERMS(molecule);
			    PTuple = TUPLE(molecule);
			    PSubtermground = TRUE;
			}
			else 
			{
			    PTerm = &term_space[INDEX(PTerm)];
			    PTuple = CTuple;
			}
			/* no break. Fall into next case */

		    case FUNCTOR:
		    case CLOSED_TERM:
			if ((ARITY(PTerm) == ARITY(CTerm)) &&
			    (GET_FUNCTOR(PTerm) == GET_FUNCTOR(CTerm)))
			{
			    PC++;
			    nextterm = 0;
			}
			else PC = Instr[PC].arg[2];    /* fail unification */
			break;

		    case TUPLE_INDEX_2:
			INSERT_ADDRESS(&CTuple[INDEX(PTerm)],CTerm);
			PC = Instr[PC].arg[1];   /* next argument */
			PTerm = Mstack[--TOMstack];
			TOMstack -= 3;    /* pop the stack - PSubtermground,
					    nexterm and  PTuple unchanged */
			PC = Instr[PC].arg[1];   /* next argument */
			break;

		    default:
			PC = Instr[PC].arg[2];   /* fail unification */
		    }
		}
#endif
		break;
			
	case UnifyAtom:
		/* arg 0 is an atomic functor (arity 0). */
		/* arg 1 is the jump address for failed unification */
		{
		    SLOT *atom = (SLOT *) Instr[PC].arg[0];

		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(PSubterm))
		    {
		    case TUPLE_INDEX_1:
			COPY_ATOM(&PTuple[INDEX(PSubterm)], atom);
			PC++;
			break;
			
		    case FUNCTOR:
		    case CLOSED_TERM:
			if (!ARITY_IS_ZERO(PSubterm) ||
			    (GET_FUNCTOR(PSubterm) != GET_FUNCTOR(atom)))
			     PC = Instr[PC].arg[1];  /* FAIL UNIFICATION */
			else PC++;
			break;
			
		    case TUPLE_INDEX_2:
			COPY_ATOM(&CTuple[INDEX(PSubterm)], atom);
			PC++;
			break;

		    default:
			PC = Instr[PC].arg[1];  /* FAIL UNIFICATION */
		    }
		}
		break;

	case UnifyCon:
		/* arg 0 is the constant */
		/* arg 1 is the jump address for failed unification */
		{
		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(PSubterm))
		    {
		    case TUPLE_INDEX_1:
			INSERT_INTEGER(&PTuple[INDEX(PSubterm)], Instr[PC].arg[0]);
			PC++;
			break;

		    case INTEGER:
			if (INTVALUE(PSubterm) != Instr[PC].arg[0])
			     PC = Instr[PC].arg[1];     /* FAIL UNIFICATION */
			else PC++;
			break;

		    case REAL:
			if (REALVALUE(PSubterm) != Instr[PC].arg[0])
			     PC = Instr[PC].arg[1];     /* FAIL UNIFICATION */
			else PC++;
			break;

		    case TUPLE_INDEX_2:
			INSERT_INTEGER(&CTuple[INDEX(PSubterm)], Instr[PC].arg[0]);
			PC++;
			break;

		    default:
			     PC = Instr[PC].arg[1];     /* FAIL UNIFICATION */
		    }
		}
		break;

	case CloseCVar:
		/* arg[0] provides index of variable */
		{
		    SLOT *CSubterm, *pterm, *NewTerm;
		    MOLECULE_PTR *molecule;
		    SHORT oldsize, newsize;

		    newsize = oldsize = TUPLESIZE(CTuple);
		    CSubterm = &CTuple[Instr[PC].arg[0]];
		    if (TAG_IS_TERM_INDEX_2(CSubterm))
		    {
			SHORT termsize;

			pterm = &term_space[INDEX(CSubterm)];
/*			DECREMENT_REF_COUNT(pterm);  */
			if (NoVarsIn(pterm, PTuple))
			{
			    if (PTuple == Y)  /* in Y regs  */
			    {
				Malloc_Slots(PTuple, TUPLESIZE(Y));
				*PTuple = *Y;  /* tuplesize */
				for (i = 1; i < TUPLESIZE(PTuple); i++)
				    PTuple[i] = Y[i];   
			    }
			    Malloc_Molecule(molecule);
			    INSERT_MOLEC_TUPLE(molecule, PTuple);
			    INSERT_MOLEC_TERMS(molecule, pterm);
			    INSERT_MOLECULE(CSubterm, molecule);
			}
			else
			{
			    termsize = TermSize(pterm, PTuple);
			    Malloc_Slots(NewTerm, termsize);
			    INSERT_ADDRESS(CSubterm, NewTerm);
			    CopyTerm(pterm, PTuple, &NewTerm, &newsize);
			    if (newsize > oldsize)
			    {
				InitTuple((&CTuple[oldsize]), (newsize - oldsize));
				INSERT_TUPLE_SIZE(CTuple,newsize);
			    }

			}
		    }  /* if TSI_2 */
		}
		PC++;
		break;

	    case TopStack:
		/* arg 0 indicates which stack push is to be performed on */
		
		switch (Instr[PC].arg[0])
		{
		case MOLECSTACK:
		    /* not used */
		    break;
		case JOINSTACK:
		    /* not used */
		    break;
		case NODETUPSTACK:
		    CTuple = NTstack[TONTstack-1]; /* top elt. on stack */
		    if (DEBUG)
		       if (TONTstack <= 0) 
		       OsPrint("error - illegal TONTstack value\n");
		    break;
		default:
		    OsPrint("Illegal stack id. in TopStack\n");
		    break;
		}
		PC++;
		break;

	    case PushStack:
		/* arg 0 indicates which stack push is to be performed on */
		
		switch (Instr[PC].arg[0])
		{
		case MOLECSTACK:
		    /* never called - is done inside UnifyStruct */
		    break;
		case JOINSTACK:
		    {
			if (TOJstack >= 5 * (JOINSTACKSIZE - 1))
			{
			    OsPrint("Too many nested joins. Current implementation allows 5 - aborting execution...\n");
			    exit(1);
			}
			contexttupused = TRUE;
			Jstack[TOJstack++] = jointuple[0];
			Jstack[TOJstack++] = jointuple[1];
			Jstack[TOJstack++] = contexttuple[0];
			Jstack[TOJstack++] = contexttuple[1];
			Jstack[TOJstack++] = pc_ancestor;
			break;
		    }
		case NODETUPSTACK:
			NTstack[TONTstack++] = CTuple;
			break;
		default:
		    OsPrint("Illegal stack id. in PushStack\n");
		    break;
		}
		PC++;
		break;

	    case PopStack:
		/* arg 0 identifies the stack to be used for the Pop */

		switch (Instr[PC].arg[0])
		{
		case MOLECSTACK:
		    if (TOMstack > 0)
		    {
			PTerm =  Mstack[--TOMstack]; 
			PSubtermground = (BOOLEAN) Mstack[--TOMstack]; 
			nextterm = (int) Mstack[--TOMstack];
			PTuple = Mstack[--TOMstack]; 
		    }
		    break;
		case JOINSTACK:
		    {
			pc_ancestor = Jstack[--TOJstack];
			contexttuple[1] = Jstack[--TOJstack];
			contexttuple[0] = Jstack[--TOJstack];
			jointuple[1] = Jstack[--TOJstack];
			jointuple[0] = Jstack[--TOJstack];
		    }
		    break;
		case NODETUPSTACK:
		    CTuple = NTstack[--TONTstack];
		    break;
		default:
		    OsPrint("Illegal stack id. in PopStack\n");
		}
		PC++;
		break;

	    case SetUpJoin:
		/* arg0 is the joinindex - i.e. am I arc0 or arc1 in the join?
		        The arc with lower arcnum is arc0                  */
		/* arg1 is the index in context tuple for  the ca-tuple 
		   ---- if 1 then context tuple is the ca-tuple
		   ---- if 2 then CTuple is the ca-tuple (all builtins)   
		   ---- all "real" indices are negative                    */
		/* arg2 is the fwd-other index in the ca-tuple             */
		/* arg3 is the fwd-me index in the ca-tuple                */
		/* arg4 is the index of the chain used to get next tuple   */
		/* arg5 is the jump address if no tuples in other join arc */
		{
		    SHORT arccode = Instr[PC].arg[0]; 
		    SLOT *cxttuple;

		    jointuple[arccode] = CTuple;   /* is resp tuple */
		    if (originaltuple != NULL)
		    {
			cxttuple = originaltuple;
			originaltuple = NULL;
		    }
		    else cxttuple = CTuple;
		    if (contexttupused || Instr[PC].arg[1] == 2)
		    {
			/* nested join encountered after a builtin */
			jointuple[arccode][ContextTupIndex] = (SLOT)cxttuple;
			contexttuple[arccode] = cxttuple;
		    }
		    else
		    {
			jointuple[arccode][ContextTupIndex] = (SLOT)ptrGS->contexttuple;
			contexttuple[arccode] = ptrGS->contexttuple;
		    }
		    if ( Instr[PC].arg[1] > 0)
			 pc_ancestor = contexttuple[arccode];
		    else pc_ancestor = (SLOT *)BackPtr(contexttuple[arccode],Instr[PC].arg[1]);
		    jointuple[1-arccode] = (SLOT *)ForwardPtr(pc_ancestor,Instr[PC].arg[2]);
		    NextTuplePtr(jointuple[arccode],Instr[PC].arg[4]) = ForwardPtr(pc_ancestor,Instr[PC].arg[3]);
		    ForwardPtr(pc_ancestor,Instr[PC].arg[3]) = (SLOT)jointuple[arccode];
		    if ( jointuple[1-arccode] == NULL)
		         PC = Instr[PC].arg[5];
		    else
		    {
			contexttuple[1-arccode] = (SLOT *)jointuple[1-arccode][ContextTupIndex];
			PC++;
		    }
		}
		break;

	    case JoinTuples:
		/* arg0 is the join node (may not need it) */
		/* arg1 is the number of chain links required by this node */
		/* arg2 is the number of back pointers required by this node */
		/* arg3 is the number of fwd ptrs required by this node */
		CTuple = BeJoinTuples(jointuple[0], jointuple[1],
				      TUPLESIZE(pc_ancestor),Instr[PC].arg[1],
				      Instr[PC].arg[2], Instr[PC].arg[3]);
		PC++;
		break;

	    case NextTuple:
		/* arg0 is the arccode - are we processing arc0 or arc1? */
		/* arg 1 is the chain index used to get the next tuple */
		/* arg2 is the jump address to continue joins */
		{
		    SHORT arccode = 1 - Instr[PC].arg[0];

		    jointuple[arccode] = (SLOT *)
 		             NextTuplePtr(jointuple[arccode],Instr[PC].arg[1]);
		    if (jointuple[arccode] == NULL)
		         PC++; 
		    else 
		    {
			contexttuple[arccode] = 
			         (SLOT *)jointuple[arccode][ContextTupIndex];
			PC = Instr[PC].arg[2];
		    }
		}
		break;

	    case CopyBackPtr:
		/* arg0 is the index of the back pointer that needs to be
		        copied in the new node tuple */
		/* arg1 is the nodecode - 1 refers to contexttuple1
		        2 refers to context tuple2, however, <= 0 refers to 
			contexttuple1 using indirection, and
			|arg0| gives  index into contexttuple1       */
		/* arg2 is the index in the tuple suggested by arg0
		        1 is the current tuple itself, 2  is the contexttuple,
			all other (<= 0) indices refer to 
		        tuple pointed at by the corresponding backpointer */
		/* arg3 determines whether the current node is a join node (=1)
		        or not (=0) */
		{
		    SHORT index    = Instr[PC].arg[2];

		    if (Instr[PC].arg[3] == 0)  /* not join node */
		    {   /* New Node tuple has been set up. */
			/* X[4] contains old value of Ctuple before setup */
			if ( index == 1)  /* tuple is ctuple */
			     BackPtr(CTuple, Instr[PC].arg[0]) = (SLOT) X[4];
		        else if (index == 2)  /* tuple is context tuple */ 
    		             BackPtr(CTuple, Instr[PC].arg[0]) = (SLOT) ptrGS->contexttuple;
			else BackPtr(CTuple, Instr[PC].arg[0]) = 
			                   BackPtr(ptrGS->contexttuple, index);
		    }
		    else
		    {
			SHORT nodecode = Instr[PC].arg[1] - 1;
			
			if (nodecode >= 0)  
			{
			    if (index == 1) /* tuple is current tuple */
			        BackPtr(CTuple,Instr[PC].arg[0]) = 
				                  (SLOT) jointuple[nodecode];
			    else if (index == 2) /* tuple at previous node */
			        BackPtr(CTuple,Instr[PC].arg[0]) = 
				 		(SLOT) contexttuple[nodecode];
			    else BackPtr(CTuple,Instr[PC].arg[0]) = 
			    		BackPtr(contexttuple[nodecode],index);
			}
			else  /* use indirection */
			{
			    X[1] = BackPtr(contexttuple[0], nodecode);
			    BackPtr(CTuple,Instr[PC].arg[0]) = BackPtr(((SLOT *)X[1]),index);
			}
		    }
		}
		PC++;
		break;
		
	    case MCACheck:
		/* arg0 is the arccode used to identify my arc */
		/* arg1 is the index in "my" contexttuple to locate MCA */
		/* arg2 is the index in "other" contexttuple to locate MCA */
		/* arg3 is the index of the chain pointer to get next tuple */
		/* arg4 is the jump addresses if no joins to be performed  */
		{
		    SHORT arccode = Instr[PC].arg[0];

		    while (BackPtr(contexttuple[arccode], Instr[PC].arg[1]) != 
			   BackPtr(contexttuple[1-arccode], Instr[PC].arg[2]))
		    {
			jointuple[1-arccode] = (SLOT *)
		           NextTuplePtr(jointuple[1-arccode],Instr[PC].arg[3]);
			if (jointuple[1-arccode] == NULL)
			{
			    PC = Instr[PC].arg[4];
			    break;
			}
			else contexttuple[1-arccode] = 
			         (SLOT *)jointuple[1-arccode][ContextTupIndex];
		    }
		    if (jointuple[1-arccode] != NULL)
		        PC++;
		}
		break;

	case SetUpNodeTuple:
		/* arg0 is the node number in question - may not be needed */
		/* arg1 is the number of links needed by a join tuple  */
		/* arg2 is the number of back pointers needed at node */
		/* arg3 is the number of forward pointers needed at node */
		{
		    X[4] = (SLOT) CTuple;
		    X[0] = Instr[PC].arg[2];
		    X[1] = Instr[PC].arg[3];
		    Malloc_NodeTuple(CTuple,TUPLESIZE((SLOT *)X[4]),
				     Instr[PC].arg[1], X[0],X[1]);
		    INSERT_TUPLE_SIZE(CTuple, TUPLESIZE((SLOT *)X[4]));
		    CopyTuple(CTuple, ((SLOT *)X[4]));
		    if (originaltuple != NULL)  
		    {   /* need to use original tuple to copy back ptrs */
			X[4] = (SLOT) originaltuple;
			originaltuple = NULL;
		    }
		}		     
		PC++;
		break;

	    case SendFactResp:
		/* arg 0 is the max number of chains that a join tuple
		   may belong to (if the response is for a join arc) */
		/* arg 1 is the address to jump to after this instruction 
		   for mutex optimisation */
		/* PTuple needs to be closed w.r.t CTuple and sent as resp*/
#ifdef IPSC2
		SendFactRespProc(Msgptr);
#else
		{

		    SHORT tupsize, newtupsize, termsize;
		    SLOT *cterm, *newterm;
		    MOLECULE_PTR *molecule;
		    PVECTOR	 *resp_priority = NULLPTR;

		    tupsize = newtupsize = TUPLESIZE(PTuple);
		    for (i = 1; i < tupsize; i++)
		    {   
			if (TAG_IS_TUPLE_INDEX_2(&PTuple[i]))
			{
			    cterm = &CTuple[INDEX(&PTuple[i])];
			    Deref_Term(cterm, CTuple);
			    switch (SLOT_TAG(cterm))
			    {
			    case ABSOLUTE_ADDRESS:
			    case MOLECULE:
				INSERT_ADDRESS((&PTuple[i]),cterm);
				break;
			    case CLOSED_TERM:
				if (ARITY_IS_ZERO(cterm))
				     COPY_ATOM(&PTuple[i],cterm);
				else INSERT_ADDRESS(&PTuple[i],cterm);
				break;
			    case REAL:
			    case INTEGER:
				COPY_ATOM((&PTuple[i]),cterm);
				break;
			    case UNBOUND_VAR:
				INSERT_SLOT_TAG(&PTuple[i], UNBOUND_VAR);
				INSERT_INDEX(cterm, i, TUPLE_INDEX_2);
				break;
			    case TUPLE_INDEX_1:
				INSERT_SLOT_TAG(&PTuple[i], UNBOUND_VAR);
				INSERT_INDEX(&CTuple[INDEX(cterm)], i, TUPLE_INDEX_2);
				break;
			    case FUNCTOR:
				INSERT_INDEX((&PTuple[i]),(cterm - term_space), TERM_SPC_INDEX_2);
				break;
			    case TUPLE_INDEX_2:
				COPY_INDEX((&PTuple[i]), cterm, TUPLE_INDEX_1);
				break;
			    case TERM_SPC_INDEX_2:
				COPY_INDEX((&PTuple[i]), cterm, TERM_SPC_INDEX_1);
				break;
			    default:
				OsPrintf("illegal slot tag in SendFactResp\n");
				suspend = TRUE;
			    }
			} /* TUP INDEX 2 */
		    }
		    for (i = 1; i < tupsize; i++)
		    {   
			if (TAG_IS_TERM_INDEX_2(&PTuple[i]))
			{
			    cterm = &term_space[INDEX(&PTuple[i])];
			    if (NoVarsIn(cterm, CTuple))
			    {
				if (CTuple == A)  /* in A regs  */
				{
				    Malloc_Slots(CTuple, TUPLESIZE(A));
				    *CTuple = *A;  /* tuplesize */
				    for (i = 1; i < TUPLESIZE(CTuple); i++)
				         CTuple[i] = A[i];   
				}
				/* create molecule */ 
				Malloc_Molecule(molecule);
				INSERT_MOLEC_TUPLE(molecule, CTuple);
				INSERT_MOLEC_TERMS(molecule, cterm);
				INSERT_MOLECULE(&PTuple[i], molecule);
			    }
			    else 
			    {
				/* copy term */
				termsize = TermSize(cterm, CTuple);
				Malloc_Slots(newterm, termsize);
				INSERT_ADDRESS(&PTuple[i], newterm);
				CopyTerm(cterm, CTuple, &newterm, &newtupsize);
			    }
			}
		    }
		    Malloc_ArcTuple(RTuple, newtupsize, Instr[PC].arg[0]);
		    INSERT_TUPLE_SIZE(RTuple, newtupsize);
		    for (i = 1; i < tupsize; i++)
		        RTuple[i] = PTuple[i];

		    if (newtupsize > tupsize)
		        InitTuple((&RTuple[tupsize]), (newtupsize - tupsize));
		    
		    /* send response */
		    if (DEBUG)
		    {
			OsPrintf("BE: after unif. the parent term is  =\n   ");
			PrintTerm(PTerm, RTuple);
			OsPrintf("\n");
			PrintTerm(PTerm, RTuple);
			OsPrintf("\n");
		    }
		    X[2]++;   /* no of resps sent to parent */
		    if (DEBUG)
			OsPrintf("sending response to goal slot %x\n", Msgptr->goalSlot);
#ifdef PRIORITY
		    PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, resp_priority);
#endif
		    if (Msgptr->statusbits & STAT_DET)
			 SendRespMsg((MSGTYPE_RESPDATA | MSGTYPE_RESPCNUM |
				      MSGTYPE_RESPRNUM), MSGCHAREID(Msgptr),
				      MSGGSLOT(Msgptr), RTuple, 1, 1,
				      Msgptr->respEP, resp_priority)
		    else DelayRespMsg(MSGTYPE_RESPDATA,MSGCHAREID(Msgptr),
				      Msgptr->goalSlot, RTuple, 0, 0,
				      Msgptr->respEP,delayedmsg, resp_priority);


		}
#endif
		PC = Instr[PC].arg[1];    /* for mutex optimisation */
		break;
		
	case SendClauseResp:
		/* arg 0 is the max number of chains that response tuple may 
		   belong to in a join arc */
#ifdef IPSC2
		SendClauseRespProc(Msgptr);
#else
		{
		    SHORT tupsize, newtupsize, termsize, j;
		    SLOT *cterm, *newterm;
		    MOLECULE_PTR *molecule;
		    PVECTOR	 *clause_resp_priority = NULLPTR;

		    if (DEBUG)
		    {
			OsPrintf("CLAUSERESP: solution found for query %x\n",ptrQ);
			OsPrintf("CLAUSERESP: before close resp is :\n");
			BePrintTuple(CTuple);
		    }
		    if (ptrQ != NULL)
		        PTuple = ptrQ->ptrParentT;

		    tupsize = newtupsize = TUPLESIZE(PTuple);
		    if (PTuple != Y)   /* may still be in Y regs */
		    {
			for (j = 0; j < tupsize; j++)
		            Y[j] = PTuple[j];   
		    }
		    for (i = 1; i < tupsize; i++)
		    {   
			if (TAG_IS_TUPLE_INDEX_2(&Y[i]))
			{
			    cterm = &CTuple[INDEX(&Y[i])];
			    Deref_Term(cterm, CTuple);
			    switch (SLOT_TAG(cterm))
			    {
			    case MOLECULE:
			    case REAL:
			    case INTEGER:
				COPY_SLOT((&Y[i]),cterm);
				break;
			    case UNBOUND_VAR:
				INSERT_SLOT_TAG(&Y[i], UNBOUND_VAR);
				INSERT_INDEX(cterm, i, TUPLE_INDEX_2);
				break;
			    case CLOSED_TERM:
				if (ARITY_IS_ZERO(cterm))
				     COPY_ATOM(&Y[i], cterm);
				else INSERT_ADDRESS(&Y[i], cterm);
				break;
			    case TUPLE_INDEX_1:
				INSERT_SLOT_TAG(&Y[i], UNBOUND_VAR);
				INSERT_INDEX(&CTuple[INDEX(cterm)], i, TUPLE_INDEX_2);
				break; 
			    case TUPLE_INDEX_2:
				COPY_INDEX(&Y[i], cterm, TUPLE_INDEX_1);
				break; 
			    case FUNCTOR:
				INSERT_INDEX((&Y[i]),(cterm - term_space), TERM_SPC_INDEX_2);
				break;
			    default:
				OsPrintf("illegal slot tag in SendClauseResp\n");
				suspend = TRUE;
			    }
			} /* TUP INDEX 2 */
		    }
		    for (i = 1; i < tupsize; i++)
		    {   
			if (TAG_IS_TERM_INDEX_2(&Y[i]))
			{
			    cterm = &term_space[INDEX(&Y[i])];
			    if (NoVarsIn(cterm, CTuple))
			    {
				if (CTuple == A)  /* in A regs  */
				{
				    Malloc_Slots(CTuple, TUPLESIZE(A));
				    for (j = 0; j < TUPLESIZE(A); j++)
				         CTuple[j] = A[j];   
				}
				/* create molecule */ 
				Malloc_Molecule(molecule);
				INSERT_MOLEC_TUPLE(molecule, CTuple);
				INSERT_MOLEC_TERMS(molecule, cterm);
				INSERT_MOLECULE(&Y[i], molecule);
			    }
			    else 
			    {
				/* copy term */
				termsize = TermSize(cterm, CTuple);
				Malloc_Slots(newterm, termsize);
				INSERT_ADDRESS(&Y[i], newterm);
				CopyTerm(cterm, CTuple, &newterm, &newtupsize);
			    }
			}
		    }
		    
		    /* copy response from registers and send it */
		    
		    Malloc_ArcTuple(RTuple, newtupsize, Instr[PC].arg[0]);
		    INSERT_TUPLE_SIZE(RTuple, newtupsize);
		    for (j = 1; j < tupsize; j++)
		        RTuple[j] = Y[j];
		    if (newtupsize > tupsize)
		        InitTuple((&RTuple[tupsize]), (newtupsize - tupsize));
		    if (DEBUG)
		    {		    
			OsPrintf("CLAUSERESP: after close - resp is :\n");
			BePrintTuple(RTuple);
		    }
		    /* send response */
		    {
#ifdef PRIORITY
		    if (ptrQ == NULL)
		       PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, clause_resp_priority)
		    else
		       PGEN_IDENTICAL_PVECTOR(ptrQ->priority_vector, clause_resp_priority);
#endif

			if (ptrQ == NULL)
			    if (Msgptr->statusbits & STAT_DET)
			         SendRespMsg((MSGTYPE_RESPDATA | 
					 MSGTYPE_RESPCNUM | MSGTYPE_RESPRNUM),
					 MSGCHAREID(Msgptr),MSGGSLOT(Msgptr), 
					 RTuple, 1 , 1, Msgptr->respEP,
					 clause_resp_priority)
			    else SendRespMsg(MSGTYPE_RESPDATA,
					 MSGCHAREID(Msgptr), MSGGSLOT(Msgptr), 
					 RTuple, 0, 0, Msgptr->respEP,
					 clause_resp_priority)
			else if (ptrQ->statusbits & STAT_DET)
			         SendRespMsg((MSGTYPE_RESPDATA | 
					 MSGTYPE_RESPCNUM | MSGTYPE_RESPRNUM), 
					 QUERYCHAREID(ptrQ), ptrQ->parentGnum, 
					 RTuple, 1, 1, ptrQ->respEP,
					 clause_resp_priority)
			else     SendRespMsg(MSGTYPE_RESPDATA, 
					 QUERYCHAREID(ptrQ), ptrQ->parentGnum, 
					 RTuple, 0 , 0, ptrQ->respEP,
					 clause_resp_priority);
		    }
		    if (allbuiltins)
		    {
			X[2]++;   /* # of responses incremented by 1 */
			X[3]--;   /* treat it as a builtin */
		    }
		    else ptrQ->respNum++;
		}
#endif
		PC++;
		break;
		
	case SendControlMsg:
		{
		    SHORT msgtype = MSGTYPE_RESPCNUM;
		    PVECTOR	 *control_resp_priority = NULLPTR;

#ifdef PRIORITY
		    PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, control_resp_priority);
#endif

		    if (X[2] > 0)
		    {
			msgtype |= MSGTYPE_RESPRNUM;
		        X[3]++;   /* # of clauses + 1 */
		    }
		    if (delayedmsg == NULL)
			SendRespMsg(msgtype, MSGCHAREID(Msgptr), 
				    MSGGSLOT(Msgptr), NULL,X[2], X[3], 0,
				    control_resp_priority)
				      /* entrypt = 0 for pure control msg */
		    else SendDelayedMsg(delayedmsg, msgtype, X[2], X[3]);
		    if (Dataptr->querycount == 0)    /* chare is finished */
		         OsKillMyself();    
		}
		PC++;
		break;

	case CheckResponse:
		/* arg 0 is the succeeding node for the response arc */
		/* arg 1 gives the status bits for the calling clause */
		{
		    SHORT nextnode = Instr[PC].arg[0];

		    Msgptr->statusbits = Instr[PC].arg[1];
		    ptrGS = (GOALSLOT *) Msgptr->goalSlot;
		    ptrQ = ptrGS->ptrQ;
		    CTuple = Msgptr->goalResp;   /* resp tuple is new ctuple */
		    /* msgtype is RESP DATA */
		    {
			contexttupused = FALSE;
			allbuiltins = FALSE;
			ptrGS->respRecv++;
			if (DEBUG)
			{
			    OsPrintf("CheckResponse %d: goal slot = %x, clauseNum = %d, respRecv = %d, nodeVec = %d\n",
				     nextnode, ptrGS, ptrGS->clauseNum,
				     ptrGS->respRecv, ptrQ->nodeVec);
			    OsPrintf("active tuples %d\n",
				     ptrQ->activeTnum[ptrGS->preNode]);
			}
		    }
		}
		PC++;
		break;


	case SwitchOnTerm:
		/* arg 0 gives the jump address for first term = constant */
		/* arg 1 gives the jump address for first term = Atom */
		/* arg 2 gives the jump address for first term = List */
		/* arg 3 gives the jump address for first term = Structure */
		if (seqexecution)
		{
		    switchterm = &PTerm[1];
		    Deref_Term(switchterm, PTuple);
		}
		else
		{
		    switchterm = &(Msgptr->goalterm[1]);
		    Deref_Term(switchterm, Msgptr->goalResp);
		}
		/* no break - fall into next case */

	case TryMeElse:
		/* arg 0 gives the jump address for first term = constant */
		/* arg 1 gives the jump address for first term = Atom */
		/* arg 2 gives the jump address for first term = List */
		/* arg 3 gives the jump address for first term = Structure */
#ifdef IPSC2
		TryMeElseProc();
#else
		switch (SLOT_TAG(switchterm))
		{
		case TUPLE_INDEX_1:
		    PC++;
		    break;
		case FUNCTOR:
		case CLOSED_TERM:
		    if (ARITY_IS_ZERO(switchterm))
		         PC = Instr[PC].arg[1];
		    else if (GET_FUNCTOR(switchterm) == CONS)
		         PC = Instr[PC].arg[2];
		    else PC = Instr[PC].arg[3];
		    break;
		case MOLECULE:
		    {
			MOLECULE_PTR *molecule;

			molecule = MOLECULE_ADDRESS(switchterm);
			switchterm = TERMS(molecule);
			if (GET_FUNCTOR(switchterm) == CONS)
			     PC = Instr[PC].arg[2];
			else PC = Instr[PC].arg[3];
		    }
		    break;
		case SEQ_MOLECULE:
		    {
			MOLECULE_PTR *molecule;

			molecule = SEQ_MOLECULE_ADDRESS(switchterm);
			switchterm = TERMS(molecule);
			if (GET_FUNCTOR(switchterm) == CONS)
			     PC = Instr[PC].arg[2];
			else PC = Instr[PC].arg[3];
		    }
		    break;
		case INTEGER:
		case REAL:
		    PC = Instr[PC].arg[0];
		    break;
		default: 
		    OsPrint("illegal slot tag in term during switch on term\n");
		}
		if (PC < 0)
		   if (seqexecution)
		   {
		       VV->FL = -2;  /* fail this predicate */
		       FAIL()
		   }
		   else suspend = TRUE;
#endif
		break;

/****************************************************************************/
/*              CODE FOR SEQUENTIAL COMPONENT OF ROLOG COMPILER             */
/****************************************************************************/

	case EnterSeqCode:
		/* initialize the registers and put the parent environment
		   on the stack */
		{
		    SLOT *tuple = Msgptr->goalResp;
		    SHORT tuplesize;

#ifdef SHARED
		    Trail = &SeqTrail[MAXTRAILSIZE * MyPenum];
		    Stack  = &SeqStack[MAXSTACKSIZE * MyPenum];
#else
		    Trail = SeqTrail;
		    Stack = SeqStack;
#endif
		    StackLimit = &Stack[MAXSTACKSIZE];
		    TR = Trail;
		    seqexecution = TRUE;		    
		    tuplesize = TUPLESIZE(tuple);
		    PTerm = Msgptr->goalterm;
		    PTuple = (SLOT *) Stack;    
		    INSERT_TUPLE_SIZE(PTuple, tuplesize);
		    for (i = 1; i < tuplesize; i++)  
			switch (SLOT_TAG(&tuple[i]))
			{
			case TUPLE_INDEX_2:
			    OsPrint("ERROR! Tuple index 2 in seq code...aborting...\n");
			    exit(1);
			case TERM_SPC_INDEX_1:
			    INSERT_ADDRESS(&PTuple[i], &term_space[INDEX(&tuple[i])]);
			    break;
			case RELATIVE_INDEX:
			    INSERT_ADDRESS(&PTuple[i], &tuple[i+INDEX(&tuple[i])]);
			    break;
			default:
			    PTuple[i] = tuple[i];   
			    break;
			}
		    if (SEQ_DEBUG)
		    {
			OsPrint("Loaded ptuple on stack:\n");
			BePrintTuple(PTuple);
		    }
		    TOS = &PTuple[tuplesize];
		    V = VV = (ContInfo *) TOS;
		    V->Cont = Msgptr->respEP;
		    V->PrevChoicePt = NULL;    /* out of sequential section */
		    V->ContRecord = NULL;    /* out of sequential section */
		}
		if (DEBUG || SEQ_DEBUG)
		    OsPrintf("Entered sequential code - init. complete\n");
		PC++;
		break;

	case Enter:
		/* arg 0 is the address of the child term (clause head)*/
		/* arg 1 is the number of variables in the fact/clause */
		/* arg 2 is the fail address for this fact/clause */

		TOS = (LONG *)(V + 1) + Instr[PC].arg[1] + 1;
		if (TOS >= StackLimit)
		{
		    OsPrint("Stack overflow in sequential component\n");
		    OsPrint("Execution aborted at PC %d\n",PC);
		    OsPrint("TOS is %x, Stack limit is %x\n", 
			     TOS, StackLimit);
		    OsKillSys();
		    suspend = TRUE;
		}
		else if (SEQ_DEBUG)
		{
		    OsPrint("Size of sequential stack is %d\n", TOS - Stack);
		    OsPrint("Size of sequential trail is %d\n", TR  - Trail);
		}
		CTerm = (SLOT *) Instr[PC].arg[0];  
		nextterm = 0;
		FL = Instr[PC].arg[2];
		/* create a new environment */
		V->TR = TR;
		V->PTerm = PTerm;
		V->PTuple = PTuple;
		V->FL = FL;
		CTuple = (SLOT *) (V + 1);
		INSERT_TUPLE_SIZE(CTuple, (Instr[PC].arg[1] + 1));
		/* for now - I am playing it safe */
		for (i = 1; i <= Instr[PC].arg[1]; i++)
		    INSERT_SLOT_TAG(&CTuple[i], UNBOUND_VAR);
		if (SEQ_DEBUG)
		{
		    OsPrint("Enter: unifying clause ");
		    PrintTerm(PTerm, PTuple);
		    OsPrint(" with ");
		    PrintTerm(CTerm, CTuple);
		    OsPrint("\n");
		}

		PC++;
		break;

	case Call:
		/* arg 0 gives the address of the parent goal */
		/* arg 1 gives the jump address */
		{
		    ContInfo *tempAR = V;

		    V  = (ContInfo *) TOS;
		    PTerm = (SLOT *) Instr[PC].arg[0];
		    PTuple = CTuple;
		    V->Cont = PC+1;
		    V->PrevChoicePt = VV;
		    V->ContRecord = tempAR;
		    V->PTerm = PTerm;
		    V->PTuple = PTuple;
		    VV = V;
		    PC = Instr[PC].arg[1];
		    if (SEQ_DEBUG)
		    {
			OsPrint("Call: to instruction %d with goal ", PC);
			PrintTerm(PTerm, PTuple);
			OsPrint("\n");
			OsPrint("Current bindings are:\n");
			BePrintTuple(PTuple);
		    }
		}
		break;

	case Return:    /* successful return */
		/* arg 0 gives the number of chains a response tuple to
		   parallel component may belong to in a join arc */
		if (SEQ_DEBUG)
		     OsPrint("Return to instruction %d\n",V->Cont);
		CTuple = V->PTuple;
		if (V->PrevChoicePt == NULL)  /* resp for nonseq comp. */
		{
		    PVECTOR *resp_priority = NULLPTR;

		    X[2]++;   /* no of responses */
		    CreateRespForNonSeq(Msgptr->goalResp, CTuple, Y);
		    Malloc_ArcTuple(RTuple, TUPLESIZE(Y), Instr[PC].arg[0]);
		    for (i = 0; i < TUPLESIZE(Y); i++)
		         RTuple[i] = Y[i];
		    if (SEQ_DEBUG)
		    { 
			OsPrint("Found solution during seq. execution\n");
			OsPrint("Sending response tuple: \n");
			BePrintTuple(RTuple);
			OsPrint("looking for more solutions....\n");
		    }  
#ifdef PRIORITY
		    	 PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, resp_priority);
#endif
		    if ( Msgptr->statusbits & STAT_DET)
		    {
		         SendRespMsg((MSGTYPE_RESPDATA | MSGTYPE_RESPCNUM |
				MSGTYPE_RESPRNUM), MSGCHAREID(Msgptr),
				MSGGSLOT(Msgptr), RTuple, 1,1, Msgptr->respEP,
				resp_priority)
			 suspend = TRUE;
		    }
		    else 
		    {
			DelayRespMsg(MSGTYPE_RESPDATA, MSGCHAREID(Msgptr),
				MSGGSLOT(Msgptr), RTuple, 0,0,
				Msgptr->respEP, delayedmsg, resp_priority);
			FAIL();
		    }
		}
		else 
		{
		    FL = V->FL;
		    PC = V->Cont;
		    V = V->ContRecord;
		}
		break;


	case Cut:
		VV->FL = -2;   /* fail it next time around */
		if (VV != V)
		    VV->PrevChoicePt = V; 
		PC++;
		break;

	case SUnify1stVar:
		/* arg 0 is the index of the first occurrence of variable */
#ifdef IPSC2
		SUnify1stVarProc();
#else
		{
		    MOLECULE_PTR *molecule;
		    
		    CTerm = &CTuple[Instr[PC].arg[0]];
		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(PSubterm))
		    {
		    case TUPLE_INDEX_1:
			PSubterm = &PTuple[INDEX(PSubterm)];
			/* fall into next case */
		    case UNBOUND_VAR:
			/* orient from child to parent */
			if (CTerm != PSubterm)
			{
			    *TR++ = CTerm;
			    INSERT_ADDRESS(CTerm, PSubterm);
			}
			break;
		    case SEQ_MOLECULE:
			*TR++ = CTerm;
			COPY_SEQ_MOLECULE(CTerm, PSubterm, StackLimit);
			break;
		    case CLOSED_TERM:
			*TR++ = CTerm;
			if ( ARITY_IS_ZERO(PSubterm))
			     COPY_ATOM(CTerm, PSubterm);
			else INSERT_ADDRESS(CTerm, PSubterm);
			break;
		    case MOLECULE:
			*TR++ = CTerm;
			molecule = MOLECULE_ADDRESS(PSubterm);
			COPY_MOLECULE(CTerm, PSubterm, molecule);
			break;
		    case FUNCTOR:
			*TR++ = CTerm;
			ALLOC_SEQ_MOLECULE(CTerm, molecule,StackLimit);
			INSERT_MOLEC_TERMS(molecule, PSubterm);
			INSERT_MOLEC_TUPLE(molecule, PTuple);
			break;
		    case INTEGER:
	    case REAL:
			*TR++ = CTerm;
			COPY_ATOM(CTerm, PSubterm);
			break;
		    default:
			OsPrintf("error! illegal slot_tag in SUnify1stVar\n");
			suspend = TRUE;
		    }
		    PC++;
		}
#endif
		break;

	case SUnifyVar:
		/* arg 0 is the index of the variable in CTuple */
#ifdef IPSC2
		SUnifyVarProc();
#else
		{
		    MOLECULE_PTR *molecule;
		    SLOT *tempPTuple, *tempCTuple;
		    
		    CTerm = &CTuple[Instr[PC].arg[0]];
		    Deref_Term(CTerm, CTuple);
		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(CTerm))
		    {
		    case TUPLE_INDEX_1:
			 CTerm = &CTuple[INDEX(CTuple)];
			 /* no break - drop into next case */
		    case UNBOUND_VAR:
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    PSubterm = &PTuple[INDEX(PSubterm)];
			    /* fall into next case */
			case UNBOUND_VAR:
			    /* orient from child to parent */
			    if (CTerm != PSubterm)
			    {
				*TR++ = CTerm;
			        INSERT_ADDRESS(CTerm, PSubterm);
			    }
			    break;
			case SEQ_MOLECULE:
			    *TR++ = CTerm;
			    COPY_SEQ_MOLECULE(CTerm, PSubterm, StackLimit);
			    break;
			case CLOSED_TERM:
			    *TR++ = CTerm;
			    if ( ARITY_IS_ZERO(PSubterm))
			         COPY_ATOM(CTerm, PSubterm);
			    else INSERT_ADDRESS(CTerm, PSubterm);
			    break;
			case MOLECULE:
			    *TR++ = CTerm;
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    COPY_MOLECULE(CTerm, PSubterm, molecule);
			    break;
			case FUNCTOR:
			    *TR++ = CTerm;
			    ALLOC_SEQ_MOLECULE(CTerm, molecule,StackLimit);
			    INSERT_MOLEC_TERMS(molecule, PSubterm);
			    INSERT_MOLEC_TUPLE(molecule, PTuple);
			    break;
			case INTEGER:
			case REAL:
			    *TR++ = CTerm;
			    COPY_ATOM(CTerm, PSubterm);
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
			    suspend= TRUE;
			}
			PC++;
			break;

		    case MOLECULE:
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    PSubterm = &PTuple[INDEX(PSubterm)];
			    /* continue into next case */
			case UNBOUND_VAR:
			    COPY_SLOT(PSubterm, CTerm);
			    *TR++ = PSubterm;
			    PC++;
			    break;
			case SEQ_MOLECULE:
			    molecule = MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    molecule = SEQ_MOLECULE_ADDRESS(PSubterm);
			    PSubterm = TERMS(molecule);
			    tempPTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,tempPTuple, CTerm,
					 tempCTuple, TRUE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    molecule = MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,PTuple, CTerm,tempCTuple, 
					 TRUE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case MOLECULE:
			    molecule = MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    PSubterm = TERMS(molecule);
			    tempPTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,tempPTuple, CTerm,
					 tempCTuple, TRUE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case INTEGER:
			case REAL:
			    FAIL();
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
			    suspend = TRUE;
			}			
			break;

		     case SEQ_MOLECULE:
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    PSubterm = &PTuple[INDEX(PSubterm)];
			    /* continue into next case */
			case UNBOUND_VAR:
			    COPY_SEQ_MOLECULE(PSubterm, CTerm, StackLimit);
			    *TR++ = PSubterm;
			    PC++;
			    break;
			case SEQ_MOLECULE:
			    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    molecule = SEQ_MOLECULE_ADDRESS(PSubterm);
			    PSubterm = TERMS(molecule);
			    tempPTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,tempPTuple, CTerm,
					 tempCTuple, FALSE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,PTuple, CTerm,tempCTuple, 
					 FALSE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case MOLECULE:
			    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    PSubterm = TERMS(molecule);
			    tempPTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,tempPTuple, CTerm,
					 tempCTuple, TRUE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case INTEGER:
			case REAL:
			    FAIL();
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
			    suspend = TRUE;
			}
			break;

		    case FUNCTOR:
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    PSubterm = &PTuple[INDEX(PSubterm)];
			    /* continue into next case */
			case UNBOUND_VAR:
			    ALLOC_SEQ_MOLECULE(PSubterm, molecule,StackLimit);
			    INSERT_MOLEC_TERMS(molecule, CTerm);
			    INSERT_MOLEC_TUPLE(molecule, CTuple);
			    *TR++ = PSubterm;
			    PC++;
			    break;
			case SEQ_MOLECULE:
			    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm, PTuple, CTerm,
					 tempCTuple, FALSE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    if (SeqUnify(PSubterm,PTuple, CTerm,CTuple, 
					 FALSE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case MOLECULE:
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    PSubterm = TERMS(molecule);
			    tempPTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,tempPTuple, CTerm,
					 CTuple, TRUE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case INTEGER:
			case REAL:
			    FAIL();
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
			    suspend = TRUE;
			}

		     case CLOSED_TERM:
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    PSubterm = &PTuple[INDEX(PSubterm)];
			    /* continue into next case */
			case UNBOUND_VAR:
			    INSERT_ADDRESS(PSubterm, CTerm);
			    *TR++ = PSubterm;
			    PC++;
			    break;
			case SEQ_MOLECULE:
			    molecule = SEQ_MOLECULE_ADDRESS(CTerm);
			    CTerm = TERMS(molecule);
			    tempCTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm, PTuple, CTerm,
					 tempCTuple, FALSE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case FUNCTOR:
			case CLOSED_TERM:
			    if (SeqUnify(PSubterm,PTuple, CTerm,CTuple, 
					 FALSE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case MOLECULE:
			    molecule = MOLECULE_ADDRESS(PSubterm);
			    PSubterm = TERMS(molecule);
			    tempPTuple = TUPLE(molecule);
			    if (SeqUnify(PSubterm,tempPTuple, CTerm,
					 CTuple, TRUE, Stack, &TR, &StackLimit))
			         PC++;
			    else FAIL();
			    break;
			case INTEGER:
			case REAL:
			    FAIL();
			    break;
			default:
			    OsPrintf("error! illegal slot_tag in SUnifyVar\n");
			    suspend = TRUE;
			}
			break;

		     case INTEGER:
			switch (SLOT_TAG(PSubterm))
			{
			case TUPLE_INDEX_1:
			    PSubterm = &PTuple[INDEX(PSubterm)];
			    /* continue into next case */
			case UNBOUND_VAR:
			    COPY_SLOT(PSubterm, CTerm);
			    *TR++ = PSubterm;
			    PC++;
			    break;
			case SEQ_MOLECULE:
			    FAIL();
			    break;
			case INTEGER:
			    if (INTVALUE(PSubterm) != INTVALUE(CTerm))
			        FAIL()
			    else PC++;
			    break;
			default:
			    FAIL();
			}
			break;

		     default:
			 FAIL();
		     }
		}
#endif
		break;

	case SUnifyStrct:
		/* arg 0 is the address of structure being unified */
		/* arg 1 is the jump address for the next argument */
		/* arg 2 is the depth of the structure being unified */
#ifdef IPSC2
		SUnifyStrctProc();
#else
		{
		    MOLECULE_PTR *molecule;
		    
		    TOMstack = 4 * Instr[PC].arg[2];  
		    CTerm = (SLOT *) Instr[PC].arg[0];
		    Mstack[TOMstack++] = PTuple; /* stack current PTuple
						   upon entry into struct */
		    Mstack[TOMstack++] = (SLOT *)++nextterm;
		    Mstack[TOMstack++] = (SLOT *)PSubtermground;
		    Mstack[TOMstack++] = PTerm;
		    PTerm = &PTerm[nextterm];
		    Deref_Term(PTerm, PTuple);
		    switch (SLOT_TAG(PTerm))
		    {
		    case TUPLE_INDEX_1:
			PTerm = &PTuple[INDEX(PTerm)];
			/* fall into next case */
		    case UNBOUND_VAR:
			if (TAG_IS_CLOSED_TERM(CTerm))
			     INSERT_ADDRESS(PTerm, CTerm)
			else 
			{
			    ALLOC_SEQ_MOLECULE(PTerm, molecule,StackLimit);
			    INSERT_MOLEC_TERMS(molecule, CTerm);
			    INSERT_MOLEC_TUPLE(molecule, CTuple);
			}
			*TR++ = PTerm;
			PTerm = Mstack[--TOMstack];
			TOMstack -= 3;    /* pop the stack - nexterm and 
					    PTuple unchanged */
			PC = Instr[PC].arg[1];   /* next argument */
			break;

		    case MOLECULE:
		    case SEQ_MOLECULE:
			if (TAG_IS_MOLECULE(PTerm))
			{
			    molecule = MOLECULE_ADDRESS(PTerm);
			    PSubtermground = TRUE;
			}
			else molecule = SEQ_MOLECULE_ADDRESS(PTerm);

			PTerm = TERMS(molecule);
			PTuple = TUPLE(molecule);

			/* no break. Fall into next case */

		    case FUNCTOR:
		    case CLOSED_TERM:
			if ((ARITY(PTerm) == ARITY(CTerm)) &&
			    (GET_FUNCTOR(PTerm) == GET_FUNCTOR(CTerm)))
			{
			    PC++;
			    nextterm = 0;
			}
			else FAIL();
			break;

		    default:
			FAIL();
		    }
		}
#endif
		break;

	case SUnifyAtom:
		/* arg 0 is an atomic functor (arity 0). */
		{
		    SLOT  *atom = (SLOT *) Instr[PC].arg[0];

		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(PSubterm))
		    {
		    case TUPLE_INDEX_1:
			PSubterm = &PTuple[INDEX(PSubterm)];
			/* fall into next case */
		    case UNBOUND_VAR:
			COPY_ATOM(PSubterm, atom);
			*TR++ = PSubterm;
			PC++;
			break;
			
		    case FUNCTOR:
		    case CLOSED_TERM:
			if (!ARITY_IS_ZERO(PSubterm) ||
			    (GET_FUNCTOR(PSubterm) != GET_FUNCTOR(atom)))
			     FAIL()
			else PC++;
			break;

		    default:
			FAIL();
		    }
		}
		break;

	case SUnifyGround:
		/* do not generate this in practice yet - postponed */
		PC++;
		break;

	case SUnifyCon:
		/* arg 0 is the constant */
		{
		    PSubterm = &PTerm[++nextterm];
		    Deref_Term(PSubterm, PTuple);
		    switch (SLOT_TAG(PSubterm))
		    {
		    case TUPLE_INDEX_1:
			PSubterm = &PTuple[INDEX(PSubterm)];
			/* fall into next case */
		    case UNBOUND_VAR:
			INSERT_INTEGER(PSubterm, Instr[PC].arg[0]);
			*TR++ = PSubterm;
			PC++;
			break;

		    case INTEGER:
			if (INTVALUE(PSubterm) != Instr[PC].arg[0])
			    FAIL()
			else PC++;
			break;

		    case REAL:
			if (REALVALUE(PSubterm) != Instr[PC].arg[0])
			    FAIL()
			else PC++;
			break;

		    default:
			FAIL();
		    }
		}
		break;


/****************************************************************************/
/*             END OF SEQUENTIAL COMPONENT OF ROLOG COMPILER 		    */
/****************************************************************************/


	default:
		/* do nothing */ ;
        }

    if (seqexecution)
    {
	 PVECTOR	*resp_priority = NULLPTR;

#ifdef PRIORITY
	 PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, resp_priority);
#endif

	if (!(Msgptr->statusbits & STAT_DET) || X[2] == 0)  /* no solns */
	    if (delayedmsg == NULL)   /* no solutions */
	        SendRespMsg(MSGTYPE_RESPCNUM,MSGCHAREID(Msgptr), 
			    MSGGSLOT(Msgptr), NULL, 0, 0, 0, resp_priority)
				      /* entrypt = 0 for pure control msg */
	    else SendDelayedMsg(delayedmsg, 
			      (MSGTYPE_RESPCNUM | MSGTYPE_RESPRNUM),X[2], 1);
	OsKillMyself();  
	if (DEBUG || SEQ_DEBUG)
	{  
	    OsPrint("no. of solutions found = %d\n", X[2]);
	    OsPrint("No more solutions\n");
	    OsPrint("End of sequential execution\n");
	} 
    }
    else if (PC < 0 &&     /*  clause failed on builtin */
	     ptrQ->nodeVec == 0)   /* the query is actually done */
    {
	 PVECTOR	*resp_priority = NULLPTR;

#ifdef PRIORITY
	 PGEN_IDENTICAL_PVECTOR(Msgptr->priority_vector, resp_priority);
#endif

         SendRespMsg(MSGTYPE_RESPRNUM, QUERYCHAREID(Msgptr), ptrQ->parentGnum,
		     NULL, ptrQ->respNum, 0, 0, resp_priority);
				      /* entrypt = 0 for pure control msg */
	 OsKillMyself();  
	 if (DEBUG)	 
	     OsPrint("builtin failed. sending response message to parent\n");
    }
}




#ifdef IPSC2
#include "ipsc2.c"
#endif


