

/***************************************************************************/
/* This is the main process that runs on each pe 			   */
/* EXPORTS: nothing                                                        */
/*									   */
/* IMPORTS: 	void OsMcDepInit();					   */
/* 		MESSAGE *OsNextWorkPiece();				   */
/*		void RopmConsume(GOAL_OR_RESP *message);		   */
/*              void BePrintGoal(GOAL_OR_RESP *goalResp);                  */
/*		void BePrintResponse(GOAL_OR_RESP *goalResp);              */
/***************************************************************************/


#include "typedefs.h"
#include "gen.h"
#include "macros.c"
#include "msgmacros.c"
#include "seq_macros.c"

extern Instruction *Instr;
char OPSNAME[] = "ops";
char PROLOGNAME[] = "prolog.file";

int	packedGoal=0;

UsrHostInit(argc, argv) 
int argc;
char **argv;
{
    extern SPINLOCK memLock1, memLock2;
    extern LONG *SeqStack, **SeqTrail;
    extern LONG maxTerm, MAXSTACKSIZE, MAXTRAILSIZE;
    extern BOOLEAN PRINT_SOL_TIMES;
    extern int numPe;
    MESSAGE *pMsg;
    SHORT i;

    OsSpinInit(memLock1);
    OsSpinInit(memLock2);
    for( i=0; i<argc; i++ ) {
	if( strcmp( argv[i], "-T" ) == 0 && i+1 < argc ) {
	    sscanf(argv[++i],"%d", &maxTerm) ;
	    printf("ROLOG: term space set to %dK\n", maxTerm);
	    maxTerm *= 1000;
	}
	else if( sscanf( argv[i], "-T%d", &maxTerm ) == 1 ) {
	    printf("ROLOG: term space set to %dK\n", maxTerm);
	    maxTerm *= 1000;
	}
	else if( strcmp( argv[i], "-S" ) == 0 && i+1 < argc ) {
	    sscanf(argv[++i], "%d", &MAXSTACKSIZE);
	    printf("ROLOG: sequential stack size set to %dK\n", MAXSTACKSIZE);
	    MAXSTACKSIZE *= 1000;
	}
	else if ( sscanf( argv[i], "-S%d", &MAXSTACKSIZE)) {
	    printf("ROLOG: sequential stack size set to %dK\n", MAXSTACKSIZE);
	    MAXSTACKSIZE *= 1000;
	}
	else if( strcmp( argv[i], "-Tr" ) == 0 ) {
	    sscanf(argv[++i], "%d", &MAXTRAILSIZE);
	    printf("ROLOG: sequential trail size set to %dK\n", MAXTRAILSIZE);
	    MAXTRAILSIZE *= 1000;
	}
	else if ( sscanf( argv[i], "-Tr%d", &MAXTRAILSIZE)) {
	    printf("ROLOG: sequential trail size set to %dK\n", MAXTRAILSIZE);
	    MAXTRAILSIZE *= 1000;
	}
	else if( strcmp( argv[i], "-Prt" ) == 0 ) {
	    PRINT_SOL_TIMES = TRUE;
	    printf("ROLOG: execution time will be printed for every solution\n");
	}

    }
    LoadFiles(argc, argv);
    SeqStack = (LONG *)  OsAllocInit(sizeof(LONG) * MAXSTACKSIZE  * numPe);
    if (SeqStack == NULL)
    {
	OsPrint("error during initialization in memory allocation\n");
	OsPrint("execution aborted\n");
	exit(1);
    }
    SeqTrail = (LONG **) OsAllocInit(sizeof(LONG *) * MAXTRAILSIZE * numPe);
    if (SeqTrail == NULL)
    {
	OsPrint("error during initialization in memory allocation\n");
	OsPrint("execution aborted\n");
	exit(1);
    }

    pMsg = (MESSAGE *) OsAllocMsg(sizeof(MESSAGE));
#ifdef PRIORITY
    pMsg->priority_vector = (PVECTOR *) OsAlloc(sizeof(PVECTOR));
    *pMsg->priority_vector = 0;
    CreateChareGen(ENTRYPT_FIRST, pMsg, sizeof(MESSAGE), 0, pMsg->priority_vector, FALSE);
#else
    CreateChareGen(ENTRYPT_FIRST, pMsg, sizeof(MESSAGE), 0, 0, FALSE);
#endif
    printf("First chare sent to node %d\n", MyPenum);
}

UsrNodeInit()
{
}



UsrPrg(Entrypt, Msgptr, Dataptr)
int Entrypt;
MESSAGE *Msgptr;
LocalArea *Dataptr;
{
    extern Instruction *Instr;
    SHORT bcentrypt = Msgptr->BCEntrypt;

    if (Entrypt == ENTRYPT_FIRST)
    {
	MESSAGE *pMsg;
	int CDsize;
	PVECTOR *Priority;

	OsPrint("ROLOG Version 1.0\n\n");
	UsrInitMsg(&pMsg,&CDsize);
	Priority = pMsg->priority_vector;
	CreateChareGen(ENTRYPT_REST,pMsg, sizeof(MESSAGE), CDsize, Priority, FALSE);
	OsKillMyself();  
    }
    else  /* Entrypt = ENTRYPT_REST */
    {
	if (DEBUG)
	{
	    int i;

	    OsPrintf("message has term 0x%x\n",Msgptr->goalterm);
	    OsPrintf("PE %d :Instr %d has opcode %d, numargs %d, args: ", 
		     MyPenum, bcentrypt, Instr[bcentrypt].opcode, 
		     Instr[bcentrypt].argCount);
	    for (i = 0; i < Instr[bcentrypt].argCount; i++)
	        OsPrintf("%d ", Instr[bcentrypt].arg[i]);
	    OsPrintf("\n");
	}
 	if (bcentrypt > 0)    /* valid entry point */
 	    BCInterp(bcentrypt, Msgptr, Dataptr);
	if (MSGMAINTYPE(Msgptr) == MSGTYPE_RESP)
	    RopmRespCheck(Msgptr, Dataptr);
    }
#ifdef PRIORITY
    if (Msgptr->priority_vector != NULLPTR)
    	OsFree(Msgptr->priority_vector); /* Free up the priority vector */
#endif
    Free_Message(Msgptr); 
}



UsrSetReadVar(ppReadVar,pSize,str)
char **ppReadVar,*str;
int  *pSize;
{
    if (str == NULLPTR) /* take the default name */
	str = PROLOGNAME;
    ReadInputForPgm(str,ppReadVar,pSize);
}



UsrGetReadVar(pReadVar,size)
int *pReadVar;
int  size;
{
    extern LONG next_term;

    SET_P_C_MARKER();
}

ReadInputForPgm(str,ppBuf,pSize)
char *str;
int  **ppBuf,*pSize;
{
}

delay(x)
int x;
{	int i,j;
	for (i=0; i < 1000; i++)
	    for (j=0; j<x; j++)
		;
}

UsrPackMsg(code,ptrMsg,ptrNew,pSize,maxSize)
MESSAGE *ptrMsg, *ptrNew;
int	code,*pSize,maxSize;
{
    MESSAGE *PackMessage();

    COPY_MESSAGES(ptrNew,ptrMsg); 
    *pSize = sizeof(MESSAGE);
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL  || IS_RESP_DATA(ptrMsg)) 
    PackMessage(ptrMsg,ptrNew,pSize);

    if (*pSize >= maxSize) {
	OsPrintf("pack buffer is too small, need %d\n",*pSize);
	OsKillSys();
	}
}

UsrUnpackMsg(code,ptrMsg)
MESSAGE *ptrMsg;
int code;
{
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL || IS_RESP_DATA(ptrMsg))
          UnpackMessage(ptrMsg);
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL)  packedGoal++;
/*
    if (MSGMAINTYPE(ptrMsg) == MSGTYPE_GOAL)  {
	TRACE(OsPrintf(","));
	TRACE(BePrintGoal(MSGGOAL(ptrMsg))); 
	}
    else if(MSGMAINTYPE(ptrMsg) == MSGTYPE_RESP) {
	TRACE(OsPrintf(";"));
	TRACE(BePrintResponse(MSGRESP(ptrMsg)));
 	}
*/
}


UsrInitMsg(pMsg, CDsize)
MESSAGE **pMsg;
int *CDsize;  /* not used in ROPM */

{
    SLOT *term;
    SLOT *tuple;
    MESSAGE *RopmFirstMsg();


    Malloc_Slots(term,1);
    INSERT_CLOSED_TERM(term, MainFunctor(), 0);
    *pMsg = (MESSAGE *) RopmFirstMsg();
    (*pMsg)->goalterm = term;
    (*pMsg)->BCEntrypt = MainEntryPt();
    if (MainEntryPt() == -1)
    {
	OsPrintf("no query in program.\n");
	exit();
    }
    if (DEBUG)
       OsPrintf("address of top level term is %x\n",term);
    *CDsize = sizeof(LocalArea);
}
