#include "typedefs.h"
#include "msgmacros.c"
#include "macros.c"
#include "be_macros.c"


void CreatePackedTerm(oldterm, oldtuple, newterm, thrumolecule)
SLOT *oldterm;
SLOT *oldtuple;
SLOT **newterm;
BOOLEAN thrumolecule;

{
    SLOT *nextslot = *newterm;
    SLOT *currentslot;
    MOLECULE_PTR *molecule; 
    SLOT *CopyOneSweep();
    SHORT i;
    SHORT termindex, arity= ARITY(oldterm);

    *newterm = CopyOneSweep(oldterm, nextslot);
    if (thrumolecule)
       INSERT_CLOSED_TERM(nextslot, GET_FUNCTOR(oldterm), ARITY(oldterm));
    /* SET_REF_COUNT_ONE(nextslot); */
    nextslot++;
    if (arity > 0)
	for (i = 1; i <= arity ; i++,nextslot++)
	{   
	    currentslot = &oldterm[i];
	    if (thrumolecule)
	       Deref_Term(currentslot, oldtuple);
	    switch (SLOT_TAG(currentslot))
	    { 
	    case ABSOLUTE_ADDRESS:
			INSERT_INDEX(nextslot, (*newterm - nextslot), RELATIVE_INDEX);
			CreatePackedTerm(ABS_ADDRESS(currentslot), oldtuple, newterm, thrumolecule);
			break;
	    case MOLECULE:
			molecule = MOLECULE_ADDRESS(currentslot);
			INSERT_INDEX(nextslot, (*newterm - nextslot), RELATIVE_INDEX);
			CreatePackedTerm(TERMS(molecule), TUPLE(molecule), newterm, TRUE);
			break;
	    case FUNCTOR:
	    case CLOSED_TERM:
			if (ARITY_IS_ZERO(currentslot))
			        *nextslot = *currentslot & ~0x07E0;
			else if (((termindex = currentslot - term_space) < PURE_CODE_MARKER) && !thrumolecule)
				INSERT_INDEX(nextslot, termindex, TERM_SPC_INDEX_1);  
			else
			{ 
			    INSERT_INDEX(nextslot, (*newterm - nextslot), RELATIVE_INDEX);
			    CreatePackedTerm(currentslot, oldtuple, newterm, thrumolecule);
			}
			break;
	    case TUPLE_INDEX_2:
			OsPrintf("error! TUPLE_INDEX 2 found in term being packed\n");
			break;
	    case RELATIVE_INDEX:
			INSERT_INDEX(nextslot, (*newterm - nextslot), RELATIVE_INDEX);
			CreatePackedTerm((currentslot + INDEX(currentslot)), oldtuple, newterm, thrumolecule);
			break;
	    case TERM_SPC_INDEX_1:
			if (ARITY_IS_ZERO(&(term_space[INDEX(currentslot)])))
			        *nextslot = term_space[INDEX(currentslot)] & ~0x07E0;
			else if ((INDEX(currentslot) < PURE_CODE_MARKER) && !thrumolecule)
				INSERT_INDEX(nextslot, termindex, TERM_SPC_INDEX_1);   
			else
			{ 
			    INSERT_INDEX(nextslot, (*newterm - nextslot), RELATIVE_INDEX);
			    CreatePackedTerm(&(term_space[INDEX(currentslot)]), oldtuple, newterm, thrumolecule);
			}
			break;
	    case TERM_SPC_INDEX_2:
			OsPrintf("error! TERM_SPACE_INDEX 2 found in term being packed\n");
			break;
	    case INTEGER:
			COPY_ATOM(nextslot, currentslot);
			break;
	    case REAL:
			INSERT_INDEX(nextslot, (*newterm - nextslot), RELATIVE_INDEX);
			COPY_REAL(*newterm, currentslot);
			(*newterm)++;
			break; 
	    default:
			break;
	    }
	} 	/* for */
}




MESSAGE *PackMessage(msg, packed_msg, length)
MESSAGE *msg;
MESSAGE *packed_msg;
SHORT *length;

{
    SHORT termindex, tupsize, i;
    SLOT  *copied_tuple;
    SLOT *nextslot, *oldtuple, *subterm;
    MOLECULE_PTR *molecule;
    void CreatePackedTerm();

    oldtuple = msg->goalResp;
    tupsize = TUPLESIZE(oldtuple);
    copied_tuple = (SLOT *)(packed_msg + 1);
    copied_tuple += 2;   /* for arc tuple back pointers */
    nextslot = copied_tuple + tupsize;
    if (MSGMAINTYPE(msg) == MSGTYPE_GOAL)
    {
	termindex = msg->goalterm - term_space; 
	if (termindex >= PURE_CODE_MARKER || termindex < 0) 
	    CreatePackedTerm(msg->goalterm,oldtuple, &nextslot, FALSE);
	else 
	{
	    INSERT_INDEX(nextslot, termindex, TERM_SPC_INDEX_1);
	    nextslot++;
	}
    }
    INSERT_TUPLE_SIZE(copied_tuple, tupsize);
    for (i = 1; i < tupsize ; i++)
    {
	subterm = &oldtuple[i];
	Chase_Term(subterm, oldtuple);
	if (TAG_IS_MOLECULE(subterm))
	{
	    INSERT_INDEX(&copied_tuple[i], (nextslot - &copied_tuple[i]), RELATIVE_INDEX);
	    molecule = MOLECULE_ADDRESS(subterm);
	    CreatePackedTerm(TERMS(molecule), TUPLE(molecule), &nextslot, TRUE);
	}
	else if (TAG_IS_FUNCTOR(subterm) && ARITY(subterm) > 0)
	{
	    if ((termindex = (subterm - term_space)) < PURE_CODE_MARKER &&
		 termindex >= 0)
		 INSERT_INDEX(&copied_tuple[i], termindex, TERM_SPC_INDEX_1);
	    else 
	    {
		INSERT_INDEX(&copied_tuple[i], (nextslot - &copied_tuple[i]), RELATIVE_INDEX);
		CreatePackedTerm(subterm, oldtuple, &nextslot, FALSE);
	    }
	}
	else COPY_ATOM(&copied_tuple[i], &oldtuple[i]);
    }
    *length = (nextslot - (SLOT *) packed_msg) * sizeof(SLOT);
    return(packed_msg);
}



void UnpackMessage(message)
MESSAGE *message;

{
    SLOT  *goalResp;
    SLOT *term;
    SHORT tupsize;
    int i;
	
    message->goalResp = goalResp = (SLOT *) (message + 1) + 2; /* for arc tuple
								back pointers */
    tupsize = TUPLESIZE(goalResp);
    if (MSGMAINTYPE(message) == MSGTYPE_GOAL)
    {
	term = goalResp + tupsize;
	if (TAG_IS_TERM_INDEX_1(term))
	     message->goalterm = &term_space[INDEX(term)];
	else message->goalterm = term; 
    } 
    for (i = 1; i < tupsize; i++)
        if (TAG_IS_REL_INDEX(&(goalResp[i])))
	    INSERT_ADDRESS(&goalResp[i], &goalResp[i + INDEX(&goalResp[i])]);
}



